/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CompoundDenseCellName
extends CompoundComposite
implements CellName {
    private static final long HEAP_SIZE = ObjectSizes.measure(new CompoundDenseCellName(new ByteBuffer[0]));

    CompoundDenseCellName(ByteBuffer[] elements) {
        super(elements, elements.length);
    }

    @Override
    public int clusteringSize() {
        return this.size;
    }

    @Override
    public ColumnIdentifier cql3ColumnName() {
        return null;
    }

    @Override
    public ByteBuffer collectionElement() {
        return null;
    }

    @Override
    public boolean isCollectionCell() {
        return false;
    }

    @Override
    public boolean isSameCQL3RowAs(CellName other) {
        return this.equals(other);
    }

    @Override
    public long unsharedHeapSize() {
        return HEAP_SIZE + ObjectSizes.sizeOnHeapOf(this.elements);
    }

    @Override
    public long excessHeapSizeExcludingData() {
        return HEAP_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.elements);
    }

    @Override
    public CellName copy(AbstractAllocator allocator) {
        return new CompoundDenseCellName(this.elementsCopy(allocator));
    }
}

