/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.PoolAllocator;

public interface Composite
extends IMeasurableMemory {
    public int size();

    public boolean isEmpty();

    public ByteBuffer get(int var1);

    public EOC eoc();

    public Composite withEOC(EOC var1);

    public Composite start();

    public Composite end();

    public ColumnSlice slice();

    public boolean isPrefixOf(Composite var1);

    public ByteBuffer toByteBuffer();

    public int dataSize();

    public Composite copy(AbstractAllocator var1);

    public void free(PoolAllocator<?> var1);

    public static enum EOC {
        START,
        NONE,
        END;


        public static EOC from(int eoc) {
            return eoc == 0 ? NONE : (eoc < 0 ? START : END);
        }

        public byte toByte() {
            switch (this) {
                case START: {
                    return -1;
                }
                case NONE: {
                    return 0;
                }
                case END: {
                    return 1;
                }
            }
            throw new AssertionError();
        }
    }
}

