/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.composites.AbstractComposite;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.PoolAllocator;

public class BoundedComposite
extends AbstractComposite {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BoundedComposite(null, false));
    private final Composite wrapped;
    private final boolean isStart;

    private BoundedComposite(Composite wrapped, boolean isStart) {
        this.wrapped = wrapped;
        this.isStart = isStart;
    }

    static Composite startOf(Composite c) {
        return new BoundedComposite(c, true);
    }

    static Composite endOf(Composite c) {
        return new BoundedComposite(c, false);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public ByteBuffer get(int i) {
        return this.wrapped.get(i);
    }

    @Override
    public Composite.EOC eoc() {
        return this.isStart ? Composite.EOC.START : Composite.EOC.END;
    }

    @Override
    public Composite withEOC(Composite.EOC eoc) {
        switch (eoc) {
            case START: {
                return this.isStart ? this : BoundedComposite.startOf(this.wrapped);
            }
            case END: {
                return this.isStart ? BoundedComposite.endOf(this.wrapped) : this;
            }
        }
        return this.wrapped;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer bb = this.wrapped.toByteBuffer();
        bb.put(bb.remaining() - 1, (byte)(this.isStart ? -1 : 1));
        return bb;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.wrapped.unsharedHeapSize();
    }

    @Override
    public Composite copy(AbstractAllocator allocator) {
        return new BoundedComposite(this.wrapped.copy(allocator), this.isStart);
    }

    @Override
    public void free(PoolAllocator<?> allocator) {
        this.wrapped.free(allocator);
    }
}

