/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.SimpleDenseCellNameType;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SuperColumns {
    public static Iterator<OnDiskAtom> onDiskIterator(DataInput in, int superColumnCount, ColumnSerializer.Flag flag, int expireBefore, CellNameType type) {
        return new SCIterator(in, superColumnCount, flag, expireBefore, type);
    }

    public static void deserializerSuperColumnFamily(DataInput in, ColumnFamily cf, ColumnSerializer.Flag flag, int version) throws IOException {
        cf.delete(cf.getComparator().deletionInfoSerializer().deserialize(in, version));
        assert (!cf.deletionInfo().rangeIterator().hasNext());
        Iterator<OnDiskAtom> iter = SuperColumns.onDiskIterator(in, in.readInt(), flag, Integer.MIN_VALUE, cf.getComparator());
        while (iter.hasNext()) {
            cf.addAtom(iter.next());
        }
    }

    private static CellNameType subType(CellNameType type) {
        return new SimpleDenseCellNameType(type.subtype(1));
    }

    public static AbstractType<?> getComparatorFor(CFMetaData metadata, ByteBuffer superColumn) {
        return SuperColumns.getComparatorFor(metadata, superColumn != null);
    }

    public static AbstractType<?> getComparatorFor(CFMetaData metadata, boolean subColumn) {
        return metadata.isSuper() ? metadata.comparator.subtype(subColumn ? 1 : 0) : metadata.comparator.asAbstractType();
    }

    public static ByteBuffer scName(Composite columnName) {
        return columnName.get(0);
    }

    public static ByteBuffer subName(Composite columnName) {
        return columnName.get(1);
    }

    public static Composite startOf(ByteBuffer scName) {
        return CellNames.compositeDense(scName).start();
    }

    public static Composite endOf(ByteBuffer scName) {
        return CellNames.compositeDense(scName).end();
    }

    public static IDiskAtomFilter fromSCFilter(CellNameType type, ByteBuffer scName, IDiskAtomFilter filter) {
        if (filter instanceof NamesQueryFilter) {
            return SuperColumns.fromSCNamesFilter(type, scName, (NamesQueryFilter)filter);
        }
        return SuperColumns.fromSCSliceFilter(type, scName, (SliceQueryFilter)filter);
    }

    public static IDiskAtomFilter fromSCNamesFilter(CellNameType type, ByteBuffer scName, NamesQueryFilter filter) {
        if (scName == null) {
            ColumnSlice[] slices = new ColumnSlice[filter.columns.size()];
            int i = 0;
            for (CellName name : filter.columns) {
                slices[i++] = name.slice();
            }
            return new SliceQueryFilter(slices, false, slices.length, 1);
        }
        TreeSet<Composite> newColumns = new TreeSet<Composite>(type);
        for (CellName c : filter.columns) {
            newColumns.add(type.makeCellName(scName, c.toByteBuffer()));
        }
        return filter.withUpdatedColumns(newColumns);
    }

    public static SliceQueryFilter fromSCSliceFilter(CellNameType type, ByteBuffer scName, SliceQueryFilter filter) {
        Composite start;
        assert (filter.slices.length == 1);
        if (scName == null) {
            Composite start2;
            CBuilder builder = type.builder();
            Composite composite = filter.start().isEmpty() ? Composites.EMPTY : (start2 = builder.buildWith(filter.start().toByteBuffer()).withEOC(filter.reversed ? Composite.EOC.END : Composite.EOC.START));
            Composite finish = filter.finish().isEmpty() ? Composites.EMPTY : builder.buildWith(filter.finish().toByteBuffer()).withEOC(filter.reversed ? Composite.EOC.START : Composite.EOC.END);
            return new SliceQueryFilter(start2, finish, filter.reversed, filter.count, 1);
        }
        CBuilder builder = type.builder().add(scName);
        Composite composite = filter.start().isEmpty() ? builder.build().withEOC(filter.reversed ? Composite.EOC.END : Composite.EOC.START) : (start = builder.buildWith(filter.start().toByteBuffer()));
        Composite end = filter.finish().isEmpty() ? builder.build().withEOC(filter.reversed ? Composite.EOC.START : Composite.EOC.END) : builder.buildWith(filter.finish().toByteBuffer());
        return new SliceQueryFilter(start, end, filter.reversed, filter.count);
    }

    private static class SCIterator
    implements Iterator<OnDiskAtom> {
        private final DataInput in;
        private final int scCount;
        private final ColumnSerializer.Flag flag;
        private final int expireBefore;
        private final CellNameType type;
        private int read;
        private ByteBuffer scName;
        private Iterator<Cell> subColumnsIterator;

        private SCIterator(DataInput in, int superColumnCount, ColumnSerializer.Flag flag, int expireBefore, CellNameType type) {
            this.in = in;
            this.scCount = superColumnCount;
            this.flag = flag;
            this.expireBefore = expireBefore;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.subColumnsIterator != null && this.subColumnsIterator.hasNext() || this.read < this.scCount;
        }

        @Override
        public OnDiskAtom next() {
            try {
                if (this.subColumnsIterator != null && this.subColumnsIterator.hasNext()) {
                    Cell c = this.subColumnsIterator.next();
                    return c.withUpdatedName(this.type.makeCellName(this.scName, c.name().toByteBuffer()));
                }
                ++this.read;
                this.scName = ByteBufferUtil.readWithShortLength(this.in);
                DeletionInfo delInfo = new DeletionInfo(DeletionTime.serializer.deserialize(this.in));
                int size = this.in.readInt();
                ArrayList<Cell> subCells = new ArrayList<Cell>(size);
                ColumnSerializer colSer = SuperColumns.subType(this.type).columnSerializer();
                for (int i = 0; i < size; ++i) {
                    subCells.add(colSer.deserialize(this.in, this.flag, this.expireBefore));
                }
                this.subColumnsIterator = subCells.iterator();
                DeletionTime dtime = delInfo.getTopLevelDeletion();
                if (!dtime.equals(DeletionTime.LIVE)) {
                    return new RangeTombstone(SuperColumns.startOf(this.scName), SuperColumns.endOf(this.scName), dtime);
                }
                return this.next();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

