/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutput out, int version) throws IOException {
        out.writeUTF(sliceCommand.keyspace);
        out.writeUTF(sliceCommand.columnFamily);
        out.writeLong(sliceCommand.timestamp);
        CFMetaData metadata = Schema.instance.getCFMetaData(sliceCommand.keyspace, sliceCommand.columnFamily);
        metadata.comparator.diskAtomFilterSerializer().serialize(sliceCommand.predicate, out, version);
        if (sliceCommand.rowFilter == null) {
            out.writeInt(0);
        } else {
            out.writeInt(sliceCommand.rowFilter.size());
            for (IndexExpression expr : sliceCommand.rowFilter) {
                ByteBufferUtil.writeWithShortLength(expr.column, out);
                out.writeInt(expr.operator.ordinal());
                ByteBufferUtil.writeWithShortLength(expr.value, out);
            }
        }
        AbstractBounds.serializer.serialize(sliceCommand.keyRange, out, version);
        out.writeInt(sliceCommand.maxResults);
        out.writeBoolean(sliceCommand.countCQL3Rows);
        out.writeBoolean(sliceCommand.isPaging);
    }

    @Override
    public RangeSliceCommand deserialize(DataInput in, int version) throws IOException {
        String keyspace = in.readUTF();
        String columnFamily = in.readUTF();
        long timestamp = in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily);
        IDiskAtomFilter predicate = metadata.comparator.diskAtomFilterSerializer().deserialize(in, version);
        int filterCount = in.readInt();
        ArrayList<IndexExpression> rowFilter = new ArrayList<IndexExpression>(filterCount);
        for (int i = 0; i < filterCount; ++i) {
            IndexExpression expr = new IndexExpression(ByteBufferUtil.readWithShortLength(in), IndexExpression.Operator.findByOrdinal(in.readInt()), ByteBufferUtil.readWithShortLength(in));
            rowFilter.add(expr);
        }
        AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
        int maxResults = in.readInt();
        boolean countCQL3Rows = in.readBoolean();
        boolean isPaging = in.readBoolean();
        return new RangeSliceCommand(keyspace, columnFamily, timestamp, predicate, range, rowFilter, maxResults, countCQL3Rows, isPaging);
    }

    @Override
    public long serializedSize(RangeSliceCommand rsc, int version) {
        long size = TypeSizes.NATIVE.sizeof(rsc.keyspace);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.columnFamily);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.timestamp);
        CFMetaData metadata = Schema.instance.getCFMetaData(rsc.keyspace, rsc.columnFamily);
        IDiskAtomFilter filter = rsc.predicate;
        size += metadata.comparator.diskAtomFilterSerializer().serializedSize(filter, version);
        if (rsc.rowFilter == null) {
            size += (long)TypeSizes.NATIVE.sizeof(0);
        } else {
            size += (long)TypeSizes.NATIVE.sizeof(rsc.rowFilter.size());
            for (IndexExpression expr : rsc.rowFilter) {
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column);
                size += (long)TypeSizes.NATIVE.sizeof(expr.operator.ordinal());
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.value);
            }
        }
        size += AbstractBounds.serializer.serializedSize(rsc.keyRange, version);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.maxResults);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.countCQL3Rows);
        return size += (long)TypeSizes.NATIVE.sizeof(rsc.isPaging);
    }
}

