/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ExpiringCell
extends Cell {
    public static final int MAX_TTL = 630720000;
    private final int localExpirationTime;
    private final int timeToLive;

    public ExpiringCell(CellName name, ByteBuffer value, long timestamp, int timeToLive) {
        this(name, value, timestamp, timeToLive, (int)(System.currentTimeMillis() / 1000L) + timeToLive);
    }

    public ExpiringCell(CellName name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime) {
        super(name, value, timestamp);
        assert (timeToLive > 0) : timeToLive;
        assert (localExpirationTime > 0) : localExpirationTime;
        this.timeToLive = timeToLive;
        this.localExpirationTime = localExpirationTime;
    }

    public static Cell create(CellName name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime, int expireBefore, ColumnSerializer.Flag flag) {
        if (localExpirationTime >= expireBefore || flag == ColumnSerializer.Flag.PRESERVE_SIZE) {
            return new ExpiringCell(name, value, timestamp, timeToLive, localExpirationTime);
        }
        return new DeletedCell(name, localExpirationTime - timeToLive, timestamp);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new ExpiringCell(newName, this.value, this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new ExpiringCell(this.name, this.value, newTimestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public int dataSize() {
        return super.dataSize() + TypeSizes.NATIVE.sizeof(this.localExpirationTime) + TypeSizes.NATIVE.sizeof(this.timeToLive);
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.localExpirationTime) + typeSizes.sizeof(this.timeToLive);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.toByteBuffer().duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
            buffer.writeInt(this.timeToLive);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localExpirationTime;
    }

    @Override
    public Cell localCopy(ColumnFamilyStore cfs, AbstractAllocator allocator) {
        return new ExpiringCell(this.name.copy(allocator), allocator.clone(this.value), this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s!%d", super.getString(comparator), this.timeToLive);
    }

    @Override
    public boolean isMarkedForDelete(long now) {
        return (int)(now / 1000L) >= this.getLocalDeletionTime();
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public int serializationFlags() {
        return 2;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        super.validateFields(metadata);
        if (this.timeToLive <= 0) {
            throw new MarshalException("A column TTL should be > 0");
        }
        if (this.localExpirationTime < 0) {
            throw new MarshalException("The local expiration time should not be negative");
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.localExpirationTime == ((ExpiringCell)o).localExpirationTime && this.timeToLive == ((ExpiringCell)o).timeToLive;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.localExpirationTime;
        result = 31 * result + this.timeToLive;
        return result;
    }
}

