/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class DeletedCell
extends Cell {
    public DeletedCell(CellName name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public DeletedCell(CellName name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new DeletedCell(newName, this.value, this.timestamp);
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new DeletedCell(this.name, this.value, newTimestamp);
    }

    @Override
    public boolean isMarkedForDelete(long now) {
        return true;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.toByteBuffer().duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value.getInt(this.value.position());
    }

    @Override
    public Cell reconcile(Cell cell, AbstractAllocator allocator) {
        if (cell instanceof DeletedCell) {
            return super.reconcile(cell, allocator);
        }
        return cell.reconcile(this, allocator);
    }

    @Override
    public Cell localCopy(ColumnFamilyStore cfs, AbstractAllocator allocator) {
        return new DeletedCell(this.name.copy(allocator), allocator.clone(this.value), this.timestamp);
    }

    @Override
    public int serializationFlags() {
        return 1;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if (this.value().remaining() != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }
}

