/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class CounterCell
extends Cell {
    protected static final CounterContext contextManager = CounterContext.instance();
    private final long timestampOfLastDelete;

    public CounterCell(CellName name, ByteBuffer value, long timestamp) {
        this(name, value, timestamp, Long.MIN_VALUE);
    }

    public CounterCell(CellName name, ByteBuffer value, long timestamp, long timestampOfLastDelete) {
        super(name, value, timestamp);
        this.timestampOfLastDelete = timestampOfLastDelete;
    }

    public static CounterCell create(CellName name, ByteBuffer value, long timestamp, long timestampOfLastDelete, ColumnSerializer.Flag flag) {
        if (flag == ColumnSerializer.Flag.FROM_REMOTE || flag == ColumnSerializer.Flag.LOCAL && contextManager.shouldClearLocal(value)) {
            value = contextManager.clearAllLocal(value);
        }
        return new CounterCell(name, value, timestamp, timestampOfLastDelete);
    }

    public static CounterCell createLocal(CellName name, long value, long timestamp, long timestampOfLastDelete) {
        return new CounterCell(name, contextManager.createLocal(value, HeapAllocator.instance), timestamp, timestampOfLastDelete);
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new CounterCell(newName, this.value, this.timestamp, this.timestampOfLastDelete);
    }

    public long timestampOfLastDelete() {
        return this.timestampOfLastDelete;
    }

    public long total() {
        return contextManager.total(this.value);
    }

    @Override
    public int dataSize() {
        return super.dataSize() + TypeSizes.NATIVE.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public Cell diff(Cell cell) {
        assert (cell instanceof CounterCell || cell instanceof DeletedCell) : "Wrong class type: " + cell.getClass();
        if (this.timestamp() < cell.timestamp()) {
            return cell;
        }
        assert (cell instanceof CounterCell) : "Wrong class type: " + cell.getClass();
        if (this.timestampOfLastDelete() < ((CounterCell)cell).timestampOfLastDelete()) {
            return cell;
        }
        CounterContext.Relationship rel = contextManager.diff(cell.value(), this.value());
        if (rel == CounterContext.Relationship.GREATER_THAN || rel == CounterContext.Relationship.DISJOINT) {
            return cell;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.toByteBuffer().duplicate());
        contextManager.updateDigest(digest, this.value);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
            buffer.writeLong(this.timestampOfLastDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public Cell reconcile(Cell cell, AbstractAllocator allocator) {
        if (cell.isMarkedForDelete(Long.MIN_VALUE)) {
            if (this.timestamp() < cell.timestamp()) {
                return cell;
            }
            if (this.timestampOfLastDelete() >= cell.timestamp()) {
                return this;
            }
            return new CounterCell(this.name(), this.value(), this.timestamp(), cell.timestamp());
        }
        assert (cell instanceof CounterCell) : "Wrong class type: " + cell.getClass();
        if (this.timestamp() < ((CounterCell)cell).timestampOfLastDelete()) {
            return cell;
        }
        if (this.timestampOfLastDelete() > cell.timestamp()) {
            return this;
        }
        return new CounterCell(this.name(), contextManager.merge(this.value(), cell.value(), allocator), Math.max(this.timestamp(), cell.timestamp()), Math.max(this.timestampOfLastDelete(), ((CounterCell)cell).timestampOfLastDelete()));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.timestampOfLastDelete == ((CounterCell)o).timestampOfLastDelete;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (int)(this.timestampOfLastDelete ^ this.timestampOfLastDelete >>> 32);
    }

    @Override
    public Cell localCopy(ColumnFamilyStore cfs, AbstractAllocator allocator) {
        return new CounterCell(this.name.copy(allocator), allocator.clone(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:false:%s@%d!%d", comparator.getString(this.name), contextManager.toString(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public int serializationFlags() {
        return 4;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        contextManager.validateContext(this.value());
    }

    public Cell markLocalToBeCleared() {
        ByteBuffer marked = contextManager.markLocalToBeCleared(this.value);
        return marked == this.value ? this : new CounterCell(this.name, marked, this.timestamp, this.timestampOfLastDelete);
    }
}

