/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class AtomicBTreeColumns
extends ColumnFamily {
    static final long HEAP_SIZE = ObjectSizes.measure(new AtomicBTreeColumns(CFMetaData.IndexCf, null)) + ObjectSizes.measure(new Holder(null, null));
    private static final Function<Cell, CellName> NAME = new Function<Cell, CellName>(){

        public CellName apply(Cell column) {
            return column.name;
        }
    };
    public static final ColumnFamily.Factory<AtomicBTreeColumns> factory = new ColumnFamily.Factory<AtomicBTreeColumns>(){

        @Override
        public AtomicBTreeColumns create(CFMetaData metadata, boolean insertReversed) {
            if (insertReversed) {
                throw new IllegalArgumentException();
            }
            return new AtomicBTreeColumns(metadata);
        }
    };
    private static final DeletionInfo LIVE = DeletionInfo.live();
    private static final Holder EMPTY = new Holder(BTree.empty(), LIVE);
    private volatile Holder ref;
    private static final AtomicReferenceFieldUpdater<AtomicBTreeColumns, Holder> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreeColumns.class, Holder.class, "ref");

    private AtomicBTreeColumns(CFMetaData metadata) {
        this(metadata, EMPTY);
    }

    private AtomicBTreeColumns(CFMetaData metadata, Holder holder) {
        super(metadata);
        this.ref = holder;
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new AtomicBTreeColumns(this.metadata, this.ref);
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.ref.deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.delete(new DeletionInfo(delTime));
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.delete(new DeletionInfo(tombstone, this.getComparator()));
    }

    @Override
    public void delete(DeletionInfo info) {
        DeletionInfo newDelInfo;
        Holder current;
        if (info.isLive()) {
            return;
        }
        while (!refUpdater.compareAndSet(this, current = this.ref, current.with(newDelInfo = current.deletionInfo.copy().add(info)))) {
        }
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.ref = this.ref.with(newInfo);
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        DeletionInfo purgedInfo;
        Holder current;
        do {
            current = this.ref;
            if (!current.deletionInfo.hasPurgeableTombstones(gcBefore)) break;
            purgedInfo = current.deletionInfo.copy();
            purgedInfo.purge(gcBefore);
        } while (!refUpdater.compareAndSet(this, current, current.with(purgedInfo)));
    }

    private static Collection<Cell> transform(Comparator<Cell> cmp, ColumnFamily cf, Function<Cell, Cell> transformation, boolean sort) {
        Cell[] tmp = new Cell[cf.getColumnCount()];
        int i = 0;
        for (Cell c : cf) {
            tmp[i++] = (Cell)transformation.apply((Object)c);
        }
        if (sort) {
            Arrays.sort(tmp, cmp);
        }
        return Arrays.asList(tmp);
    }

    public Delta addAllWithSizeDelta(ColumnFamily cm, AbstractAllocator allocator, Function<Cell, Cell> transformation, SecondaryIndexManager.Updater indexer, Delta delta) {
        boolean transformed = false;
        Collection<Cell> insert = cm.getSortedColumns();
        while (true) {
            Holder current = this.ref;
            delta.reset();
            DeletionInfo deletionInfo = cm.deletionInfo();
            if (deletionInfo.mayModify(current.deletionInfo)) {
                if (deletionInfo.hasRanges()) {
                    for (Iterator iter : new Iterator[]{insert.iterator(), BTree.slice(current.tree, true)}) {
                        while (iter.hasNext()) {
                            Cell col = (Cell)iter.next();
                            if (!deletionInfo.isDeleted(col)) continue;
                            indexer.remove(col);
                        }
                    }
                }
                deletionInfo = current.deletionInfo.copy().add(deletionInfo);
                delta.addHeapSize(deletionInfo.unsharedHeapSize() - current.deletionInfo.unsharedHeapSize());
            }
            ColumnUpdater updater = new ColumnUpdater(this, current, allocator, transformation, indexer, delta);
            Object[] tree = BTree.update(current.tree, this.metadata.comparator.columnComparator(), insert, true, updater);
            if (tree != null && refUpdater.compareAndSet(this, current, new Holder(tree, deletionInfo))) {
                indexer.updateRowLevelIndexes();
                return updater.delta;
            }
            if (transformed) continue;
            insert = AtomicBTreeColumns.transform(this.metadata.comparator.columnComparator(), cm, transformation, false);
            transformed = true;
        }
    }

    @Override
    public void addColumn(Cell column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(ColumnFamily cf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell getColumn(CellName name) {
        return (Cell)((Object)BTree.find(this.ref.tree, this.asymmetricComparator(), name));
    }

    private Comparator<Object> asymmetricComparator() {
        final CellNameType cmp = this.metadata.comparator;
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return cmp.compare((CellName)o1, ((Cell)o2).name);
            }
        };
    }

    @Override
    public Iterable<CellName> getColumnNames() {
        return this.collection(false, NAME);
    }

    @Override
    public Collection<Cell> getSortedColumns() {
        return this.collection(true, Functions.identity());
    }

    @Override
    public Collection<Cell> getReverseSortedColumns() {
        return this.collection(false, Functions.identity());
    }

    private <V> Collection<V> collection(final boolean forwards, final Function<Cell, V> f) {
        final Holder ref = this.ref;
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.transform(BTree.slice(ref.tree, forwards), (Function)f);
            }

            @Override
            public int size() {
                return BTree.slice(ref.tree, true).count();
            }
        };
    }

    @Override
    public int getColumnCount() {
        return BTree.slice(this.ref.tree, true).count();
    }

    @Override
    public Iterator<Cell> iterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableSetIterator(new BTreeSet<Cell>(this.ref.tree, this.getComparator().columnComparator()), slices);
    }

    @Override
    public Iterator<Cell> reverseIterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableSetIterator(new BTreeSet<Cell>(this.ref.tree, this.getComparator().columnComparator()).descendingSet(), slices);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    public static final class Delta {
        private long dataSize;
        private long heapSize;
        private List<Cell> discarded = new ArrayList<Cell>();
        private List<Cell> aborted;

        protected void reset() {
            this.dataSize = 0L;
            this.heapSize = 0L;
            this.discarded.clear();
        }

        protected void addHeapSize(long heapSize) {
            this.heapSize += heapSize;
        }

        protected void swap(Cell old, Cell updated) {
            this.dataSize += (long)(updated.dataSize() - old.dataSize());
            this.heapSize += updated.excessHeapSizeExcludingData() - old.excessHeapSizeExcludingData();
            this.discarded.add(old);
        }

        protected void insert(Cell insert) {
            this.dataSize += (long)insert.dataSize();
            this.heapSize += insert.excessHeapSizeExcludingData();
        }

        private void abort(Cell neverUsed) {
            if (this.aborted == null) {
                this.aborted = new ArrayList<Cell>();
            }
            this.aborted.add(neverUsed);
        }

        public long dataSize() {
            return this.dataSize;
        }

        public long excessHeapSize() {
            return this.heapSize;
        }

        public Iterable<Cell> reclaimed() {
            if (this.aborted == null) {
                return this.discarded;
            }
            return Iterables.concat(this.discarded, this.aborted);
        }
    }

    private static class Holder {
        final DeletionInfo deletionInfo;
        final Object[] tree;

        Holder(Object[] tree, DeletionInfo deletionInfo) {
            this.tree = tree;
            this.deletionInfo = deletionInfo;
        }

        Holder with(DeletionInfo info) {
            return new Holder(this.tree, info);
        }
    }

    private static final class ColumnUpdater
    implements UpdateFunction<Cell> {
        final AtomicBTreeColumns updating;
        final Holder ref;
        final AbstractAllocator allocator;
        final Function<Cell, Cell> transform;
        final SecondaryIndexManager.Updater indexer;
        final Delta delta;

        private ColumnUpdater(AtomicBTreeColumns updating, Holder ref, AbstractAllocator allocator, Function<Cell, Cell> transform, SecondaryIndexManager.Updater indexer, Delta delta) {
            this.updating = updating;
            this.ref = ref;
            this.allocator = allocator;
            this.transform = transform;
            this.indexer = indexer;
            this.delta = delta;
        }

        public Cell apply(Cell inserted) {
            this.indexer.insert(inserted);
            this.delta.insert(inserted);
            return (Cell)this.transform.apply((Object)inserted);
        }

        @Override
        public Cell apply(Cell existing, Cell update) {
            Cell reconciled = update.reconcile(existing, this.allocator);
            this.indexer.update(existing, reconciled);
            if (existing != reconciled) {
                this.delta.swap(existing, reconciled);
            } else {
                this.delta.abort(update);
            }
            return (Cell)this.transform.apply((Object)reconciled);
        }

        @Override
        public boolean abortEarly() {
            return this.updating.ref != this.ref;
        }

        @Override
        public void allocated(long heapSize) {
            this.delta.addHeapSize(heapSize);
        }
    }
}

