/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.github.jamm.MemoryMeter;

public class SelectStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<ColumnIdentifier, Restriction> metadataRestrictions = new HashMap<ColumnIdentifier, Restriction>();
    private final Set<ColumnDefinition> restrictedColumns = new HashSet<ColumnDefinition>();
    private Restriction.Slice sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;
    private boolean usesSecondaryIndexing;
    private boolean needOrderOnLastClustering;
    private Map<ColumnIdentifier, Integer> orderingIndexes;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false, null, false);

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, Term limit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.keyRestrictions = new Restriction[cfm.partitionKeyColumns().size()];
        this.columnRestrictions = new Restriction[cfm.clusteringColumns().size()];
        this.parameters = parameters;
        this.limit = limit;
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, null);
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.parameters.isCount ? ResultSet.makeCountMetadata(this.keyspace(), this.columnFamily(), this.parameters.countAlias) : this.selection.getResultMetadata();
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.parameters) + meter.measureDeep((Object)this.selection) + (this.limit == null ? 0L : meter.measureDeep((Object)this.limit)) + meter.measureDeep((Object)this.keyRestrictions) + meter.measureDeep((Object)this.columnRestrictions) + meter.measureDeep(this.metadataRestrictions) + meter.measureDeep(this.restrictedColumns) + (this.sliceRestriction == null ? 0L : meter.measureDeep((Object)this.sliceRestriction)) + (this.orderingIndexes == null ? 0L : meter.measureDeep(this.orderingIndexes));
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        ConsistencyLevel cl = options.getConsistency();
        List<ByteBuffer> variables = options.getValues();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        Pageable command = this.isKeyRange || this.usesSecondaryIndexing ? this.getRangeCommand(variables, limit, now) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? null : new Pageable.ReadCommands(commands));
        int pageSize = options.getPageSize();
        if (this.parameters.isCount && pageSize <= 0) {
            pageSize = 10000;
        }
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(command, cl, variables, limit, now);
        }
        QueryPager pager = QueryPagers.pager(command, cl, options.getPagingState());
        if (this.parameters.isCount) {
            return this.pageCountQuery(pager, variables, pageSize, now);
        }
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(page, variables, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private ResultMessage.Rows execute(Pageable command, ConsistencyLevel cl, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, cl) : StorageProxy.getRangeSlice((RangeSliceCommand)command, cl));
        return this.processResults(rows, variables, limit, now);
    }

    private ResultMessage.Rows pageCountQuery(QueryPager pager, List<ByteBuffer> variables, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        int count = 0;
        while (!pager.isExhausted()) {
            int maxLimit = pager.maxRemaining();
            ResultSet rset = this.process(pager.fetchPage(pageSize), variables, maxLimit, now);
            count += rset.rows.size();
        }
        ResultSet result = ResultSet.makeCountResult(this.keyspace(), this.columnFamily(), count, this.parameters.countAlias);
        return new ResultMessage.Rows(result);
    }

    public ResultMessage.Rows processResults(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(rows, variables, limit, now);
        rset = this.parameters.isCount ? rset.makeCountResult(this.parameters.countAlias) : rset;
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        RangeSliceCommand command;
        List<ByteBuffer> variables = Collections.emptyList();
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        List<Object> rows = this.isKeyRange || this.usesSecondaryIndexing ? ((command = this.getRangeCommand(variables, limit, now)) == null ? Collections.emptyList() : command.executeLocally()) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? Collections.emptyList() : SelectStatement.readLocally(this.keyspace(), commands));
        return this.processResults(rows, variables, limit, now);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, Collections.emptyList(), this.getLimit(Collections.emptyList()), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.getKeys(variables);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), key, this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        AbstractBounds<RowPosition> keyBounds = this.getKeyBounds(variables);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, !this.parameters.isDistinct, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(List<ByteBuffer> variables) throws InvalidRequestException {
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            boolean includeStart = this.includeKeyBound(Bound.START);
            boolean includeEnd = this.includeKeyBound(Bound.END);
            int cmp = startToken.compareTo(endToken);
            if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
                return null;
            }
            Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
            return new Range<RowPosition>(start, end);
        }
        ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
        ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
        RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            return null;
        }
        if (this.includeKeyBound(Bound.START)) {
            return this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private IDiskAtomFilter makeFilter(List<ByteBuffer> variables, int limit) throws InvalidRequestException {
        if (this.parameters.isDistinct) {
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, 1, -1);
        }
        if (this.isColumnRange()) {
            ColumnSlice[] slices;
            int toGroup = this.cfm.comparator.isDense() ? -1 : this.cfm.clusteringColumns().size();
            List<Composite> startBounds = this.getRequestedBound(Bound.START, variables);
            List<Composite> endBounds = this.getRequestedBound(Bound.END, variables);
            assert (startBounds.size() == endBounds.size());
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) {
                    return null;
                }
                slices = new ColumnSlice[]{slice};
            } else {
                ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
                for (int i = 0; i < startBounds.size(); ++i) {
                    ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                    if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) continue;
                    l.add(slice);
                }
                if (l.isEmpty()) {
                    return null;
                }
                slices = l.toArray(new ColumnSlice[l.size()]);
            }
            return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
        }
        SortedSet<CellName> cellNames = this.getRequestedColumns(variables);
        if (cellNames == null) {
            return null;
        }
        QueryProcessor.validateCellNames(cellNames, this.cfm.comparator);
        return new NamesQueryFilter(cellNames, true);
    }

    private int getLimit(List<ByteBuffer> variables) throws InvalidRequestException {
        int l = Integer.MAX_VALUE;
        if (this.limit != null) {
            ByteBuffer b = this.limit.bindAndGet(variables);
            if (b == null) {
                throw new InvalidRequestException("Invalid null value of limit");
            }
            try {
                Int32Type.instance.validate(b);
                l = (Integer)Int32Type.instance.compose(b);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        if (l <= 0) {
            throw new InvalidRequestException("LIMIT must be strictly positive");
        }
        if (!(this.sliceRestriction == null || this.sliceRestriction.isInclusive(Bound.START) && this.sliceRestriction.isInclusive(Bound.END) || l == Integer.MAX_VALUE)) {
            ++l;
        }
        return l;
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        CBuilder builder = this.cfm.getKeyValidatorAsCType().builder();
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            Restriction r = this.keyRestrictions[def.position()];
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(variables);
            if (builder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
                    }
                    keys.add(builder.buildWith(val).toByteBuffer());
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
            }
            builder.add(val);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] != null) continue;
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return SelectStatement.buildBound(b, this.cfm.partitionKeyColumns(), this.keyRestrictions, false, this.cfm.getKeyValidatorAsCType(), variables).get(0).toByteBuffer();
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        ByteBuffer value;
        assert (this.onToken);
        Restriction keyRestriction = this.keyRestrictions[0];
        if (keyRestriction.isEQ()) {
            value = keyRestriction.values(variables).get(0);
        } else {
            Restriction.Slice slice = (Restriction.Slice)keyRestriction;
            if (!slice.hasBound(b)) {
                return p.getMinimumToken();
            }
            value = slice.bound(b, variables);
        }
        if (value == null) {
            throw new InvalidRequestException("Invalid null token value");
        }
        return p.getTokenFactory().fromByteArray(value);
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (!r.isSlice()) continue;
            return ((Restriction.Slice)r).isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange() {
        if (!this.cfm.comparator.isDense()) {
            return this.cfm.comparator.isCompound();
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && !r.isSlice()) continue;
            return true;
        }
        return false;
    }

    private SortedSet<CellName> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        CBuilder builder = this.cfm.comparator.prefixBuilder();
        Iterator<ColumnDefinition> idIter = this.cfm.clusteringColumns().iterator();
        for (Restriction r : this.columnRestrictions) {
            ByteBuffer val;
            ColumnDefinition def = idIter.next();
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(variables);
            if (values.size() == 1) {
                val = values.get(0);
                if (val == null) {
                    throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", def.name));
                }
            } else {
                if (values.isEmpty()) {
                    return null;
                }
                TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
                for (ByteBuffer val2 : values) {
                    if (val2 == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", def.name));
                    }
                    Composite prefix = builder.buildWith(val2);
                    columns.addAll(this.addSelectedColumns(prefix));
                }
                return columns;
            }
            builder.add(val);
        }
        return this.addSelectedColumns(builder.build());
    }

    private SortedSet<CellName> addSelectedColumns(Composite prefix) {
        if (this.cfm.comparator.isDense()) {
            return FBUtilities.singleton(this.cfm.comparator.create(prefix, null), this.cfm.comparator);
        }
        assert (!this.selectACollection());
        TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
        if (this.cfm.comparator.isCompound() && !this.cfm.isSuper()) {
            columns.add(this.cfm.comparator.rowMarker(prefix));
            for (ColumnDefinition def : this.selection.getColumnsList()) {
                if (def.kind != ColumnDefinition.Kind.REGULAR) continue;
                columns.add(this.cfm.comparator.create(prefix, def.name));
            }
        } else {
            for (ColumnDefinition def : this.cfm.regularColumns()) {
                columns.add(this.cfm.comparator.create(prefix, def.name));
            }
        }
        return columns;
    }

    private boolean selectACollection() {
        if (!this.cfm.comparator.hasCollections()) {
            return false;
        }
        for (ColumnDefinition def : this.selection.getColumnsList()) {
            if (!(def.type instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    private static List<Composite> buildBound(Bound bound, Collection<ColumnDefinition> defs, Restriction[] restrictions, boolean isReversed, CType type, List<ByteBuffer> variables) throws InvalidRequestException {
        CBuilder builder = type.builder();
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        Iterator<ColumnDefinition> iter = defs.iterator();
        while (iter.hasNext()) {
            ColumnDefinition def = iter.next();
            Bound b = isReversed == SelectStatement.isReversedType(def) ? bound : Bound.reverse(bound);
            Restriction r = restrictions[def.position()];
            if (SelectStatement.isNullRestriction(r, b)) {
                Composite prefix = builder.build();
                return Collections.singletonList(!prefix.isEmpty() && eocBound == Bound.END ? prefix.end() : prefix);
            }
            if (r.isSlice()) {
                builder.add(SelectStatement.getSliceValue(def, r, b, variables));
                Relation.Type relType = ((Restriction.Slice)r).getRelation(eocBound, b);
                while (iter.hasNext() && !SelectStatement.isNullRestriction(r = restrictions[(def = iter.next()).position()], b)) {
                    builder.add(SelectStatement.getSliceValue(def, r, b, variables));
                }
                return Collections.singletonList(builder.build().withEOC(SelectStatement.eocForRelation(relType)));
            }
            List<ByteBuffer> values = r.values(variables);
            if (values.size() != 1) {
                assert (def.position() == defs.size() - 1);
                TreeSet<Composite> s = new TreeSet<Composite>(isReversed ? type.reverseComparator() : type);
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null clustering key part %s", def.name));
                    }
                    Composite prefix = builder.buildWith(val);
                    s.add(b == Bound.END && builder.remainingCount() > 0 ? prefix.end() : prefix);
                }
                return new ArrayList<Composite>(s);
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null clustering key part %s", def.name));
            }
            builder.add(val);
        }
        Composite prefix = builder.build();
        return Collections.singletonList(bound == Bound.END && builder.remainingCount() > 0 ? prefix.end() : prefix);
    }

    private static Composite.EOC eocForRelation(Relation.Type op) {
        switch (op) {
            case LT: {
                return Composite.EOC.START;
            }
            case GT: 
            case LTE: {
                return Composite.EOC.END;
            }
        }
        return Composite.EOC.NONE;
    }

    private static boolean isNullRestriction(Restriction r, Bound b) {
        return r == null || r.isSlice() && !((Restriction.Slice)r).hasBound(b);
    }

    private static ByteBuffer getSliceValue(ColumnDefinition def, Restriction r, Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction.Slice slice = (Restriction.Slice)r;
        assert (slice.hasBound(b));
        ByteBuffer val = slice.bound(b, variables);
        if (val == null) {
            throw new InvalidRequestException(String.format("Invalid null clustering key part %s", def.name));
        }
        return val;
    }

    private List<Composite> getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        return SelectStatement.buildBound(b, this.cfm.clusteringColumns(), this.columnRestrictions, this.isReversed, this.cfm.comparator, variables);
    }

    public List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.restrictedColumns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (ColumnDefinition def : this.restrictedColumns) {
            Restriction restriction;
            switch (def.kind) {
                case PARTITION_KEY: {
                    restriction = this.keyRestrictions[def.position()];
                    break;
                }
                case CLUSTERING_COLUMN: {
                    restriction = this.columnRestrictions[def.position()];
                    break;
                }
                case REGULAR: {
                    restriction = this.metadataRestrictions.get(def.name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (restriction.isSlice()) {
                Restriction.Slice slice = (Restriction.Slice)restriction;
                for (Bound b : Bound.values()) {
                    if (!slice.hasBound(b)) continue;
                    ByteBuffer value = SelectStatement.validateIndexedValue(def, slice.bound(b, variables));
                    expressions.add(new IndexExpression(def.name.bytes, slice.getIndexOperator(b), value));
                }
                continue;
            }
            if (restriction.isContains()) {
                Restriction.Contains contains = (Restriction.Contains)restriction;
                for (ByteBuffer value : contains.values(variables)) {
                    SelectStatement.validateIndexedValue(def, value);
                    expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.CONTAINS, value));
                }
                for (ByteBuffer key : contains.keys(variables)) {
                    SelectStatement.validateIndexedValue(def, key);
                    expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.CONTAINS_KEY, key));
                }
                continue;
            }
            List<ByteBuffer> values = restriction.values(variables);
            if (values.size() != 1) {
                throw new InvalidRequestException("IN restrictions are not supported on indexed columns");
            }
            ByteBuffer value = SelectStatement.validateIndexedValue(def, values.get(0));
            expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.EQ, value));
        }
        return expressions;
    }

    private static ByteBuffer validateIndexedValue(ColumnDefinition def, ByteBuffer value) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", def.name));
        }
        if (value.remaining() > 65535) {
            throw new InvalidRequestException("Index expression values may not be larger than 64K");
        }
        return value;
    }

    private Iterator<Cell> applySliceRestriction(final Iterator<Cell> cells, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.sliceRestriction != null);
        final CellNameType type = this.cfm.comparator;
        final CellName excludedStart = this.sliceRestriction.isInclusive(Bound.START) ? null : type.makeCellName(this.sliceRestriction.bound(Bound.START, variables));
        final CellName excludedEnd = this.sliceRestriction.isInclusive(Bound.END) ? null : type.makeCellName(this.sliceRestriction.bound(Bound.END, variables));
        return new AbstractIterator<Cell>(){

            protected Cell computeNext() {
                while (cells.hasNext()) {
                    Cell c = (Cell)cells.next();
                    if (excludedStart != null && type.compare(c.name(), excludedStart) == 0 || excludedEnd != null && type.compare(c.name(), excludedEnd) == 0) continue;
                    return c;
                }
                return (Cell)this.endOfData();
            }
        };
    }

    private ResultSet process(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(row.key.key, row.cf, variables, now, result);
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cqlRows, variables);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(ByteBuffer key, ColumnFamily cf, List<ByteBuffer> variables, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        CFMetaData cfm = cf.metadata();
        ByteBuffer[] keyComponents = null;
        keyComponents = cfm.getKeyValidator() instanceof CompositeType ? ((CompositeType)cfm.getKeyValidator()).split(key) : new ByteBuffer[]{key};
        Iterator<Cell> cells = cf.getSortedColumns().iterator();
        if (this.sliceRestriction != null) {
            cells = this.applySliceRestriction(cells, variables);
        }
        Iterator<CQL3Row> iter = cfm.comparator.CQL3RowBuilder(now).group(cells);
        while (iter.hasNext()) {
            CQL3Row cql3Row = iter.next();
            result.newRow();
            for (ColumnDefinition def : this.selection.getColumnsList()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        result.add(cql3Row.getClusteringColumn(def.position()));
                        break;
                    }
                    case COMPACT_VALUE: {
                        result.add(cql3Row.getColumn(null));
                        break;
                    }
                    case REGULAR: {
                        if (def.type.isCollection()) {
                            List<Cell> collection = cql3Row.getCollection(def.name);
                            ByteBuffer value = collection == null ? null : ((CollectionType)def.type).serialize(collection);
                            result.add(value);
                            break;
                        }
                        result.add(cql3Row.getColumn(def.name));
                    }
                }
            }
        }
    }

    private void orderResults(ResultSet cqlRows, List<ByteBuffer> variables) throws InvalidRequestException {
        boolean needOrderOnPartitionKey;
        if (cqlRows.size() == 0) {
            return;
        }
        boolean bl = needOrderOnPartitionKey = this.keyIsInRelation && !this.parameters.orderings.isEmpty();
        if (!this.needOrderOnLastClustering && !needOrderOnPartitionKey) {
            return;
        }
        assert (this.orderingIndexes != null);
        ArrayList<Integer> idToSort = new ArrayList<Integer>();
        ArrayList<Comparator<ByteBuffer>> sorters = new ArrayList<Comparator<ByteBuffer>>();
        for (ColumnIdentifier identifier : this.parameters.orderings.keySet()) {
            ColumnDefinition orderingColumn = this.cfm.getColumnDefinition(identifier);
            idToSort.add(this.orderingIndexes.get(orderingColumn.name));
            sorters.add(orderingColumn.type);
        }
        if (this.needOrderOnLastClustering) {
            List<ColumnDefinition> cc = this.cfm.clusteringColumns();
            idToSort.add(this.orderingIndexes.get(cc.get((int)(cc.size() - 1)).name));
            Restriction last = this.columnRestrictions[this.columnRestrictions.length - 1];
            sorters.add(this.makeComparatorFor(last.values(variables), this.isReversed));
        }
        Comparator<List<ByteBuffer>> comparator = idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        Collections.sort(cqlRows.rows, comparator);
    }

    private Comparator<ByteBuffer> makeComparatorFor(final List<ByteBuffer> vals, final boolean isReversed) {
        return new Comparator<ByteBuffer>(){
            private final List<ByteBuffer> values;
            {
                this.values = isReversed ? com.google.common.collect.Lists.reverse((List)vals) : vals;
            }

            @Override
            public int compare(ByteBuffer b1, ByteBuffer b2) {
                int idx1 = -1;
                int idx2 = -1;
                for (int i = 0; i < this.values.size(); ++i) {
                    ByteBuffer bb = this.values.get(i);
                    if (bb.equals(b1)) {
                        idx1 = i;
                    }
                    if (bb.equals(b2)) {
                        idx2 = i;
                    }
                    if (idx1 >= 0 && idx2 >= 0) break;
                }
                assert (idx1 >= 0 && idx2 >= 0) : "Got CQL3 row that was not queried in resultset";
                return idx1 - idx2;
            }
        };
    }

    private static boolean isReversedType(ColumnDefinition def) {
        return def.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions.get(i).intValue()), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isDistinct;
        private final boolean isCount;
        private final ColumnIdentifier countAlias;
        private final boolean allowFiltering;

        public Parameters(Map<ColumnIdentifier, Boolean> orderings, boolean isDistinct, boolean isCount, ColumnIdentifier countAlias, boolean allowFiltering) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.isCount = isCount;
            this.countAlias = countAlias;
            this.allowFiltering = allowFiltering;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            int index;
            Selection selection;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            VariableSpecifications names = this.getBoundVariables();
            if (this.parameters.isCount && !this.selectClause.isEmpty()) {
                throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
            }
            Selection selection2 = selection = this.selectClause.isEmpty() ? Selection.wildcard(cfm) : Selection.fromSelectors(cfm, this.selectClause);
            if (this.parameters.isDistinct) {
                this.validateDistinctSelection(selection.getColumnsList(), cfm.partitionKeyColumns());
            }
            Term prepLimit = null;
            if (this.limit != null) {
                prepLimit = this.limit.prepare(this.keyspace(), this.limitReceiver());
                prepLimit.collectMarkerSpecification(names);
            }
            SelectStatement stmt = new SelectStatement(cfm, names.size(), this.parameters, selection, prepLimit);
            boolean hasQueriableIndex = false;
            boolean hasQueriableClusteringColumnIndex = false;
            for (Relation rel : this.whereClause) {
                ColumnDefinition def = cfm.getColumnDefinition(rel.getEntity());
                if (def == null) {
                    if (this.containsAlias(rel.getEntity())) {
                        throw new InvalidRequestException(String.format("Aliases aren't allowed in where clause ('%s')", rel));
                    }
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                stmt.restrictedColumns.add(def);
                if (def.isIndexed() && rel.operator().allowsIndexQuery()) {
                    hasQueriableIndex = true;
                    if (def.kind == ColumnDefinition.Kind.CLUSTERING_COLUMN) {
                        hasQueriableClusteringColumnIndex = true;
                    }
                }
                switch (def.kind) {
                    case PARTITION_KEY: {
                        ((SelectStatement)stmt).keyRestrictions[def.position()] = this.updateRestriction(cfm, def, stmt.keyRestrictions[def.position()], rel, names);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        ((SelectStatement)stmt).columnRestrictions[def.position()] = this.updateRestriction(cfm, def, stmt.columnRestrictions[def.position()], rel, names);
                        break;
                    }
                    case COMPACT_VALUE: {
                        throw new InvalidRequestException(String.format("Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", def.name));
                    }
                    case REGULAR: {
                        Restriction r = this.updateRestriction(cfm, def, (Restriction)stmt.metadataRestrictions.get(def.name), rel, names);
                        if (r.isIN() && !((Restriction.IN)r).canHaveOnlyOneValue()) {
                            throw new InvalidRequestException(String.format("IN predicates on non-primary-key columns (%s) is not yet supported", def.name));
                        }
                        stmt.metadataRestrictions.put(def.name, r);
                    }
                }
            }
            boolean canRestrictFurtherComponents = true;
            ColumnDefinition previous = null;
            stmt.keyIsInRelation = false;
            Iterator<ColumnDefinition> iter = cfm.partitionKeyColumns().iterator();
            for (int i = 0; i < stmt.keyRestrictions.length; ++i) {
                ColumnDefinition cdef = iter.next();
                Restriction restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException("The token() function must be applied to all partition key components or none of them");
                    }
                    if (i > 0 && stmt.keyRestrictions[i - 1] != null) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            stmt.isKeyRange = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partition key part %s must be restricted since preceding part is", cdef.name));
                    }
                    stmt.isKeyRange = true;
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("partition key part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cdef.name, previous));
                    }
                    if (restriction.isOnToken()) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (!restriction.isSlice()) {
                            if (restriction.isIN()) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cdef.name));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                }
                previous = cdef;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedColumns.removeAll(cfm.partitionKeyColumns());
            }
            canRestrictFurtherComponents = true;
            previous = null;
            boolean previousIsSlice = false;
            iter = cfm.clusteringColumns().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                ColumnDefinition cdef = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = false;
                } else if (!canRestrictFurtherComponents) {
                    boolean hasTuple = false;
                    boolean hasRestrictedNotTuple = false;
                    if (!(previousIsSlice && restriction.isSlice() && ((Restriction.Slice)restriction).isPartOfTuple())) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cdef.name, previous));
                    }
                } else if (restriction.isSlice()) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = true;
                    Restriction.Slice slice = (Restriction.Slice)restriction;
                    if (!(cfm.comparator.isCompound() || slice.isInclusive(Bound.START) && slice.isInclusive(Bound.END))) {
                        stmt.sliceRestriction = slice;
                    }
                } else if (restriction.isIN()) {
                    if (i != stmt.columnRestrictions.length - 1) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation", cdef.name));
                    }
                    if (stmt.selectACollection()) {
                        throw new InvalidRequestException(String.format("Cannot restrict PRIMARY KEY part %s by IN relation as a collection is selected by the query", cdef.name));
                    }
                    if (this.parameters.orderings.get(cdef.name) == null) {
                        stmt.needOrderOnLastClustering = true;
                        stmt.orderingIndexes = new HashMap();
                        index = this.indexOf(cdef, stmt.selection);
                        if (index < 0) {
                            index = stmt.selection.addColumnForOrdering(cdef);
                        }
                        stmt.orderingIndexes.put(cdef.name, index);
                    }
                }
                previous = cdef;
            }
            if (stmt.isKeyRange && hasQueriableClusteringColumnIndex) {
                stmt.usesSecondaryIndexing = true;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedColumns.removeAll(cfm.clusteringColumns());
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                if (!hasQueriableIndex) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                stmt.usesSecondaryIndexing = true;
            }
            if (stmt.usesSecondaryIndexing && stmt.keyIsInRelation) {
                throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                if (stmt.usesSecondaryIndexing) {
                    throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
                }
                if (stmt.isKeyRange) {
                    throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
                }
                if (stmt.keyIsInRelation || stmt.needOrderOnLastClustering) {
                    if (stmt.orderingIndexes == null) {
                        stmt.orderingIndexes = new HashMap();
                    }
                    for (ColumnIdentifier column : stmt.parameters.orderings.keySet()) {
                        ColumnDefinition def = cfm.getColumnDefinition(column);
                        if (def == null) {
                            if (this.containsAlias(column)) {
                                throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                            }
                            throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                        }
                        index = this.indexOf(def, stmt.selection);
                        if (index < 0) {
                            index = stmt.selection.addColumnForOrdering(def);
                        }
                        stmt.orderingIndexes.put(def.name, index);
                    }
                }
                Boolean[] reversedMap = new Boolean[cfm.clusteringColumns().size()];
                int i = 0;
                for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                    ColumnIdentifier column = (ColumnIdentifier)entry.getKey();
                    boolean reversed = (Boolean)entry.getValue();
                    ColumnDefinition def = cfm.getColumnDefinition(column);
                    if (def == null) {
                        if (this.containsAlias(column)) {
                            throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                        }
                        throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                    }
                    if (def.kind != ColumnDefinition.Kind.CLUSTERING_COLUMN) {
                        throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                    }
                    if (i++ != def.position()) {
                        throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                    }
                    reversedMap[def.position()] = reversed != SelectStatement.isReversedType(def);
                }
                Boolean isReversed = null;
                for (Boolean b : reversedMap) {
                    if (b == null) continue;
                    if (isReversed == null) {
                        isReversed = b;
                        continue;
                    }
                    if (isReversed == b) continue;
                    throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
                }
                assert (isReversed != null);
                stmt.isReversed = isReversed;
            }
            if (!this.parameters.allowFiltering && (stmt.isKeyRange || stmt.usesSecondaryIndexing) && (stmt.restrictedColumns.size() > 1 || stmt.restrictedColumns.isEmpty() && !stmt.columnFilterIsIdentity())) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            return new ParsedStatement.Prepared((CQLStatement)stmt, names);
        }

        private int indexOf(ColumnDefinition def, Selection selection) {
            return this.indexOf(def, selection.getColumnsList().iterator());
        }

        private int indexOf(final ColumnDefinition def, Iterator<ColumnDefinition> defs) {
            return Iterators.indexOf(defs, (Predicate)new Predicate<ColumnDefinition>(){

                public boolean apply(ColumnDefinition n) {
                    return def.name.equals(n.name);
                }
            });
        }

        private void validateDistinctSelection(Collection<ColumnDefinition> requestedColumns, Collection<ColumnDefinition> partitionKey) throws InvalidRequestException {
            for (ColumnDefinition def : requestedColumns) {
                if (partitionKey.contains(def)) continue;
                throw new InvalidRequestException(String.format("SELECT DISTINCT queries must only request partition key columns (not %s)", def.name));
            }
            for (ColumnDefinition def : partitionKey) {
                if (requestedColumns.contains(def)) continue;
                throw new InvalidRequestException(String.format("SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name));
            }
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        Restriction updateRestriction(CFMetaData cfm, ColumnDefinition def, Restriction restriction, Relation newRel, VariableSpecifications boundNames) throws InvalidRequestException {
            ColumnSpecification receiver = def;
            if (newRel.onToken) {
                if (def.kind != ColumnDefinition.Kind.PARTITION_KEY) {
                    throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", def.name));
                }
                receiver = new ColumnSpecification(def.ksName, def.cfName, new ColumnIdentifier("partition key token", true), StorageService.getPartitioner().getTokenValidator());
            }
            if (newRel.previousInTuple != null && def.kind != ColumnDefinition.Kind.CLUSTERING_COLUMN) {
                throw new InvalidRequestException(String.format("Tuple notation can only be used on clustering columns but found on %s", def.name));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", def.name));
                    }
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    t.collectMarkerSpecification(boundNames);
                    restriction = new Restriction.EQ(t, newRel.onToken);
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes a IN", def.name));
                    }
                    if (newRel.getInValues() == null) {
                        assert (newRel.getValue() != null);
                        Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                        t.collectMarkerSpecification(boundNames);
                        restriction = Restriction.IN.create(t);
                        break;
                    }
                    ArrayList<Term> inValues = new ArrayList<Term>(newRel.getInValues().size());
                    for (Term.Raw raw : newRel.getInValues()) {
                        Term t = raw.prepare(this.keyspace(), receiver);
                        t.collectMarkerSpecification(boundNames);
                        inValues.add(t);
                    }
                    restriction = Restriction.IN.create(inValues);
                    break;
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    if (restriction == null) {
                        restriction = new Restriction.Slice(newRel.onToken);
                    } else if (!restriction.isSlice()) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by both an equal and an inequal relation", def.name));
                    }
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    t.collectMarkerSpecification(boundNames);
                    if (!(newRel.previousInTuple == null || def.position() != 0 && cfm.clusteringColumns().get((int)(def.position() - 1)).name.equals(newRel.previousInTuple))) {
                        throw new InvalidRequestException(String.format("Invalid tuple notation, column %s is not before column %s in the clustering order", newRel.previousInTuple, def.name));
                    }
                    ((Restriction.Slice)restriction).setBound(def.name, newRel.operator(), t, newRel.previousInTuple);
                    break;
                }
                case CONTAINS_KEY: {
                    if (!(receiver.type instanceof MapType)) {
                        throw new InvalidRequestException(String.format("Cannot use CONTAINS_KEY on non-map column %s", def.name));
                    }
                }
                case CONTAINS: {
                    if (!receiver.type.isCollection()) {
                        throw new InvalidRequestException(String.format("Cannot use %s relation on non collection column %s", new Object[]{newRel.operator(), def.name}));
                    }
                    if (restriction == null) {
                        restriction = new Restriction.Contains();
                    } else if (!restriction.isContains()) {
                        throw new InvalidRequestException(String.format("Collection column %s can only be restricted by CONTAINS or CONTAINS KEY", def.name));
                    }
                    boolean isKey = newRel.operator() == Relation.Type.CONTAINS_KEY;
                    receiver = RawStatement.makeCollectionReceiver(receiver, isKey);
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    ((Restriction.Contains)restriction).add(t, isKey);
                }
            }
            return restriction;
        }

        private static ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
            assert (collection.type.isCollection());
            switch (((CollectionType)collection.type).kind) {
                case LIST: {
                    assert (!isKey);
                    return Lists.valueSpecOf(collection);
                }
                case SET: {
                    assert (!isKey);
                    return Sets.valueSpecOf(collection);
                }
                case MAP: {
                    return isKey ? Maps.keySpecOf(collection) : Maps.valueSpecOf(collection);
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).add("isCount", this.parameters.isCount).toString();
        }
    }
}

