/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.CASConditions;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.Pair;
import org.github.jamm.MemoryMeter;

public abstract class ModificationStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Attributes attrs;
    private final Map<ColumnIdentifier, Restriction> processedKeys = new HashMap<ColumnIdentifier, Restriction>();
    private final List<Operation> columnOperations = new ArrayList<Operation>();
    private List<Operation> columnConditions;
    private boolean ifNotExists;

    public ModificationStatement(int boundTerms, CFMetaData cfm, Attributes attrs) {
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.attrs = attrs;
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.attrs) + meter.measureDeep(this.processedKeys) + meter.measureDeep(this.columnOperations) + (this.columnConditions == null ? 0L : meter.measureDeep(this.columnConditions));
    }

    public abstract boolean requireFullClusteringKey();

    public abstract ColumnFamily updateForKey(ByteBuffer var1, Composite var2, UpdateParameters var3) throws InvalidRequestException;

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.isCounter();
    }

    public long getTimestamp(long now, List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, variables);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimeToLive(variables);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.hasConditions() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
        }
        if (this.isCounter() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for counter updates");
        }
        if (this.isCounter() && this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Cannot provide custom TTL for counter updates");
        }
    }

    public void addOperation(Operation op) {
        this.columnOperations.add(op);
    }

    public List<Operation> getOperations() {
        return this.columnOperations;
    }

    public void addCondition(Operation op) {
        if (this.columnConditions == null) {
            this.columnConditions = new ArrayList<Operation>();
        }
        this.columnConditions.add(op);
    }

    public void setIfNotExistCondition() {
        this.ifNotExists = true;
    }

    private void addKeyValues(ColumnIdentifier name, Restriction values) throws InvalidRequestException {
        if (this.processedKeys.put(name, values) != null) {
            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
        }
    }

    public void addKeyValue(ColumnIdentifier name, Term value) throws InvalidRequestException {
        this.addKeyValues(name, new Restriction.EQ(value, false));
    }

    public void processWhereClause(List<Relation> whereClause, VariableSpecifications names) throws InvalidRequestException {
        for (Relation rel : whereClause) {
            ColumnDefinition def = this.cfm.getColumnDefinition(rel.getEntity());
            if (def == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (def.kind) {
                case PARTITION_KEY: 
                case CLUSTERING_COLUMN: {
                    Restriction restriction;
                    Term t;
                    if (rel.operator() == Relation.Type.EQ) {
                        t = rel.getValue().prepare(this.keyspace(), def);
                        t.collectMarkerSpecification(names);
                        restriction = new Restriction.EQ(t, false);
                    } else if (def.kind == ColumnDefinition.Kind.PARTITION_KEY && rel.operator() == Relation.Type.IN) {
                        if (rel.getValue() != null) {
                            t = rel.getValue().prepare(this.keyspace(), def);
                            t.collectMarkerSpecification(names);
                            restriction = Restriction.IN.create(t);
                        } else {
                            ArrayList<Term> values = new ArrayList<Term>(rel.getInValues().size());
                            for (Term.Raw raw : rel.getInValues()) {
                                Term t2 = raw.prepare(this.keyspace(), def);
                                t2.collectMarkerSpecification(names);
                                values.add(t2);
                            }
                            restriction = Restriction.IN.create(values);
                        }
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), def.name}));
                    }
                    this.addKeyValues(def.name, restriction);
                    break;
                }
                case COMPACT_VALUE: 
                case REGULAR: {
                    throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", def.name));
                }
            }
        }
    }

    public List<ByteBuffer> buildPartitionKeyNames(List<ByteBuffer> variables) throws InvalidRequestException {
        CBuilder keyBuilder = this.cfm.getKeyValidatorAsCType().builder();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            Restriction r = this.processedKeys.get(def.name);
            if (r == null) {
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", def.name));
            }
            List<ByteBuffer> values = r.values(variables);
            if (keyBuilder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
                    }
                    keys.add(keyBuilder.buildWith(val).toByteBuffer());
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
            }
            keyBuilder.add(val);
        }
        return keys;
    }

    public Composite createClusteringPrefix(List<ByteBuffer> variables) throws InvalidRequestException {
        CBuilder builder = this.cfm.comparator.prefixBuilder();
        ColumnDefinition firstEmptyKey = null;
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            Restriction r = this.processedKeys.get(def.name);
            if (r == null) {
                firstEmptyKey = def;
                if (!this.requireFullClusteringKey() || this.cfm.comparator.isDense() || !this.cfm.comparator.isCompound()) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", def.name));
            }
            if (firstEmptyKey != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmptyKey.name, def.name));
            }
            List<ByteBuffer> values = r.values(variables);
            assert (values.size() == 1);
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", def.name));
            }
            builder.add(val);
        }
        return builder.build();
    }

    protected ColumnDefinition getFirstEmptyKey() {
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            if (this.processedKeys.get(def.name) != null) continue;
            return def;
        }
        return null;
    }

    protected Map<ByteBuffer, CQL3Row> readRequiredRows(List<ByteBuffer> partitionKeys, Composite clusteringPrefix, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        TreeSet<ColumnIdentifier> toRead = null;
        for (Operation op : this.columnOperations) {
            if (!op.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ColumnIdentifier>();
            }
            toRead.add(op.column.name);
        }
        return toRead == null ? null : this.readRows(partitionKeys, clusteringPrefix, toRead, this.cfm, local, cl);
    }

    protected Map<ByteBuffer, CQL3Row> readRows(List<ByteBuffer> partitionKeys, Composite rowPrefix, Set<ColumnIdentifier> toRead, CFMetaData cfm, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        try {
            cl.validateForRead(this.keyspace());
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(String.format("Write operation require a read but consistency %s is not supported on reads", new Object[]{cl}));
        }
        ColumnSlice[] slices = new ColumnSlice[toRead.size()];
        int i = 0;
        for (ColumnIdentifier name : toRead) {
            slices[i++] = cfm.comparator.create(rowPrefix, name).slice();
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(partitionKeys.size());
        long now = System.currentTimeMillis();
        for (ByteBuffer key : partitionKeys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, this.columnFamily(), now, new SliceQueryFilter(slices, false, Integer.MAX_VALUE)));
        }
        List<Row> rows = local ? SelectStatement.readLocally(this.keyspace(), commands) : StorageProxy.read(commands, cl);
        HashMap<ByteBuffer, CQL3Row> map = new HashMap<ByteBuffer, CQL3Row>();
        for (Row row : rows) {
            Iterator<CQL3Row> iter;
            if (row.cf == null || row.cf.isEmpty() || !(iter = cfm.comparator.CQL3RowBuilder(now).group(row.cf.getSortedColumns().iterator())).hasNext()) continue;
            map.put(row.key.key, iter.next());
            assert (!iter.hasNext());
        }
        return map;
    }

    public boolean hasConditions() {
        return this.ifNotExists || this.columnConditions != null && !this.columnConditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (this.hasConditions() && options.getProtocolVersion() == 1) {
            throw new InvalidRequestException("Conditional updates are not supported by the protocol version in use. You need to upgrade to a driver using the native protocol v2.");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options.getValues(), false, cl, queryState.getTimestamp(), false);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        if (keys.size() > 1) {
            throw new InvalidRequestException("IN on the partition key is not supported with conditional updates");
        }
        Composite clusteringPrefix = this.createClusteringPrefix(variables);
        ByteBuffer key = keys.get(0);
        ThriftValidation.validateKey(this.cfm, key);
        UpdateParameters updParams = new UpdateParameters(this.cfm, variables, queryState.getTimestamp(), this.getTimeToLive(variables), null);
        ColumnFamily updates = this.updateForKey(key, clusteringPrefix, updParams);
        long now = queryState.getTimestamp() * 1000L;
        CQL3CasConditions conditions = this.ifNotExists ? new NotExistCondition(clusteringPrefix, now) : new ColumnsConditions(clusteringPrefix, this.cfm, key, this.columnConditions, variables, now);
        ColumnFamily result = StorageProxy.cas(this.keyspace(), this.columnFamily(), key, conditions, updates, options.getSerialConsistency(), options.getConsistency());
        return new ResultMessage.Rows(this.buildCasResultSet(key, result));
    }

    private ResultSet buildCasResultSet(ByteBuffer key, ColumnFamily cf) throws InvalidRequestException {
        boolean success = cf == null;
        ColumnSpecification spec = new ColumnSpecification(this.keyspace(), this.columnFamily(), CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.Metadata metadata = new ResultSet.Metadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, this.buildCasFailureResultSet(key, cf));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1 && right.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList row = new ArrayList(size);
        row.addAll(left.rows.get(0));
        row.addAll(right.rows.get(0));
        return new ResultSet(new ResultSet.Metadata(specs), Collections.singletonList(row));
    }

    private ResultSet buildCasFailureResultSet(ByteBuffer key, ColumnFamily cf) throws InvalidRequestException {
        Selection selection;
        if (this.ifNotExists) {
            selection = Selection.wildcard(this.cfm);
        } else {
            ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>(this.columnConditions.size());
            for (Operation condition : this.columnConditions) {
                defs.add(condition.column);
            }
            selection = Selection.forColumns(defs);
        }
        long now = System.currentTimeMillis();
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(now);
        SelectStatement.forSelection(this.cfm, selection).processColumnFamily(key, cf, Collections.emptyList(), now, builder);
        return builder.build();
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState) throws RequestValidationException, RequestExecutionException {
        if (this.hasConditions()) {
            throw new UnsupportedOperationException();
        }
        for (IMutation iMutation : this.getMutations(Collections.emptyList(), true, null, queryState.getTimestamp(), false)) {
            assert (iMutation instanceof Mutation);
            ((Mutation)iMutation).apply();
        }
        return null;
    }

    public Collection<? extends IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now, boolean isBatch) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        Composite clusteringPrefix = this.createClusteringPrefix(variables);
        Map<ByteBuffer, CQL3Row> rows = this.readRequiredRows(keys, clusteringPrefix, local, cl);
        UpdateParameters params = new UpdateParameters(this.cfm, variables, this.getTimestamp(now, variables), this.getTimeToLive(variables), rows);
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(this.cfm, key);
            ColumnFamily cf = this.updateForKey(key, clusteringPrefix, params);
            mutations.add(this.makeMutation(key, cf, cl, isBatch));
        }
        return mutations;
    }

    private IMutation makeMutation(ByteBuffer key, ColumnFamily cf, ConsistencyLevel cl, boolean isBatch) {
        Mutation mutation;
        if (isBatch) {
            mutation = new Mutation(this.cfm.ksName, key);
            mutation.add(cf);
        } else {
            mutation = new Mutation(this.cfm.ksName, key, cf);
        }
        return this.isCounter() ? new CounterMutation(mutation, cl) : mutation;
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final Attributes.Raw attrs;
        private final List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions;
        private final boolean ifNotExists;

        protected Parsed(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions, boolean ifNotExists) {
            super(name);
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames);
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames);
        }

        public ModificationStatement prepare(VariableSpecifications boundNames) throws InvalidRequestException {
            CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            ModificationStatement stmt = this.prepareInternal(metadata, boundNames, preparedAttributes);
            if (this.ifNotExists || !this.conditions.isEmpty()) {
                if (stmt.isCounter()) {
                    throw new InvalidRequestException("Conditional updates are not supported on counter tables");
                }
                if (this.attrs.timestamp != null) {
                    throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
                }
                if (this.ifNotExists) {
                    assert (this.conditions.isEmpty());
                    stmt.setIfNotExistCondition();
                } else {
                    for (Pair<ColumnIdentifier, Operation.RawUpdate> entry : this.conditions) {
                        ColumnDefinition def = metadata.getColumnDefinition((ColumnIdentifier)entry.left);
                        if (def == null) {
                            throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                        }
                        if (def.type instanceof ListType) {
                            throw new InvalidRequestException(String.format("List operation (%s) are not allowed in conditional updates", def.name));
                        }
                        Operation condition = ((Operation.RawUpdate)entry.right).prepare(this.keyspace(), def);
                        assert (!condition.requiresRead());
                        condition.collectMarkerSpecification(boundNames);
                        switch (def.kind) {
                            case PARTITION_KEY: 
                            case CLUSTERING_COLUMN: {
                                throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                            }
                            case COMPACT_VALUE: 
                            case REGULAR: {
                                stmt.addCondition(condition);
                            }
                        }
                    }
                }
            }
            return stmt;
        }

        protected abstract ModificationStatement prepareInternal(CFMetaData var1, VariableSpecifications var2, Attributes var3) throws InvalidRequestException;
    }

    private static class ColumnsConditions
    extends CQL3CasConditions {
        private final ColumnFamily expected;

        private ColumnsConditions(Composite rowPrefix, CFMetaData cfm, ByteBuffer key, Collection<Operation> conditions, List<ByteBuffer> variables, long now) throws InvalidRequestException {
            super(rowPrefix, now);
            this.expected = ArrayBackedSortedColumns.factory.create(cfm);
            UpdateParameters params = new UpdateParameters(cfm, variables, now, 0, null);
            for (Operation condition : conditions) {
                condition.execute(key, this.expected, rowPrefix, params);
            }
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return false;
            }
            for (Cell e : this.expected) {
                Cell c = current.getColumn(e.name());
                if (!(e.isLive(this.now) ? c == null || !c.isLive(this.now) || !c.value().equals(e.value()) : c != null && c.isLive(this.now))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.expected.toString();
        }
    }

    private static class NotExistCondition
    extends CQL3CasConditions {
        private NotExistCondition(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            return current == null || current.hasOnlyTombstones(this.now);
        }
    }

    private static abstract class CQL3CasConditions
    implements CASConditions {
        protected final Composite rowPrefix;
        protected final long now;

        protected CQL3CasConditions(Composite rowPrefix, long now) {
            this.rowPrefix = rowPrefix;
            this.now = now;
        }

        @Override
        public IDiskAtomFilter readFilter() {
            return new SliceQueryFilter(this.rowPrefix.slice(), false, 1, this.rowPrefix.size());
        }
    }
}

