/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(int boundTerms, CFMetaData cfm, Attributes attrs) {
        super(boundTerms, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return false;
    }

    @Override
    public ColumnFamily updateForKey(ByteBuffer key, Composite prefix, UpdateParameters params) throws InvalidRequestException {
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(this.cfm);
        List<Operation> deletions = this.getOperations();
        if (prefix.size() < this.cfm.clusteringColumns().size() && !deletions.isEmpty()) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s since %s specified", this.getFirstEmptyKey(), deletions.iterator().next().column.name));
        }
        if (deletions.isEmpty()) {
            if (prefix.isEmpty()) {
                ((ColumnFamily)cf).delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
            } else if (this.cfm.comparator.isDense() && prefix.size() == this.cfm.clusteringColumns().size()) {
                cf.addAtom(params.makeTombstone(this.cfm.comparator.create(prefix, null)));
            } else {
                cf.addAtom(params.makeRangeTombstone(prefix.slice()));
            }
        } else {
            for (Operation op : deletions) {
                op.execute(key, cf, prefix, params);
            }
        }
        return cf;
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final List<Relation> whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, List<Relation> whereClause, List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions) {
            super(name, attrs, conditions, false);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            DeleteStatement stmt = new DeleteStatement(boundNames.size(), cfm, attrs);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnDefinition def = cfm.getColumnDefinition(deletion.affectedColumn());
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", deletion.affectedColumn()));
                }
                if (def.kind != ColumnDefinition.Kind.REGULAR && def.kind != ColumnDefinition.Kind.COMPACT_VALUE) {
                    throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", def.name));
                }
                Operation op = deletion.prepare(cfm.ksName, def);
                op.collectMarkerSpecification(boundNames);
                stmt.addOperation(op);
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }
}

