/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type.Raw validator;
    public final ColumnIdentifier columnName;
    private final CFPropDefs cfProps;
    private final Map<ColumnIdentifier, ColumnIdentifier> renames;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier columnName, CQL3Type.Raw validator, CFPropDefs cfProps, Map<ColumnIdentifier, ColumnIdentifier> renames) {
        super(name);
        this.oType = type;
        this.columnName = columnName;
        this.validator = validator;
        this.cfProps = cfProps;
        this.renames = renames;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public void announceMigration() throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.clone();
        CQL3Type validator = this.validator == null ? null : this.validator.prepare(this.keyspace());
        ColumnDefinition def = this.columnName == null ? null : cfm.getColumnDefinition(this.columnName);
        switch (this.oType) {
            case ADD: {
                AbstractType<?> type;
                if (cfm.comparator.isDense()) {
                    throw new InvalidRequestException("Cannot add new column to a compact CF");
                }
                if (def != null) {
                    switch (def.kind) {
                        case PARTITION_KEY: 
                        case CLUSTERING_COLUMN: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", this.columnName));
                        }
                        case REGULAR: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", this.columnName));
                        }
                    }
                }
                if ((type = validator.getType()) instanceof CollectionType) {
                    if (!cfm.comparator.supportCollections()) {
                        throw new InvalidRequestException("Cannot use collection types with non-composite PRIMARY KEY");
                    }
                    if (cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use collection types with Super column family");
                    }
                    cfm.comparator = cfm.comparator.addCollection(this.columnName, (CollectionType)type);
                }
                Integer componentIndex = cfm.comparator.isCompound() ? Integer.valueOf(cfm.comparator.clusteringPrefixSize()) : null;
                cfm.addColumnDefinition(ColumnDefinition.regularDef(cfm, this.columnName.bytes, type, componentIndex));
                break;
            }
            case ALTER: {
                if (def == null) {
                    throw new InvalidRequestException(String.format("Cell %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (def.kind) {
                    case PARTITION_KEY: {
                        AbstractType<?> newType = validator.getType();
                        if (newType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", this.columnName));
                        }
                        if (cfm.getKeyValidator() instanceof CompositeType) {
                            List<AbstractType<?>> oldTypes = ((CompositeType)cfm.getKeyValidator()).types;
                            if (!newType.isValueCompatibleWith(oldTypes.get(def.position()))) {
                                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, oldTypes.get(def.position()).asCQL3Type(), validator));
                            }
                            ArrayList newTypes = new ArrayList(oldTypes);
                            newTypes.set(def.position(), newType);
                            cfm.keyValidator(CompositeType.getInstance(newTypes));
                            break;
                        }
                        if (!newType.isValueCompatibleWith(cfm.getKeyValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, cfm.getKeyValidator().asCQL3Type(), validator));
                        }
                        cfm.keyValidator(newType);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        AbstractType<?> oldType = cfm.comparator.subtype(def.position());
                        if (!validator.getType().isCompatibleWith(oldType)) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", this.columnName, oldType.asCQL3Type(), validator));
                        }
                        cfm.comparator = cfm.comparator.setSubtype(def.position(), validator.getType());
                        break;
                    }
                    case COMPACT_VALUE: {
                        if (!validator.getType().isValueCompatibleWith(cfm.getDefaultValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, cfm.getDefaultValidator().asCQL3Type(), validator));
                        }
                        cfm.defaultValidator(validator.getType());
                        break;
                    }
                    case REGULAR: {
                        if (validator.getType().isValueCompatibleWith(def.type)) break;
                        throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, def.type.asCQL3Type(), validator));
                    }
                }
                cfm.addOrReplaceColumnDefinition(def.withNewType(validator.getType()));
                break;
            }
            case DROP: {
                if (!cfm.isCQL3Table()) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 CF");
                }
                if (def == null) {
                    throw new InvalidRequestException(String.format("Cell %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING_COLUMN: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", this.columnName));
                    }
                    case REGULAR: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.regularColumns()) {
                            if (!columnDef.name.equals(this.columnName)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                        cfm.recordColumnDrop(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                this.cfProps.applyToCFMetadata(cfm);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier, ColumnIdentifier> entry : this.renames.entrySet()) {
                    cfm.renameColumn(entry.getKey(), entry.getValue());
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.columnName, this.validator});
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

