/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class UTMetaData {
    private final Map<ByteBuffer, UserType> userTypes;

    public UTMetaData() {
        this(new HashMap<ByteBuffer, UserType>());
    }

    UTMetaData(Map<ByteBuffer, UserType> types) {
        this.userTypes = types;
    }

    private static UserType fromSchema(UntypedResultSet.Row row) {
        try {
            String keyspace = row.getString("keyspace_name");
            ByteBuffer name = ByteBufferUtil.bytes(row.getString("type_name"));
            List<String> rawColumns = row.getList("column_names", UTF8Type.instance);
            List<String> rawTypes = row.getList("column_types", UTF8Type.instance);
            ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>(rawColumns.size());
            for (String rawColumn : rawColumns) {
                columns.add(ByteBufferUtil.bytes(rawColumn));
            }
            ArrayList types = new ArrayList(rawTypes.size());
            for (String rawType : rawTypes) {
                types.add(TypeParser.parse(rawType));
            }
            return new UserType(keyspace, name, columns, types);
        }
        catch (RequestValidationException e) {
            throw new AssertionError();
        }
    }

    public static Map<ByteBuffer, UserType> fromSchema(Row row) {
        UntypedResultSet results = QueryProcessor.resultify("SELECT * FROM system.schema_usertypes", row);
        HashMap<ByteBuffer, UserType> types = new HashMap<ByteBuffer, UserType>(results.size());
        for (UntypedResultSet.Row result : results) {
            UserType type = UTMetaData.fromSchema(result);
            types.put(type.name, type);
        }
        return types;
    }

    public static Mutation toSchema(UserType newType, long timestamp) {
        return UTMetaData.toSchema(new Mutation("system", SystemKeyspace.getSchemaKSKey(newType.keyspace)), newType, timestamp);
    }

    public static Mutation toSchema(Mutation mutation, UserType newType, long timestamp) {
        ColumnFamily cf = mutation.addOrGet("schema_usertypes");
        Composite prefix = CFMetaData.SchemaUserTypesCf.comparator.make(newType.name);
        CFRowAdder adder = new CFRowAdder(cf, prefix, timestamp);
        adder.resetCollection("column_names");
        adder.resetCollection("column_types");
        for (ByteBuffer name : newType.columnNames) {
            adder.addListEntry("column_names", name);
        }
        for (AbstractType type : newType.types) {
            adder.addListEntry("column_types", type.toString());
        }
        return mutation;
    }

    public Mutation toSchema(Mutation mutation, long timestamp) {
        for (UserType ut : this.userTypes.values()) {
            UTMetaData.toSchema(mutation, ut, timestamp);
        }
        return mutation;
    }

    public static Mutation dropFromSchema(UserType droppedType, long timestamp) {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(droppedType.keyspace));
        ColumnFamily cf = mutation.addOrGet("schema_usertypes");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        Composite prefix = CFMetaData.SchemaUserTypesCf.comparator.make(droppedType.name);
        cf.addAtom(new RangeTombstone(prefix, prefix.end(), timestamp, ldt));
        return mutation;
    }

    public UserType getType(ByteBuffer typeName) {
        return this.userTypes.get(typeName);
    }

    public Map<ByteBuffer, UserType> getAllTypes() {
        return new HashMap<ByteBuffer, UserType>(this.userTypes);
    }

    public void addType(UserType type) {
        UserType old = this.userTypes.get(type.name);
        assert (old == null || type.isCompatibleWith(old));
        this.userTypes.put(type.name, type);
    }

    public void removeType(UserType type) {
        this.userTypes.remove(type.name);
    }

    public boolean equals(Object that) {
        if (!(that instanceof UTMetaData)) {
            return false;
        }
        return this.userTypes.equals(((UTMetaData)that).userTypes);
    }
}

