/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompositeType
extends AbstractCompositeType {
    public static final int STATIC_MARKER = 65535;
    public final List<AbstractType<?>> types;
    private static final Map<List<AbstractType<?>>, CompositeType> instances = new HashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static CompositeType getInstance(AbstractType ... types) {
        return CompositeType.getInstance(Arrays.asList(types));
    }

    @Override
    protected boolean readIsStatic(ByteBuffer bb) {
        return CompositeType.readStatic(bb);
    }

    private static boolean readStatic(ByteBuffer bb) {
        if (bb.remaining() < 2) {
            return false;
        }
        int header = ByteBufferUtil.getShortLength(bb, bb.position());
        if ((header & 0xFFFF) != 65535) {
            return false;
        }
        ByteBufferUtil.readShortLength(bb);
        return true;
    }

    public static synchronized CompositeType getInstance(List<AbstractType<?>> types) {
        assert (types != null && !types.isEmpty());
        CompositeType ct = instances.get(types);
        if (ct == null) {
            ct = new CompositeType(types);
            instances.put(types, ct);
        }
        return ct;
    }

    private CompositeType(List<AbstractType<?>> types) {
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb) {
        try {
            return this.types.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Cannot get comparator " + i + " in " + this + ". " + "This might due to a mismatch between the schema and the data read", e);
        }
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.getComparator(i, bb1);
    }

    @Override
    protected AbstractType<?> getAndAppendComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType<?> validateComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        assert (objects.length == this.types.size());
        ByteBuffer[] serialized = new ByteBuffer[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ByteBuffer buffer;
            serialized[i] = buffer = this.types.get(i).decompose(objects[i]);
        }
        return CompositeType.build(serialized);
    }

    public static ByteBuffer extractComponent(ByteBuffer bb, int idx) {
        bb = bb.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            ByteBuffer c = ByteBufferUtil.readBytesWithShortLength(bb);
            if (i == idx) {
                return c;
            }
            bb.get();
            ++i;
        }
        return null;
    }

    public ByteBuffer extractLastComponent(ByteBuffer bb) {
        int idx = this.types.get(this.types.size() - 1) instanceof ColumnToCollectionType ? this.types.size() - 2 : this.types.size() - 1;
        return CompositeType.extractComponent(bb, idx);
    }

    public static boolean isStaticName(ByteBuffer bb) {
        return bb.remaining() >= 2 && (ByteBufferUtil.getShortLength(bb, bb.position()) & 0xFFFF) == 65535;
    }

    @Override
    public int componentsCount() {
        return this.types.size();
    }

    @Override
    public List<AbstractType<?>> getComponents() {
        return this.types;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (this == otherType) {
            return true;
        }
        if (!(otherType instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)otherType;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames, SliceQueryFilter filter) {
        assert (minColumnNames.size() == maxColumnNames.size());
        block0: for (ColumnSlice slice : filter.slices) {
            ByteBuffer[] start = this.split(filter.isReversed() ? slice.finish : slice.start);
            ByteBuffer[] finish = this.split(filter.isReversed() ? slice.start : slice.finish);
            if (this.compare(start, maxColumnNames, true) > 0 || this.compare(finish, minColumnNames, false) < 0) continue;
            for (int i = 0; i < minColumnNames.size(); ++i) {
                ByteBuffer f;
                AbstractType<?> t = this.types.get(i);
                ByteBuffer s = i < start.length ? start[i] : ByteBufferUtil.EMPTY_BYTE_BUFFER;
                ByteBuffer byteBuffer = f = i < finish.length ? finish[i] : ByteBufferUtil.EMPTY_BYTE_BUFFER;
                if (i > 0 && !t.intersects(minColumnNames.get(i), maxColumnNames.get(i), s, f)) continue block0;
                if (i >= start.length || i >= finish.length || t.compare(s, f) != 0) break;
            }
            return true;
        }
        return false;
    }

    private int compare(ByteBuffer[] sliceBounds, List<ByteBuffer> sstableBounds, boolean isSliceStart) {
        for (int i = 0; i < sstableBounds.size(); ++i) {
            if (i >= sliceBounds.length) {
                return isSliceStart ? -1 : 1;
            }
            int comparison = this.types.get(i).compare(sliceBounds[i], sstableBounds.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public static ByteBuffer build(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : buffers) {
            ByteBufferUtil.writeShortLength(out, bb.remaining());
            out.put(bb.duplicate());
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    public static class Builder
    implements ColumnNameBuilder {
        private final CompositeType composite;
        private final List<ByteBuffer> components;
        private final byte[] endOfComponents;
        private int serializedSize;
        private final boolean isStatic;

        public Builder(CompositeType composite) {
            this(composite, new ArrayList<ByteBuffer>(composite.types.size()), new byte[composite.types.size()], false);
        }

        public static Builder staticBuilder(CompositeType composite) {
            return new Builder(composite, new ArrayList<ByteBuffer>(composite.types.size()), new byte[composite.types.size()], true);
        }

        private Builder(CompositeType composite, List<ByteBuffer> components, byte[] endOfComponents, boolean isStatic) {
            assert (endOfComponents.length == composite.types.size());
            this.composite = composite;
            this.components = components;
            this.endOfComponents = endOfComponents;
            this.isStatic = isStatic;
            if (isStatic) {
                this.serializedSize = 2;
            }
        }

        private Builder(Builder b) {
            this(b.composite, new ArrayList<ByteBuffer>(b.components), Arrays.copyOf(b.endOfComponents, b.endOfComponents.length), b.isStatic);
            this.serializedSize = b.serializedSize;
        }

        @Override
        public Builder add(ByteBuffer bb) {
            if (this.components.size() >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            this.components.add(bb);
            this.serializedSize += 3 + bb.remaining();
            return this;
        }

        @Override
        public int componentCount() {
            return this.components.size();
        }

        @Override
        public int remainingCount() {
            return this.composite.types.size() - this.components.size();
        }

        @Override
        public ByteBuffer get(int i) {
            return this.components.get(i);
        }

        @Override
        public ByteBuffer build() {
            try {
                DataOutputBuffer out = new DataOutputBuffer(this.serializedSize);
                if (this.isStatic) {
                    out.writeShort(65535);
                }
                for (int i = 0; i < this.components.size(); ++i) {
                    ByteBufferUtil.writeWithShortLength(this.components.get(i), out);
                    out.write(this.endOfComponents[i]);
                }
                return ByteBuffer.wrap(out.getData(), 0, out.getLength());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            if (this.components.isEmpty()) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            ByteBuffer bb = this.build();
            bb.put(bb.remaining() - 1, (byte)1);
            return bb;
        }

        @Override
        public ByteBuffer buildForRelation(Relation.Type op) {
            int current = this.components.size() - 1;
            switch (op) {
                case LT: {
                    this.endOfComponents[current] = -1;
                    break;
                }
                case GT: 
                case LTE: {
                    this.endOfComponents[current] = 1;
                    break;
                }
                default: {
                    this.endOfComponents[current] = 0;
                }
            }
            return this.build();
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public ByteBuffer getComponent(int i) {
            if (i >= this.components.size()) {
                throw new IllegalArgumentException();
            }
            return this.components.get(i);
        }
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

