/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;

public abstract class Lists {
    private Lists() {
    }

    public static ColumnSpecification indexSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("idx(" + column.name + ")", true), Int32Type.instance);
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((ListType)column.type).elements);
    }

    public static class DiscarderByIndex
    extends Operation {
        public DiscarderByIndex(ColumnIdentifier column, Term idx) {
            super(column, idx);
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal index = this.t.bind(params.variables);
            if (index == null) {
                throw new InvalidRequestException("Invalid null value for list index");
            }
            assert (index instanceof Constants.Value);
            List<Pair<ByteBuffer, Column>> existingList = params.getPrefetchedList(rowKey, this.columnName.key);
            int idx = ByteBufferUtil.toInt(((Constants.Value)index).bytes);
            if (idx < 0 || idx >= existingList.size()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, existingList.size()));
            }
            ByteBuffer elementName = ((Column)existingList.get((int)idx).right).name();
            cf.addColumn(params.makeTombstone(elementName));
        }
    }

    public static class Discarder
    extends Operation {
        public Discarder(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            List<Pair<ByteBuffer, Column>> existingList = params.getPrefetchedList(rowKey, this.columnName.key);
            if (existingList.isEmpty()) {
                return;
            }
            Term.Terminal value = this.t.bind(params.variables);
            if (value == null) {
                return;
            }
            assert (value instanceof Value);
            List<ByteBuffer> toDiscard = ((Value)value).elements;
            for (Pair<ByteBuffer, Column> p : existingList) {
                Column element = (Column)p.right;
                if (!toDiscard.contains(element.value())) continue;
                cf.addColumn(params.makeTombstone(element.name()));
            }
        }
    }

    public static class Prepender
    extends Operation {
        public Prepender(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.variables);
            if (value == null) {
                return;
            }
            assert (value instanceof Value);
            long time = 1262304000000L - (System.currentTimeMillis() - 1262304000000L);
            List<ByteBuffer> toAdd = ((Value)value).elements;
            ColumnNameBuilder column = this.maybeUpdatePrefix(cf.metadata(), prefix).add(this.columnName.key);
            for (int i = 0; i < toAdd.size(); ++i) {
                ColumnNameBuilder b = i == toAdd.size() - 1 ? column : column.copy();
                PrecisionTime pt = PrecisionTime.getNext(time);
                ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(pt.millis, pt.nanos));
                ByteBuffer cellName = b.add(uuid).build();
                cf.addColumn(params.makeColumn(cellName, toAdd.get(i)));
            }
        }
    }

    public static class Appender
    extends Operation {
        public Appender(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Appender.doAppend(this.t, cf, this.maybeUpdatePrefix(cf.metadata(), prefix).add(this.columnName.key), params);
        }

        static void doAppend(Term t, ColumnFamily cf, ColumnNameBuilder columnName, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = t.bind(params.variables);
            if (value == null) {
                return;
            }
            assert (value instanceof Value);
            List<ByteBuffer> toAdd = ((Value)value).elements;
            for (int i = 0; i < toAdd.size(); ++i) {
                ColumnNameBuilder b = i == toAdd.size() - 1 ? columnName : columnName.copy();
                ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
                ByteBuffer cellName = b.add(uuid).build();
                cf.addColumn(params.makeColumn(cellName, toAdd.get(i)));
            }
        }
    }

    public static class SetterByIndex
    extends Operation {
        private final Term idx;

        public SetterByIndex(ColumnIdentifier column, Term idx, Term t) {
            super(column, t);
            this.idx = idx;
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.idx.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer index = this.idx.bindAndGet(params.variables);
            ByteBuffer value = this.t.bindAndGet(params.variables);
            if (index == null) {
                throw new InvalidRequestException("Invalid null value for list index");
            }
            List<Pair<ByteBuffer, Column>> existingList = params.getPrefetchedList(rowKey, this.columnName.key);
            int idx = ByteBufferUtil.toInt(index);
            if (idx < 0 || idx >= existingList.size()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, existingList.size()));
            }
            ByteBuffer elementName = ((Column)existingList.get((int)idx).right).name();
            if (value == null) {
                cf.addColumn(params.makeTombstone(elementName));
            } else {
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("List value is too long. List values are limited to %d bytes but %d bytes value provided", 65535, value.remaining()));
                }
                cf.addColumn(params.makeColumn(elementName, value));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ColumnNameBuilder column = this.maybeUpdatePrefix(cf.metadata(), prefix).add(this.columnName.key);
            cf.addAtom(params.makeTombstoneForOverwrite(column.build(), column.buildAsEndOfRange()));
            Appender.doAppend(this.t, cf, column, params);
        }
    }

    private static class PrecisionTime {
        private static final long REFERENCE_TIME = 1262304000000L;
        private static final AtomicReference<PrecisionTime> last = new AtomicReference<PrecisionTime>(new PrecisionTime(Long.MAX_VALUE, 0));
        public final long millis;
        public final int nanos;

        PrecisionTime(long millis, int nanos) {
            this.millis = millis;
            this.nanos = nanos;
        }

        static PrecisionTime getNext(long millis) {
            PrecisionTime next;
            PrecisionTime current;
            do {
                current = last.get();
                assert (millis <= current.millis);
            } while (!last.compareAndSet(current, next = millis < current.millis ? new PrecisionTime(millis, 9999) : new PrecisionTime(millis, Math.max(0, current.nanos - 1))));
            return next;
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof ListType);
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer value = values.get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (ListType)this.receiver.type);
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final List<Term> elements;

        public DelayedValue(List<Term> elements) {
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size());
            for (Term t : this.elements) {
                ByteBuffer bytes = t.bindAndGet(values);
                if (bytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (bytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("List value is too long. List values are limited to %d bytes but %d bytes value provided", 65535, bytes.remaining()));
                }
                buffers.add(bytes);
            }
            return new Value(buffers);
        }
    }

    public static class Value
    extends Term.MultiItemTerminal {
        public final List<ByteBuffer> elements;

        public Value(List<ByteBuffer> elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer value, ListType type) throws InvalidRequestException {
            try {
                List l = (List)type.compose(value);
                ArrayList<ByteBuffer> elements = new ArrayList<ByteBuffer>(l.size());
                for (Object element : l) {
                    elements.add(type.elements.decompose(element));
                }
                return new Value(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get() {
            return CollectionType.pack(this.elements, this.elements.size());
        }

        @Override
        public List<ByteBuffer> getElements() {
            return this.elements;
        }
    }

    public static class Literal
    implements Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(receiver);
            ColumnSpecification valueSpec = Lists.valueSpecOf(receiver);
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            boolean allTerminal = true;
            for (Term.Raw rt : this.elements) {
                Term t = rt.prepare(valueSpec);
                if (t.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid list literal for %s: bind variables are not supported inside collection literals", receiver));
                }
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(values);
            return allTerminal ? value.bind(Collections.emptyList()) : value;
        }

        private void validateAssignableTo(ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof ListType)) {
                throw new InvalidRequestException(String.format("Invalid list literal for %s of type %s", receiver, receiver.type.asCQL3Type()));
            }
            ColumnSpecification valueSpec = Lists.valueSpecOf(receiver);
            for (Term.Raw rt : this.elements) {
                if (rt.isAssignableTo(valueSpec)) continue;
                throw new InvalidRequestException(String.format("Invalid list literal for %s: value %s is not of type %s", receiver, rt, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(receiver);
                return true;
            }
            catch (InvalidRequestException e) {
                return false;
            }
        }

        public String toString() {
            return this.elements.toString();
        }
    }
}

