/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.UserOptions;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class CreateUserStatement
extends AuthenticationStatement {
    private final String username;
    private final UserOptions opts;
    private final boolean superuser;

    public CreateUserStatement(String username, UserOptions opts, boolean superuser) {
        this.username = username;
        this.opts = opts;
        this.superuser = superuser;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        if (this.username.isEmpty()) {
            throw new InvalidRequestException("Username can't be an empty string");
        }
        this.opts.validate();
        state.ensureNotAnonymous();
        if (Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s already exists", this.username));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        if (!state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers are allowed to perform CREATE USER queries");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        DatabaseDescriptor.getAuthenticator().create(this.username, this.opts.getOptions());
        Auth.insertUser(this.username, this.superuser);
        return null;
    }
}

