/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.net.InetAddress;
import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;

public class SnapshotTask
extends AbstractFuture<InetAddress>
implements RunnableFuture<InetAddress> {
    private final RepairJobDesc desc;
    private final InetAddress endpoint;

    public SnapshotTask(RepairJobDesc desc, InetAddress endpoint) {
        this.desc = desc;
        this.endpoint = endpoint;
    }

    @Override
    public void run() {
        MessagingService.instance().sendRR(new SnapshotCommand(this.desc.keyspace, this.desc.columnFamily, this.desc.sessionId.toString(), false).createMessage(), this.endpoint, new SnapshotCallback(this));
    }

    static class SnapshotCallback
    implements IAsyncCallback {
        final SnapshotTask task;

        SnapshotCallback(SnapshotTask task) {
            this.task = task;
        }

        public void response(MessageIn msg) {
            this.task.set(this.task.endpoint);
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }
    }
}

