/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.service.StorageService;

public final class CompactionInfo
implements Serializable {
    private static final long serialVersionUID = 3695381572726744816L;
    private final CFMetaData cfm;
    private final OperationType tasktype;
    private final long completed;
    private final long total;
    private final String unit;

    public CompactionInfo(CFMetaData cfm, OperationType tasktype, long bytesComplete, long totalBytes) {
        this(cfm, tasktype, bytesComplete, totalBytes, "bytes");
    }

    public CompactionInfo(OperationType tasktype, long completed, long total, String unit) {
        this(null, tasktype, completed, total, unit);
    }

    public CompactionInfo(CFMetaData cfm, OperationType tasktype, long completed, long total, String unit) {
        this.tasktype = tasktype;
        this.completed = completed;
        this.total = total;
        this.cfm = cfm;
        this.unit = unit;
    }

    public CompactionInfo forProgress(long complete, long total) {
        return new CompactionInfo(this.cfm, this.tasktype, complete, total, this.unit);
    }

    public UUID getId() {
        return this.cfm.cfId;
    }

    public String getKeyspace() {
        return this.cfm.ksName;
    }

    public String getColumnFamily() {
        return this.cfm.cfName;
    }

    public CFMetaData getCFMetaData() {
        return this.cfm;
    }

    public long getCompleted() {
        return this.completed;
    }

    public long getTotal() {
        return this.total;
    }

    public OperationType getTaskType() {
        return this.tasktype;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.getTaskType()).append('@').append(this.getId());
        buff.append('(').append(this.getKeyspace()).append(", ").append(this.getColumnFamily());
        buff.append(", ").append(this.getCompleted()).append('/').append(this.getTotal());
        return buff.append(')').append(this.unit).toString();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", this.getId() == null ? "" : this.getId().toString());
        ret.put("keyspace", this.getKeyspace());
        ret.put("columnfamily", this.getColumnFamily());
        ret.put("completed", Long.toString(this.completed));
        ret.put("total", Long.toString(this.total));
        ret.put("taskType", this.tasktype.toString());
        ret.put("unit", this.unit);
        return ret;
    }

    public static abstract class Holder {
        private volatile boolean stopRequested = false;
        double load = StorageService.instance.getLoad();
        double reportedSeverity = 0.0;

        public abstract CompactionInfo getCompactionInfo();

        public void stop() {
            this.stopRequested = true;
        }

        public boolean isStopRequested() {
            return this.stopRequested;
        }

        public void started() {
            this.reportedSeverity = (double)this.getCompactionInfo().getTotal() / this.load;
            StorageService.instance.reportSeverity(this.reportedSeverity);
        }

        public void finished() {
            if (this.reportedSeverity != 0.0) {
                StorageService.instance.reportSeverity(-this.reportedSeverity);
            }
            this.reportedSeverity = 0.0;
        }
    }
}

