/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.service.IMigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger logger = LoggerFactory.getLogger(Auth.class);
    public static final String DEFAULT_SUPERUSER_NAME = "cassandra";
    public static final long SUPERUSER_SETUP_DELAY = Long.getLong("cassandra.superuser_setup_delay_ms", 10000L);
    public static final String AUTH_KS = "system_auth";
    public static final String USERS_CF = "users";
    private static final String USERS_CF_SCHEMA = String.format("CREATE TABLE %s.%s (name text,super boolean,PRIMARY KEY(name)) WITH gc_grace_seconds=%d", "system_auth", "users", 7776000);
    private static SelectStatement selectUserStatement;

    public static boolean isExistingUser(String username) {
        return !Auth.selectUser(username).isEmpty();
    }

    public static boolean isSuperuser(String username) {
        UntypedResultSet result = Auth.selectUser(username);
        return !result.isEmpty() && result.one().getBoolean("super");
    }

    public static void insertUser(String username, boolean isSuper) throws RequestExecutionException {
        QueryProcessor.process(String.format("INSERT INTO %s.%s (name, super) VALUES ('%s', %s)", AUTH_KS, USERS_CF, Auth.escape(username), isSuper), Auth.consistencyForUser(username));
    }

    public static void deleteUser(String username) throws RequestExecutionException {
        QueryProcessor.process(String.format("DELETE FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username)), Auth.consistencyForUser(username));
    }

    public static void setup() {
        if (DatabaseDescriptor.getAuthenticator() instanceof AllowAllAuthenticator) {
            return;
        }
        Auth.setupAuthKeyspace();
        Auth.setupUsersTable();
        DatabaseDescriptor.getAuthenticator().setup();
        DatabaseDescriptor.getAuthorizer().setup();
        MigrationManager.instance.register(new MigrationListener());
        if (DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress()) || !DatabaseDescriptor.isAutoBootstrap()) {
            StorageService.tasks.schedule(new Runnable(){

                @Override
                public void run() {
                    Auth.setupDefaultSuperuser();
                }
            }, SUPERUSER_SETUP_DELAY, TimeUnit.MILLISECONDS);
        }
        try {
            String query = String.format("SELECT * FROM %s.%s WHERE name = ?", AUTH_KS, USERS_CF);
            selectUserStatement = (SelectStatement)QueryProcessor.parseStatement((String)query).prepare().statement;
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ConsistencyLevel consistencyForUser(String username) {
        if (username.equals(DEFAULT_SUPERUSER_NAME)) {
            return ConsistencyLevel.QUORUM;
        }
        return ConsistencyLevel.ONE;
    }

    private static void setupAuthKeyspace() {
        if (Schema.instance.getKSMetaData(AUTH_KS) == null) {
            try {
                KSMetaData ksm = KSMetaData.newKeyspace(AUTH_KS, SimpleStrategy.class.getName(), (Map<String, String>)ImmutableMap.of((Object)"replication_factor", (Object)"1"), true);
                MigrationManager.announceNewKeyspace(ksm, 0L);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setupUsersTable() {
        if (Schema.instance.getCFMetaData(AUTH_KS, USERS_CF) == null) {
            try {
                QueryProcessor.process(USERS_CF_SCHEMA, ConsistencyLevel.ANY);
            }
            catch (RequestExecutionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setupDefaultSuperuser() {
        try {
            if (!Auth.hasExistingUsers()) {
                QueryProcessor.process(String.format("INSERT INTO %s.%s (name, super) VALUES ('%s', %s) USING TIMESTAMP 0", AUTH_KS, USERS_CF, DEFAULT_SUPERUSER_NAME, true), ConsistencyLevel.QUORUM);
                logger.info("Created default superuser '{}'", (Object)DEFAULT_SUPERUSER_NAME);
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("Skipped default superuser setup: some nodes were not ready");
        }
    }

    private static boolean hasExistingUsers() throws RequestExecutionException {
        String defaultSUQuery = String.format("SELECT * FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, DEFAULT_SUPERUSER_NAME);
        String allUsersQuery = String.format("SELECT * FROM %s.%s LIMIT 1", AUTH_KS, USERS_CF);
        return !QueryProcessor.process(defaultSUQuery, ConsistencyLevel.QUORUM).isEmpty() || !QueryProcessor.process(allUsersQuery, ConsistencyLevel.QUORUM).isEmpty();
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static UntypedResultSet selectUser(String username) {
        try {
            ResultMessage.Rows rows = selectUserStatement.execute(QueryState.forInternalCalls(), new QueryOptions(Auth.consistencyForUser(username), Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(username)})));
            return new UntypedResultSet(rows.result);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MigrationListener
    implements IMigrationListener {
        @Override
        public void onDropKeyspace(String ksName) {
            DatabaseDescriptor.getAuthorizer().revokeAll(DataResource.keyspace(ksName));
        }

        @Override
        public void onDropColumnFamily(String ksName, String cfName) {
            DatabaseDescriptor.getAuthorizer().revokeAll(DataResource.columnFamily(ksName, cfName));
        }

        @Override
        public void onCreateKeyspace(String ksName) {
        }

        @Override
        public void onCreateColumnFamily(String ksName, String cfName) {
        }

        @Override
        public void onUpdateKeyspace(String ksName) {
        }

        @Override
        public void onUpdateColumnFamily(String ksName, String cfName) {
        }
    }
}

