/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.serializers.MarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
OnDiskAtomIterator {
    private static final Logger logger = LoggerFactory.getLogger(SSTableIdentityIterator.class);
    private final DecoratedKey key;
    private final DataInput in;
    public final long dataSize;
    public final ColumnSerializer.Flag flag;
    private final ColumnFamily columnFamily;
    private final int columnCount;
    private final Iterator<OnDiskAtom> atomIterator;
    private final Descriptor.Version dataVersion;
    private final int expireBefore;
    private final boolean validateColumns;
    private final String filename;
    private final SSTableReader sstable;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataSize) {
        this(sstable, file, key, dataSize, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataSize, boolean checkData) {
        this(sstable.metadata, file, file.getPath(), key, dataSize, checkData, sstable, ColumnSerializer.Flag.LOCAL);
    }

    private SSTableIdentityIterator(CFMetaData metadata, DataInput in, String filename, DecoratedKey key, long dataSize, boolean checkData, SSTableReader sstable, ColumnSerializer.Flag flag) {
        assert (!checkData || sstable != null);
        this.in = in;
        this.filename = filename;
        this.key = key;
        this.dataSize = dataSize;
        this.expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.flag = flag;
        this.validateColumns = checkData;
        this.dataVersion = sstable == null ? Descriptor.Version.CURRENT : sstable.descriptor.version;
        this.sstable = sstable;
        try {
            this.columnFamily = EmptyColumns.factory.create(metadata);
            this.columnFamily.delete(DeletionTime.serializer.deserialize(in));
            this.columnCount = this.dataVersion.hasRowSizeAndColumnCount ? in.readInt() : Integer.MAX_VALUE;
            this.atomIterator = this.columnFamily.metadata().getOnDiskIterator(in, this.columnCount, flag, this.expireBefore, this.dataVersion);
        }
        catch (IOException e) {
            if (sstable != null) {
                sstable.markSuspect();
            }
            throw new CorruptSSTableException((Exception)e, filename);
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.atomIterator.hasNext();
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                if (this.sstable != null) {
                    this.sstable.markSuspect();
                }
                throw new CorruptSSTableException((Exception)((IOException)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    @Override
    public OnDiskAtom next() {
        try {
            OnDiskAtom atom = this.atomIterator.next();
            if (this.validateColumns) {
                atom.validateFields(this.columnFamily.metadata());
            }
            return atom;
        }
        catch (MarshalException me) {
            throw new CorruptSSTableException((Exception)me, this.filename);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public String getPath() {
        if (this.in instanceof RandomAccessReader) {
            RandomAccessReader file = (RandomAccessReader)this.in;
            return file.getPath();
        }
        throw new UnsupportedOperationException();
    }

    public ColumnFamily getColumnFamilyWithColumns(ColumnFamily.Factory containerFactory) {
        Object cf = this.columnFamily.cloneMeShallow(containerFactory, false);
        try {
            Iterator<OnDiskAtom> iter = ((ColumnFamily)cf).metadata().getOnDiskIterator(this.in, this.columnCount, this.flag, this.expireBefore, this.dataVersion);
            while (iter.hasNext()) {
                ((ColumnFamily)cf).addAtom(iter.next());
            }
            if (this.validateColumns) {
                try {
                    ((ColumnFamily)cf).metadata().validateColumns((Iterable<Column>)cf);
                }
                catch (MarshalException e) {
                    throw new RuntimeException("Error validating row " + this.key, e);
                }
            }
            return cf;
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                if (this.sstable != null) {
                    this.sstable.markSuspect();
                }
                throw new CorruptSSTableException((Exception)((IOException)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }
}

