/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneScrubber {
    private static final String TOOL_NAME = "sstablescrub";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String MANIFEST_CHECK_OPTION = "manifest-check";
    private static final String SKIP_CORRUPTED_OPTION = "skip-corrupted";
    private static final String NO_VALIDATE_OPTION = "no-validate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = Options.parseArgs(args);
        try {
            DatabaseDescriptor.loadSchemas(false);
            if (Schema.instance.getCFMetaData(options.keyspaceName, options.cfName) == null) {
                throw new IllegalArgumentException(String.format("Unknown keyspace/columnFamily %s.%s", options.keyspaceName, options.cfName));
            }
            Keyspace keyspace = Keyspace.openWithoutSSTables(options.keyspaceName);
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(options.cfName);
            String snapshotName = "pre-scrub-" + System.currentTimeMillis();
            OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
            Directories.SSTableLister lister = cfs.directories.sstableLister().skipTemporary(true);
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
                Set<Component> components = entry.getValue();
                if (!components.contains(Component.DATA) || !components.contains(Component.PRIMARY_INDEX)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation(entry.getKey(), components, cfs.metadata);
                    sstables.add(sstable);
                    File snapshotDirectory = Directories.getSnapshotDirectory(sstable.descriptor, snapshotName);
                    sstable.createLinks(snapshotDirectory.getPath());
                }
                catch (Exception e) {
                    System.err.println(String.format("Error Loading %s: %s", entry.getKey(), e.getMessage()));
                    if (!options.debug) continue;
                    e.printStackTrace(System.err);
                }
            }
            System.out.println(String.format("Pre-scrub sstables snapshotted into snapshot %s", snapshotName));
            if (cfs.directories.tryGetLeveledManifest() != null) {
                cfs.directories.snapshotLeveledManifest(snapshotName);
                System.out.println(String.format("Leveled manifest snapshotted into snapshot %s", snapshotName));
            }
            LeveledManifest manifest = null;
            if (cfs.getCompactionStrategy() instanceof LeveledCompactionStrategy) {
                int maxSizeInMB = (int)(cfs.getCompactionStrategy().getMaxSSTableBytes() / 0x100000L);
                manifest = LeveledManifest.create(cfs, maxSizeInMB, sstables);
            }
            if (!options.manifestCheckOnly) {
                for (SSTableReader sstable : sstables) {
                    try {
                        try (Scrubber scrubber = new Scrubber(cfs, sstable, options.skipCorrupted, !options.noValidate, handler, true);){
                            scrubber.scrub();
                        }
                        if (manifest != null) {
                            if (scrubber.getNewInOrderSSTable() != null) {
                                manifest.add(scrubber.getNewInOrderSSTable());
                            }
                            List<SSTableReader> added = scrubber.getNewSSTable() == null ? Collections.emptyList() : Collections.singletonList(scrubber.getNewSSTable());
                            manifest.replace(Collections.singletonList(sstable), added);
                        }
                        sstable.markObsolete();
                        sstable.releaseReference();
                    }
                    catch (Exception e) {
                        System.err.println(String.format("Error scrubbing %s: %s", sstable, e.getMessage()));
                        e.printStackTrace(System.err);
                    }
                }
            }
            if (manifest != null) {
                StandaloneScrubber.checkManifest(manifest);
            }
            SSTableDeletingTask.waitForDeletions();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static void checkManifest(LeveledManifest manifest) {
        System.out.println(String.format("Checking leveled manifest", new Object[0]));
        for (int i = 1; i <= manifest.getLevelCount(); ++i) {
            manifest.repairOverlappingSSTables(i);
        }
    }

    static {
        CassandraDaemon.initLog4j();
    }

    private static class Options {
        public final String keyspaceName;
        public final String cfName;
        public boolean debug;
        public boolean verbose;
        public boolean manifestCheckOnly;
        public boolean skipCorrupted;
        public boolean noValidate;

        private Options(String keyspaceName, String cfName) {
            this.keyspaceName = keyspaceName;
            this.cfName = cfName;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneScrubber.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length != 2) {
                    String msg = args.length < 2 ? "Missing arguments" : "Too many arguments";
                    System.err.println(msg);
                    Options.printUsage(options);
                    System.exit(1);
                }
                String keyspaceName = args[0];
                String cfName = args[1];
                Options opts = new Options(keyspaceName, cfName);
                opts.debug = cmd.hasOption(StandaloneScrubber.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(StandaloneScrubber.VERBOSE_OPTION);
                opts.manifestCheckOnly = cmd.hasOption(StandaloneScrubber.MANIFEST_CHECK_OPTION);
                opts.skipCorrupted = cmd.hasOption(StandaloneScrubber.SKIP_CORRUPTED_OPTION);
                opts.noValidate = cmd.hasOption(StandaloneScrubber.NO_VALIDATE_OPTION);
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption(null, StandaloneScrubber.DEBUG_OPTION, "display stack traces");
            options.addOption("v", StandaloneScrubber.VERBOSE_OPTION, "verbose output");
            options.addOption("h", StandaloneScrubber.HELP_OPTION, "display this help message");
            options.addOption("m", StandaloneScrubber.MANIFEST_CHECK_OPTION, "only check and repair the leveled manifest, without actually scrubbing the sstables");
            options.addOption("s", StandaloneScrubber.SKIP_CORRUPTED_OPTION, "skip corrupt rows in counter tables");
            options.addOption("n", StandaloneScrubber.NO_VALIDATE_OPTION, "do not validate columns using column validator");
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <column_family>", StandaloneScrubber.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Scrub the sstable for the provided column family.");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }
    }
}

