/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.utils.StreamingHistogram;

public class ColumnStats {
    public final int columnCount;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int maxLocalDeletionTime;
    public final StreamingHistogram tombstoneHistogram;
    public final List<ByteBuffer> minColumnNames;
    public final List<ByteBuffer> maxColumnNames;

    public ColumnStats(int columnCount, long minTimestamp, long maxTimestamp, int maxLocalDeletionTime, StreamingHistogram tombstoneHistogram, List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames) {
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.columnCount = columnCount;
        this.tombstoneHistogram = tombstoneHistogram;
        this.minColumnNames = minColumnNames;
        this.maxColumnNames = maxColumnNames;
    }

    public static class MaxTracker<T extends Comparable<T>> {
        private final T defaultValue;
        private boolean isSet = false;
        private T value;

        public MaxTracker(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void update(T value) {
            if (!this.isSet) {
                this.value = value;
                this.isSet = true;
            } else if (value.compareTo(this.value) > 0) {
                this.value = value;
            }
        }

        public T get() {
            if (this.isSet) {
                return this.value;
            }
            return this.defaultValue;
        }
    }

    public static class MinTracker<T extends Comparable<T>> {
        private final T defaultValue;
        private boolean isSet = false;
        private T value;

        public MinTracker(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void update(T value) {
            if (!this.isSet) {
                this.value = value;
                this.isSet = true;
            } else if (value.compareTo(this.value) < 0) {
                this.value = value;
            }
        }

        public T get() {
            if (this.isSet) {
                return this.value;
            }
            return this.defaultValue;
        }
    }
}

