/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.dht.AbstractPartitioner;
import org.apache.cassandra.dht.LongToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MurmurHash;

public class Murmur3Partitioner
extends AbstractPartitioner<LongToken> {
    public static final LongToken MINIMUM = new LongToken(Long.MIN_VALUE);
    public static final long MAXIMUM = Long.MAX_VALUE;
    private final Token.TokenFactory<Long> tokenFactory = new Token.TokenFactory<Long>(){

        @Override
        public ByteBuffer toByteArray(Token<Long> longToken) {
            return ByteBufferUtil.bytes((Long)longToken.token);
        }

        @Override
        public Token<Long> fromByteArray(ByteBuffer bytes) {
            return new LongToken(ByteBufferUtil.toLong(bytes));
        }

        @Override
        public String toString(Token<Long> longToken) {
            return ((Long)longToken.token).toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                Long l = Long.valueOf(token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token<Long> fromString(String string) {
            try {
                return new LongToken(Long.valueOf(string));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid token for Murmur3Partitioner. Got %s but expected a long value (unsigned 8 bytes integer).", string));
            }
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new DecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token lToken, Token rToken) {
        BigInteger midpoint;
        BigInteger r;
        BigInteger l = BigInteger.valueOf((Long)((LongToken)lToken).token);
        if (l.compareTo(r = BigInteger.valueOf((Long)((LongToken)rToken).token)) < 0) {
            BigInteger sum = l.add(r);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger min;
            BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
            midpoint = max.subtract(min = BigInteger.valueOf((Long)Murmur3Partitioner.MINIMUM.token)).add(l).add(r).shiftRight(1);
            if (midpoint.compareTo(max) > 0) {
                midpoint = min.add(midpoint.subtract(max));
            }
        }
        return new LongToken(midpoint.longValue());
    }

    @Override
    public LongToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public LongToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        long[] hash = new long[2];
        MurmurHash.hash3_x64_128(key, key.position(), key.remaining(), 0L, hash);
        return new LongToken(this.normalize(hash[0]));
    }

    @Override
    public LongToken getRandomToken() {
        return new LongToken(this.normalize(FBUtilities.threadLocalRandom().nextLong()));
    }

    private long normalize(long v) {
        return v == Long.MIN_VALUE ? Long.MAX_VALUE : v;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. Has this node finished starting up?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            BigInteger ti;
            BigInteger ri = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf((Long)Murmur3Partitioner.MINIMUM.token + 1L));
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = BigInteger.valueOf((Long)((LongToken)start).token);
            while (i.hasNext()) {
                Token t = i.next();
                ti = BigInteger.valueOf((Long)((LongToken)t).token);
                float age = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r, 6, 6).floatValue();
                ownerships.put(t, Float.valueOf(age));
                tim1 = ti;
            }
            float x = new BigDecimal(BigInteger.valueOf((Long)((LongToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r, 6, 6).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }

    @Override
    public Token.TokenFactory<Long> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return LongType.instance;
    }
}

