/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.statements.SelectionColumns;

public class SelectionColumnMapping
implements SelectionColumns {
    private final LinkedHashMultimap<ColumnSpecification, CFDefinition.Name> columnMappings = LinkedHashMultimap.create();

    private SelectionColumnMapping() {
    }

    protected static SelectionColumnMapping newMapping() {
        return new SelectionColumnMapping();
    }

    protected static SelectionColumnMapping simpleMapping(List<CFDefinition.Name> columnDefinitions) {
        SelectionColumnMapping mapping = new SelectionColumnMapping();
        for (CFDefinition.Name def : columnDefinitions) {
            mapping.addMapping((ColumnSpecification)def, def);
        }
        return mapping;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, CFDefinition.Name column) {
        this.columnMappings.put((Object)colSpec, (Object)column);
        return this;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, Iterable<CFDefinition.Name> columns) {
        this.columnMappings.putAll((Object)colSpec, columns);
        return this;
    }

    @Override
    public List<ColumnSpecification> getColumnSpecifications() {
        return new ArrayList<ColumnSpecification>(this.columnMappings.keySet());
    }

    @Override
    public Multimap<ColumnSpecification, CFDefinition.Name> getMappings() {
        return Multimaps.unmodifiableMultimap(this.columnMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionColumns)) {
            return false;
        }
        return Objects.equals(this.columnMappings, ((SelectionColumns)obj).getMappings());
    }

    public int hashCode() {
        return Objects.hashCode(this.columnMappings);
    }

    public String toString() {
        Function<CFDefinition.Name, String> getDefName = new Function<CFDefinition.Name, String>(){

            public String apply(CFDefinition.Name name) {
                return name.toString();
            }
        };
        Function<Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>>, String> mappingEntryToString = new Function<Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>>, String>((Function)getDefName){
            final /* synthetic */ Function val$getDefName;
            {
                this.val$getDefName = function;
            }

            public String apply(Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>> entry) {
                StringBuilder builder = new StringBuilder();
                builder.append(entry.getKey().name.toString());
                builder.append(":[");
                builder.append(Joiner.on((char)',').join(Iterables.transform((Iterable)entry.getValue(), (Function)this.val$getDefName)));
                builder.append("]");
                return builder.toString();
            }
        };
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        builder.append(Joiner.on((String)", ").join(Iterables.transform(this.columnMappings.asMap().entrySet(), (Function)mappingEntryToString)));
        builder.append(" }");
        return builder.toString();
    }
}

