/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.MultiColumnRelation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.MultiColumnRestriction;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();
    private final Map<CFDefinition.Name, Boolean> restrictedNames = new HashMap<CFDefinition.Name, Boolean>();
    private Restriction.Slice sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;
    private boolean usesSecondaryIndexing;
    private Map<CFDefinition.Name, Integer> orderingIndexes;
    private boolean selectsStaticColumns;
    private boolean selectsOnlyStaticColumns;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false, null, false);
    private static final Predicate<CFDefinition.Name> isStaticFilter = new Predicate<CFDefinition.Name>(){

        public boolean apply(CFDefinition.Name name) {
            return name.kind == CFDefinition.Name.Kind.STATIC;
        }
    };

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, Term limit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.keyRestrictions = new Restriction[cfm.partitionKeyColumns().size()];
        this.columnRestrictions = new Restriction[cfm.clusteringKeyColumns().size()];
        this.parameters = parameters;
        this.limit = limit;
        this.initStaticColumnsInfo();
    }

    private void initStaticColumnsInfo() {
        if (!this.cfm.hasStaticColumns()) {
            return;
        }
        if (this.selection.isWildcard()) {
            this.selectsStaticColumns = true;
            return;
        }
        this.selectsStaticColumns = !Iterables.isEmpty((Iterable)Iterables.filter(this.selection.getColumns(), isStaticFilter));
        this.selectsOnlyStaticColumns = true;
        for (CFDefinition.Name name : this.selection.getColumns()) {
            if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS || name.kind == CFDefinition.Name.Kind.STATIC) continue;
            this.selectsOnlyStaticColumns = false;
            break;
        }
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, null);
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.parameters.isCount ? ResultSet.makeCountMetadata(this.keyspace(), this.columnFamily(), this.parameters.countAlias) : this.selection.getResultMetadata();
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.parameters) + meter.measureDeep((Object)this.selection) + (this.limit == null ? 0L : meter.measureDeep((Object)this.limit)) + meter.measureDeep((Object)this.keyRestrictions) + meter.measureDeep((Object)this.columnRestrictions) + meter.measureDeep(this.metadataRestrictions) + meter.measureDeep(this.restrictedNames) + (this.sliceRestriction == null ? 0L : meter.measureDeep((Object)this.sliceRestriction)) + (this.orderingIndexes == null ? 0L : meter.measureDeep(this.orderingIndexes));
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        CFDefinition cfDef = this.cfm.getCfDef();
        ConsistencyLevel cl = options.getConsistency();
        List<ByteBuffer> variables = options.getValues();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(variables);
        int limitForQuery = this.updateLimitForQuery(limit);
        long now = System.currentTimeMillis();
        Pageable command = this.isKeyRange || this.usesSecondaryIndexing ? this.getRangeCommand(cfDef, variables, limitForQuery, now) : ((commands = this.getSliceCommands(cfDef, variables, limitForQuery, now)) == null ? null : new Pageable.ReadCommands(commands, limitForQuery));
        int pageSize = options.getPageSize();
        if (this.parameters.isCount && pageSize <= 0 && MessagingService.instance().allNodesAtLeast20) {
            pageSize = 10000;
        }
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(cfDef, command, cl, variables, limit, now);
        }
        QueryPager pager = QueryPagers.pager(command, cl, options.getPagingState());
        if (this.parameters.isCount) {
            return this.pageCountQuery(cfDef, pager, variables, pageSize, now, limit);
        }
        if (this.needsPostQueryOrdering()) {
            throw new InvalidRequestException("Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        }
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(cfDef, page, variables, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private ResultMessage.Rows execute(CFDefinition cfDef, Pageable command, ConsistencyLevel cl, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, cl) : StorageProxy.getRangeSlice((RangeSliceCommand)command, cl));
        return this.processResults(cfDef, rows, variables, limit, now);
    }

    private ResultMessage.Rows pageCountQuery(CFDefinition cfDef, QueryPager pager, List<ByteBuffer> variables, int pageSize, long now, int limit) throws RequestValidationException, RequestExecutionException {
        int count = 0;
        while (!pager.isExhausted()) {
            int maxLimit = pager.maxRemaining();
            logger.debug("New maxLimit for paged count query is {}", (Object)maxLimit);
            ResultSet rset = this.process(cfDef, pager.fetchPage(pageSize), variables, maxLimit, now);
            count += rset.rows.size();
        }
        ResultSet result = ResultSet.makeCountResult(this.keyspace(), this.columnFamily(), Math.min(count, limit), this.parameters.countAlias);
        return new ResultMessage.Rows(result);
    }

    public ResultMessage.Rows processResults(CFDefinition cfDef, List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(cfDef, rows, variables, limit, now);
        rset = this.parameters.isCount ? rset.makeCountResult(this.parameters.countAlias) : rset;
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        RangeSliceCommand command;
        CFDefinition cfDef = this.cfm.getCfDef();
        List<ByteBuffer> variables = options.getValues();
        int limit = this.getLimit(variables);
        int limitForQuery = this.updateLimitForQuery(limit);
        long now = System.currentTimeMillis();
        List<Object> rows = this.isKeyRange || this.usesSecondaryIndexing ? ((command = this.getRangeCommand(cfDef, variables, limitForQuery, now)) == null ? Collections.emptyList() : command.executeLocally()) : ((commands = this.getSliceCommands(cfDef, variables, limitForQuery, now)) == null ? Collections.emptyList() : SelectStatement.readLocally(this.keyspace(), commands));
        return this.processResults(cfDef, rows, variables, limit, now);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(this.cfm.getCfDef(), rows, Collections.emptyList(), this.getLimit(Collections.emptyList()), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(CFDefinition cfDef, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.getKeys(cfDef, variables);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(cfDef, variables, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), key, this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(CFDefinition cfDef, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(cfDef, variables, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        AbstractBounds<RowPosition> keyBounds = this.getKeyBounds(cfDef, variables);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, !this.parameters.isDistinct, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(CFDefinition cfDef, List<ByteBuffer> variables) throws InvalidRequestException {
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            boolean includeStart = this.includeKeyBound(Bound.START);
            boolean includeEnd = this.includeKeyBound(Bound.END);
            int cmp = startToken.compareTo(endToken);
            if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
                return null;
            }
            Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
            return new Range<RowPosition>(start, end);
        }
        ByteBuffer startKeyBytes = this.getKeyBound(cfDef, Bound.START, variables);
        ByteBuffer finishKeyBytes = this.getKeyBound(cfDef, Bound.END, variables);
        RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            return null;
        }
        if (this.includeKeyBound(Bound.START)) {
            return this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private ColumnSlice makeStaticSlice() {
        ColumnNameBuilder staticPrefix = this.cfm.getStaticColumnNameBuilder();
        return this.isReversed ? new ColumnSlice(staticPrefix.buildAsEndOfRange(), ByteBufferUtil.EMPTY_BYTE_BUFFER) : new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, staticPrefix.buildAsEndOfRange());
    }

    private IDiskAtomFilter makeFilter(CFDefinition cfDef, List<ByteBuffer> variables, int limit) throws InvalidRequestException {
        int toGroup;
        int n = toGroup = cfDef.isCompact ? -1 : cfDef.clusteringColumnsCount();
        if (this.parameters.isDistinct) {
            toGroup = this.selectsStaticColumns ? toGroup : -2;
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, 1, toGroup);
        }
        if (this.isColumnRange(cfDef)) {
            ColumnSlice[] slices;
            ColumnSlice staticSlice;
            List<ByteBuffer> startBounds = this.getRequestedBound(cfDef, Bound.START, variables);
            List<ByteBuffer> endBounds = this.getRequestedBound(cfDef, Bound.END, variables);
            assert (startBounds.size() == endBounds.size());
            ColumnSlice columnSlice = staticSlice = this.selectsStaticColumns && !this.usesSecondaryIndexing ? this.makeStaticSlice() : null;
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) {
                    return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
                }
                if (staticSlice == null) {
                    return this.sliceFilter(slice, limit, toGroup);
                }
                if (this.isReversed) {
                    return slice.includes(this.cfm.comparator.reverseComparator, staticSlice.start) ? this.sliceFilter(new ColumnSlice(slice.start, staticSlice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{slice, staticSlice}, limit, toGroup);
                }
                return slice.includes(this.cfm.comparator, staticSlice.finish) ? this.sliceFilter(new ColumnSlice(staticSlice.start, slice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{staticSlice, slice}, limit, toGroup);
            }
            ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
            for (int i = 0; i < startBounds.size(); ++i) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) continue;
                l.add(slice);
            }
            if (l.isEmpty()) {
                return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
            }
            if (staticSlice == null) {
                return this.sliceFilter(l.toArray(new ColumnSlice[l.size()]), limit, toGroup);
            }
            if (this.isReversed) {
                if (((ColumnSlice)l.get(l.size() - 1)).includes(this.cfm.comparator.reverseComparator, staticSlice.start)) {
                    slices = l.toArray(new ColumnSlice[l.size()]);
                    slices[slices.length - 1] = new ColumnSlice(slices[slices.length - 1].start, ByteBufferUtil.EMPTY_BYTE_BUFFER);
                } else {
                    slices = l.toArray(new ColumnSlice[l.size() + 1]);
                    slices[slices.length - 1] = staticSlice;
                }
            } else if (((ColumnSlice)l.get(0)).includes(this.cfm.comparator, staticSlice.finish)) {
                slices = new ColumnSlice[l.size()];
                slices[0] = new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, ((ColumnSlice)l.get((int)0)).finish);
                for (int i = 1; i < l.size(); ++i) {
                    slices[i] = (ColumnSlice)l.get(i);
                }
            } else {
                slices = new ColumnSlice[l.size() + 1];
                slices[0] = staticSlice;
                for (int i = 0; i < l.size(); ++i) {
                    slices[i + 1] = (ColumnSlice)l.get(i);
                }
            }
            return this.sliceFilter(slices, limit, toGroup);
        }
        SortedSet<ByteBuffer> cellNames = this.getRequestedColumns(cfDef, variables);
        if (cellNames == null) {
            return null;
        }
        QueryProcessor.validateCellNames(cellNames);
        return new NamesQueryFilter(cellNames, true);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice slice, int limit, int toGroup) {
        return this.sliceFilter(new ColumnSlice[]{slice}, limit, toGroup);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice[] slices, int limit, int toGroup) {
        return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
    }

    public int getLimit(List<ByteBuffer> variables) throws InvalidRequestException {
        int l = Integer.MAX_VALUE;
        if (this.limit != null) {
            ByteBuffer b = this.limit.bindAndGet(variables);
            if (b == null) {
                throw new InvalidRequestException("Invalid null value of limit");
            }
            try {
                Int32Type.instance.validate(b);
                l = (Integer)Int32Type.instance.compose(b);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        if (l <= 0) {
            throw new InvalidRequestException("LIMIT must be strictly positive");
        }
        return l;
    }

    private int updateLimitForQuery(int limit) {
        return this.sliceRestriction != null && (!this.sliceRestriction.isInclusive(Bound.START) || !this.sliceRestriction.isInclusive(Bound.END)) && limit != Integer.MAX_VALUE ? limit + 1 : limit;
    }

    private Collection<ByteBuffer> getKeys(CFDefinition cfDef, List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        ColumnNameBuilder builder = cfDef.getKeyNameBuilder();
        for (CFDefinition.Name name : cfDef.partitionKeys()) {
            Restriction r = this.keyRestrictions[name.position];
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(variables);
            if (builder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
                    }
                    keys.add(builder.copy().add(val).build());
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
            }
            builder.add(val);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(CFDefinition cfDef, Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] != null) continue;
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return SelectStatement.buildBound(b, new ArrayList<CFDefinition.Name>(cfDef.partitionKeys()), this.keyRestrictions, false, cfDef, cfDef.getKeyNameBuilder(), variables).get(0);
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        ByteBuffer value;
        assert (this.onToken);
        Restriction restriction = this.keyRestrictions[0];
        assert (!restriction.isMultiColumn()) : "Unexpectedly got a multi-column restriction on a partition key for a range query";
        SingleColumnRestriction keyRestriction = (SingleColumnRestriction)restriction;
        if (keyRestriction.isEQ()) {
            value = keyRestriction.values(variables).get(0);
        } else {
            SingleColumnRestriction.Slice slice = (SingleColumnRestriction.Slice)keyRestriction;
            if (!slice.hasBound(b)) {
                return p.getMinimumToken();
            }
            value = slice.bound(b, variables);
        }
        if (value == null) {
            throw new InvalidRequestException("Invalid null token value");
        }
        return p.getTokenFactory().fromByteArray(value);
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (!r.isSlice()) continue;
            assert (!r.isMultiColumn()) : "Unexpectedly got multi-column restriction on partition key";
            return ((SingleColumnRestriction.Slice)r).isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange(CFDefinition cfDef) {
        if (!cfDef.isCompact) {
            return cfDef.isComposite;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && !r.isSlice()) continue;
            return true;
        }
        return false;
    }

    private SortedSet<ByteBuffer> getRequestedColumns(CFDefinition cfDef, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange(cfDef));
        ColumnNameBuilder builder = cfDef.getColumnNameBuilder();
        Iterator<CFDefinition.Name> idIter = cfDef.clusteringColumns().iterator();
        while (idIter.hasNext()) {
            List<Object> values;
            CFDefinition.Name name = idIter.next();
            Restriction r = this.columnRestrictions[name.position];
            assert (r != null && !r.isSlice());
            if (r.isEQ()) {
                values = r.values(variables);
                if (r.isMultiColumn()) {
                    int m = values.size();
                    for (int i = 0; i < m; ++i) {
                        ByteBuffer byteBuffer;
                        if (i != 0) {
                            name = idIter.next();
                        }
                        if ((byteBuffer = (ByteBuffer)values.get(i)) == null) {
                            throw new InvalidRequestException(String.format("Invalid null value in condition for column %s", name));
                        }
                        builder.add(byteBuffer);
                    }
                    continue;
                }
                ByteBuffer val2 = values.get(0);
                if (val2 == null) {
                    throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", name.name));
                }
                builder.add(val2);
                continue;
            }
            if (!r.isMultiColumn()) {
                values = r.values(variables);
                if (values.isEmpty()) {
                    return null;
                }
                TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(cfDef.cfm.comparator);
                Iterator<Object> iter = values.iterator();
                while (iter.hasNext()) {
                    ColumnNameBuilder b;
                    ByteBuffer byteBuffer = (ByteBuffer)iter.next();
                    ColumnNameBuilder columnNameBuilder = b = iter.hasNext() ? builder.copy() : builder;
                    if (byteBuffer == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", name.name));
                    }
                    b.add(byteBuffer);
                    if (cfDef.isCompact) {
                        columns.add(b.build());
                        continue;
                    }
                    columns.addAll(this.addSelectedColumns(cfDef, b));
                }
                return columns;
            }
            values = ((MultiColumnRestriction.IN)r).splitValues(variables);
            if (values.isEmpty()) {
                return null;
            }
            TreeSet<ByteBuffer> inValues = new TreeSet<ByteBuffer>(cfDef.cfm.comparator);
            for (List list : values) {
                ColumnNameBuilder b = builder.copy();
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) {
                        ArrayList<CFDefinition.Name> clusteringCols = new ArrayList<CFDefinition.Name>(cfDef.clusteringColumns());
                        throw new InvalidRequestException("Invalid null value in condition for clustering column " + clusteringCols.get(i + name.position));
                    }
                    b.add((ByteBuffer)list.get(i));
                }
                if (cfDef.isCompact) {
                    inValues.add(b.build());
                    continue;
                }
                inValues.addAll(this.addSelectedColumns(cfDef, b));
            }
            return inValues;
        }
        return this.addSelectedColumns(cfDef, builder);
    }

    private SortedSet<ByteBuffer> addSelectedColumns(CFDefinition cfDef, ColumnNameBuilder builder) {
        if (cfDef.isCompact) {
            return FBUtilities.singleton(builder.build(), this.cfm.comparator);
        }
        assert (!this.selectACollection(cfDef));
        TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfm.comparator);
        if (cfDef.isComposite && !this.cfm.isSuper()) {
            columns.add(builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build());
            for (ColumnIdentifier id : this.selection.regularAndStaticColumnsToFetch()) {
                columns.add(builder.copy().add(id.key).build());
            }
        } else {
            Iterator<CFDefinition.Name> iter = cfDef.regularColumns().iterator();
            while (iter.hasNext()) {
                ColumnIdentifier name = iter.next().name;
                ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                ByteBuffer cname = b.add(name.key).build();
                columns.add(cname);
            }
        }
        return columns;
    }

    private boolean selectACollection(CFDefinition cfDef) {
        if (!cfDef.hasCollections) {
            return false;
        }
        for (CFDefinition.Name name : this.selection.getColumns()) {
            if (!(name.type instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static List<ByteBuffer> buildBound(Bound bound, List<CFDefinition.Name> names, Restriction[] restrictions, boolean isReversed, CFDefinition cfDef, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        for (int i = 0; i < names.size(); ++i) {
            List<CFDefinition.Name> columns;
            List<ByteBuffer> values;
            CFDefinition.Name name;
            Restriction r = restrictions[name.position];
            name = names.get(i);
            Bound b = isReversed == SelectStatement.isReversedType(name) ? bound : Bound.reverse(bound);
            if (SelectStatement.isNullRestriction(r, b)) {
                return Collections.singletonList(builder.componentCount() > 0 && eocBound == Bound.END ? builder.buildAsEndOfRange() : builder.build());
            }
            if (r.isSlice()) {
                if (r.isMultiColumn()) {
                    values = ((MultiColumnRestriction.Slice)r).componentBounds(b, variables);
                    columns = SelectStatement.subList(names, i, values.size());
                    SelectStatement.addComponents(builder, columns, values);
                } else {
                    SelectStatement.addComponent(builder, name, SelectStatement.getSliceValue(r, b, variables));
                }
                Relation.Type relType = ((Restriction.Slice)r).getRelation(eocBound, b);
                return Collections.singletonList(builder.buildForRelation(relType));
            }
            if (r.isIN()) {
                TreeSet<ByteBuffer> inValues = new TreeSet<ByteBuffer>(isReversed ? cfDef.cfm.comparator.reverseComparator : cfDef.cfm.comparator);
                if (r.isMultiColumn()) {
                    List<List<ByteBuffer>> splitInValues = ((MultiColumnRestriction.IN)r).splitValues(variables);
                    for (List<ByteBuffer> components : splitInValues) {
                        ColumnNameBuilder copy = builder.copy();
                        List<CFDefinition.Name> columns2 = SelectStatement.subList(names, i, components.size());
                        SelectStatement.addComponents(copy, columns2, components);
                        inValues.add(SelectStatement.buildColumnName(copy, eocBound));
                    }
                    return new ArrayList<ByteBuffer>(inValues);
                }
                List<ByteBuffer> values2 = r.values(variables);
                if (values2.size() != 1) {
                    assert (name.position == names.size() - 1);
                    for (ByteBuffer val : values2) {
                        ColumnNameBuilder copy = builder.copy();
                        SelectStatement.addComponent(copy, name, val);
                        inValues.add(SelectStatement.buildColumnName(copy, eocBound));
                    }
                    return new ArrayList<ByteBuffer>(inValues);
                }
            }
            values = r.values(variables);
            if (r.isMultiColumn()) {
                columns = SelectStatement.subList(names, i, values.size());
                SelectStatement.addComponents(builder, columns, values);
                i += values.size() - 1;
                continue;
            }
            SelectStatement.addComponent(builder, name, values.get(0));
        }
        return Collections.singletonList(SelectStatement.buildColumnName(builder, eocBound));
    }

    private static <T> List<T> subList(List<T> list, int offset, int length) {
        return list.subList(offset, offset + length);
    }

    private static ByteBuffer buildColumnName(ColumnNameBuilder builder, Bound eocBound) {
        return eocBound == Bound.END && builder.remainingCount() > 0 ? builder.buildAsEndOfRange() : builder.build();
    }

    private static void addComponents(ColumnNameBuilder builder, List<CFDefinition.Name> names, List<ByteBuffer> values) throws InvalidRequestException {
        int m = values.size();
        for (int i = 0; i < m; ++i) {
            SelectStatement.addComponent(builder, names.get(i), values.get(i));
        }
    }

    private static void addComponent(ColumnNameBuilder builder, CFDefinition.Name name, ByteBuffer value) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(String.format("Invalid null value in condition for column %s", name));
        }
        builder.add(value);
    }

    private static boolean isNullRestriction(Restriction r, Bound b) {
        return r == null || r.isSlice() && !((Restriction.Slice)r).hasBound(b);
    }

    private static ByteBuffer getSliceValue(Restriction r, Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction.Slice slice = (Restriction.Slice)r;
        assert (slice.hasBound(b));
        return slice.bound(b, variables);
    }

    private List<ByteBuffer> getRequestedBound(CFDefinition cfDef, Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange(cfDef));
        return SelectStatement.buildBound(b, new ArrayList<CFDefinition.Name>(cfDef.clusteringColumns()), this.columnRestrictions, this.isReversed, cfDef, cfDef.getColumnNameBuilder(), variables);
    }

    public List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.restrictedNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (CFDefinition.Name name : this.restrictedNames.keySet()) {
            ByteBuffer value;
            List<ByteBuffer> values;
            Restriction restriction;
            switch (name.kind) {
                case KEY_ALIAS: {
                    restriction = this.keyRestrictions[name.position];
                    break;
                }
                case COLUMN_ALIAS: {
                    restriction = this.columnRestrictions[name.position];
                    break;
                }
                case COLUMN_METADATA: 
                case STATIC: {
                    restriction = this.metadataRestrictions.get(name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (restriction.isSlice()) {
                Restriction.Slice slice = (Restriction.Slice)restriction;
                for (Bound b : Bound.values()) {
                    if (!slice.hasBound(b)) continue;
                    ByteBuffer value2 = slice.bound(b, variables);
                    this.validateIndexExpressionValue(value2, name);
                    IndexOperator op = slice.getIndexOperator(b);
                    if (name.type instanceof ReversedType) {
                        op = SelectStatement.reverse(op);
                    }
                    expressions.add(new IndexExpression(name.name.key, op, value2));
                }
                continue;
            }
            if (restriction.isMultiColumn()) {
                values = restriction.values(variables);
                value = values.get(name.position);
            } else {
                values = restriction.values(variables);
                if (values.size() != 1) {
                    throw new InvalidRequestException("IN restrictions are not supported on indexed columns");
                }
                value = values.get(0);
            }
            this.validateIndexExpressionValue(value, name);
            expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
        }
        return expressions;
    }

    private void validateIndexExpressionValue(ByteBuffer value, CFDefinition.Name name) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", name));
        }
        if (value.remaining() > 65535) {
            throw new InvalidRequestException("Index expression values may not be larger than 64K");
        }
    }

    private static IndexOperator reverse(IndexOperator op) {
        switch (op) {
            case LT: {
                return IndexOperator.GT;
            }
            case LTE: {
                return IndexOperator.GTE;
            }
            case GT: {
                return IndexOperator.LT;
            }
            case GTE: {
                return IndexOperator.LTE;
            }
        }
        return op;
    }

    private ResultSet process(CFDefinition cfDef, List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(cfDef, row.key.key, row.cf, variables, now, result);
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cfDef, cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(CFDefinition cfDef, ByteBuffer key, ColumnFamily cf, List<ByteBuffer> variables, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        block28: {
            ByteBuffer[] keyComponents;
            block27: {
                ByteBuffer[] byteBufferArray;
                if (cfDef.hasCompositeKey) {
                    byteBufferArray = ((CompositeType)this.cfm.getKeyValidator()).split(key);
                } else {
                    ByteBuffer[] byteBufferArray2 = new ByteBuffer[1];
                    byteBufferArray = byteBufferArray2;
                    byteBufferArray2[0] = key;
                }
                keyComponents = byteBufferArray;
                if (!this.parameters.isDistinct || this.selectsStaticColumns) break block27;
                if (cf.hasOnlyTombstones(now)) break block28;
                result.newRow();
                for (CFDefinition.Name name : this.selection.getColumns()) {
                    result.add(keyComponents[name.position]);
                }
                break block28;
            }
            if (cfDef.isCompact) {
                for (Column c : cf) {
                    if (c.isMarkedForDelete(now)) continue;
                    ByteBuffer[] components = null;
                    if (cfDef.isComposite) {
                        components = ((CompositeType)this.cfm.comparator).split(c.name());
                    } else if (this.sliceRestriction != null) {
                        ByteBuffer bounds;
                        AbstractType<?> comp = this.cfm.comparator;
                        if (!this.sliceRestriction.isInclusive(Bound.START)) {
                            ByteBuffer byteBuffer = bounds = this.sliceRestriction.isMultiColumn() ? ((MultiColumnRestriction.Slice)this.sliceRestriction).componentBounds(Bound.START, variables).get(0) : this.sliceRestriction.bound(Bound.START, variables);
                            if (comp.compare(c.name(), bounds) == 0) continue;
                        }
                        if (!this.sliceRestriction.isInclusive(Bound.END)) {
                            ByteBuffer byteBuffer = bounds = this.sliceRestriction.isMultiColumn() ? ((MultiColumnRestriction.Slice)this.sliceRestriction).componentBounds(Bound.END, variables).get(0) : this.sliceRestriction.bound(Bound.END, variables);
                            if (comp.compare(c.name(), bounds) == 0) continue;
                        }
                    }
                    result.newRow();
                    block8: for (CFDefinition.Name name : this.selection.getColumns()) {
                        switch (name.kind) {
                            case KEY_ALIAS: {
                                result.add(keyComponents[name.position]);
                                continue block8;
                            }
                            case COLUMN_ALIAS: {
                                ByteBuffer val = cfDef.isComposite ? (name.position < components.length ? components[name.position] : null) : c.name();
                                result.add(val);
                                continue block8;
                            }
                            case VALUE_ALIAS: {
                                result.add(c);
                                continue block8;
                            }
                            case COLUMN_METADATA: 
                            case STATIC: {
                                throw new AssertionError();
                            }
                        }
                        throw new AssertionError();
                    }
                }
            } else if (cfDef.isComposite) {
                CompositeType composite = (CompositeType)this.cfm.comparator;
                ColumnGroupMap.Builder builder = new ColumnGroupMap.Builder(composite, cfDef.hasCollections, now);
                for (Column c : cf) {
                    if (c.isMarkedForDelete(now)) continue;
                    builder.add(c);
                }
                ColumnGroupMap staticGroup = null;
                if (!builder.isEmpty() && builder.firstGroup().isStatic) {
                    staticGroup = builder.firstGroup();
                    builder.discardFirst();
                    if (builder.isEmpty() && !this.usesSecondaryIndexing && this.hasNoClusteringColumnsRestriction() && this.hasValueForQuery(staticGroup)) {
                        this.handleGroup(result, keyComponents, ColumnGroupMap.EMPTY, staticGroup);
                        return;
                    }
                }
                for (ColumnGroupMap group : builder.groups()) {
                    this.handleGroup(result, keyComponents, group, staticGroup);
                }
            } else {
                if (cf.hasOnlyTombstones(now)) {
                    return;
                }
                result.newRow();
                for (CFDefinition.Name name : this.selection.getColumns()) {
                    if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                        result.add(keyComponents[name.position]);
                        continue;
                    }
                    result.add(cf.getColumn(name.name.key));
                }
            }
        }
    }

    private boolean hasValueForQuery(ColumnGroupMap staticGroup) {
        for (CFDefinition.Name name : Iterables.filter(this.selection.getColumns(), isStaticFilter)) {
            if (!staticGroup.hasValueFor(name.name.key)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean needsPostQueryOrdering() {
        return this.keyIsInRelation && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(CFDefinition cfDef, ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        assert (this.orderingIndexes != null);
        if (this.parameters.orderings.size() == 1) {
            CFDefinition.Name ordering = cfDef.get(((ColumnIdentifier.Raw)this.parameters.orderings.keySet().iterator().next()).prepare(this.cfm));
            Collections.sort(cqlRows.rows, new SingleColumnComparator(this.orderingIndexes.get(ordering), ordering.type));
            return;
        }
        ArrayList<AbstractType> types = new ArrayList<AbstractType>(this.parameters.orderings.size());
        int[] positions = new int[this.parameters.orderings.size()];
        int idx = 0;
        for (ColumnIdentifier.Raw identifier : this.parameters.orderings.keySet()) {
            CFDefinition.Name orderingColumn = cfDef.get(identifier.prepare(cfDef.cfm));
            types.add(orderingColumn.type);
            positions[idx++] = this.orderingIndexes.get(orderingColumn);
        }
        Collections.sort(cqlRows.rows, new CompositeComparator(types, positions));
    }

    private void handleGroup(Selection.ResultSetBuilder result, ByteBuffer[] keyComponents, ColumnGroupMap columns, ColumnGroupMap staticGroup) throws InvalidRequestException {
        result.newRow();
        for (CFDefinition.Name name : this.selection.getColumns()) {
            switch (name.kind) {
                case KEY_ALIAS: {
                    result.add(keyComponents[name.position]);
                    break;
                }
                case COLUMN_ALIAS: {
                    result.add(columns.getKeyComponent(name.position));
                    break;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    SelectStatement.addValue(result, name, columns);
                    break;
                }
                case STATIC: {
                    SelectStatement.addValue(result, name, staticGroup);
                }
            }
        }
    }

    private static void addValue(Selection.ResultSetBuilder result, CFDefinition.Name name, ColumnGroupMap group) {
        if (group == null) {
            result.add((ByteBuffer)null);
            return;
        }
        if (name.type.isCollection()) {
            List<Pair<ByteBuffer, Column>> collection = group.getCollection(name.name.key);
            result.add(collection == null ? null : ((CollectionType)name.type).serialize(name, collection));
        } else {
            result.add(group.getSimple(name.name.key));
        }
    }

    private static boolean isReversedType(CFDefinition.Name name) {
        return name.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    public boolean hasPartitionKeyRestriction() {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return true;
        }
        return false;
    }

    private void validateDistinctSelection(CFDefinition cfDef) throws InvalidRequestException {
        List<CFDefinition.Name> requestedColumns = this.selection.getColumns();
        for (CFDefinition.Name name : requestedColumns) {
            if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS || name.kind == CFDefinition.Name.Kind.STATIC) continue;
            throw new InvalidRequestException(String.format("SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", name));
        }
        if (!this.isKeyRange) {
            return;
        }
        for (CFDefinition.Name name : cfDef.partitionKeys()) {
            if (requestedColumns.contains(name)) continue;
            throw new InvalidRequestException(String.format("SELECT DISTINCT queries must request all the partition key columns (missing %s)", name));
        }
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<AbstractType<?>> orderTypes;
        private final int[] positions;

        private CompositeComparator(List<AbstractType<?>> orderTypes, int[] positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.length; ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                AbstractType<?> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions[i]), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final AbstractType<?> comparator;

        public SingleColumnComparator(int columnIndex, AbstractType<?> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final Map<ColumnIdentifier.Raw, Boolean> orderings;
        private final boolean isDistinct;
        private final boolean isCount;
        private final ColumnIdentifier countAlias;
        private final boolean allowFiltering;

        public Parameters(Map<ColumnIdentifier.Raw, Boolean> orderings, boolean isDistinct, boolean isCount, ColumnIdentifier countAlias, boolean allowFiltering) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.isCount = isCount;
            this.countAlias = countAlias;
            this.allowFiltering = allowFiltering;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            CFDefinition cfDef = cfm.getCfDef();
            VariableSpecifications boundNames = this.getBoundVariables();
            if (this.parameters.isCount && !this.selectClause.isEmpty()) {
                throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
            }
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfDef) : Selection.fromSelectors(cfDef, this.selectClause);
            SelectStatement stmt = new SelectStatement(cfm, boundNames.size(), this.parameters, selection, this.prepareLimit(boundNames));
            boolean hasQueriableIndex = false;
            boolean hasQueriableClusteringColumnIndex = false;
            for (Relation relation : this.whereClause) {
                Relation rel;
                if (relation.isMultiColumn()) {
                    rel = (MultiColumnRelation)relation;
                    ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>(((MultiColumnRelation)rel).getEntities().size());
                    for (ColumnIdentifier.Raw rawEntity : ((MultiColumnRelation)rel).getEntities()) {
                        ColumnIdentifier entity = rawEntity.prepare(cfm);
                        boolean[] queriable = this.processRelationEntity(stmt, relation, entity, cfDef);
                        hasQueriableIndex |= queriable[0];
                        hasQueriableClusteringColumnIndex |= queriable[1];
                        CFDefinition.Name name = cfDef.get(entity);
                        names.add(name);
                    }
                    this.updateRestrictionsForRelation(stmt, names, (MultiColumnRelation)rel, boundNames);
                    continue;
                }
                rel = (SingleColumnRelation)relation;
                ColumnIdentifier entity = ((SingleColumnRelation)rel).getEntity().prepare(cfm);
                boolean[] queriable = this.processRelationEntity(stmt, relation, entity, cfDef);
                hasQueriableIndex |= queriable[0];
                hasQueriableClusteringColumnIndex |= queriable[1];
                CFDefinition.Name name = cfDef.get(entity);
                this.updateRestrictionsForRelation(stmt, name, (SingleColumnRelation)rel, boundNames);
            }
            this.processPartitionKeyRestrictions(stmt, cfDef, hasQueriableIndex);
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedNames.keySet().removeAll(cfDef.partitionKeys());
            }
            if (stmt.selectsOnlyStaticColumns && stmt.hasClusteringColumnsRestriction()) {
                throw new InvalidRequestException("Cannot restrict clustering columns when selecting only static columns");
            }
            this.processColumnRestrictions(stmt, cfDef, hasQueriableIndex);
            if (stmt.isKeyRange && hasQueriableClusteringColumnIndex) {
                stmt.usesSecondaryIndexing = true;
            }
            for (CFDefinition.Name clusteringColumn : cfDef.clusteringColumns()) {
                Boolean indexed = (Boolean)stmt.restrictedNames.get(clusteringColumn);
                if (indexed == null) break;
                if (indexed.booleanValue()) continue;
                stmt.restrictedNames.remove(clusteringColumn);
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                if (!hasQueriableIndex) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                stmt.usesSecondaryIndexing = true;
            }
            if (stmt.usesSecondaryIndexing) {
                this.validateSecondaryIndexSelections(stmt);
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                this.processOrderingClause(stmt, cfDef);
            }
            this.checkNeedsFiltering(stmt, cfDef);
            if (this.parameters.isDistinct) {
                stmt.validateDistinctSelection(cfDef);
            }
            return new ParsedStatement.Prepared((CQLStatement)stmt, boundNames);
        }

        private boolean[] processRelationEntity(SelectStatement stmt, Relation relation, ColumnIdentifier entity, CFDefinition cfDef) throws InvalidRequestException {
            CFDefinition.Name name = cfDef.get(entity);
            if (name == null) {
                this.handleUnrecognizedEntity(entity, relation);
            }
            if (cfDef.cfm.getColumnDefinition(name.name.key).isIndexed() && relation.operator() == Relation.Type.EQ) {
                stmt.restrictedNames.put(name, Boolean.TRUE);
                return new boolean[]{true, name.kind == CFDefinition.Name.Kind.COLUMN_ALIAS};
            }
            stmt.restrictedNames.put(name, Boolean.FALSE);
            return new boolean[]{false, false};
        }

        private void handleUnrecognizedEntity(ColumnIdentifier entity, Relation relation) throws InvalidRequestException {
            if (this.containsAlias(entity)) {
                throw new InvalidRequestException(String.format("Aliases aren't allowed in the where clause ('%s')", relation));
            }
            throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", entity, relation));
        }

        private Term prepareLimit(VariableSpecifications boundNames) throws InvalidRequestException {
            if (this.limit == null) {
                return null;
            }
            Term prepLimit = this.limit.prepare(this.limitReceiver());
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private void updateRestrictionsForRelation(SelectStatement stmt, List<CFDefinition.Name> names, MultiColumnRelation relation, VariableSpecifications boundNames) throws InvalidRequestException {
            ArrayList<CFDefinition.Name> restrictedColumns = new ArrayList<CFDefinition.Name>();
            HashSet<CFDefinition.Name> seen = new HashSet<CFDefinition.Name>();
            Restriction existing = null;
            int previousPosition = names.get((int)0).position - 1;
            int m = names.size();
            for (int i = 0; i < m; ++i) {
                CFDefinition.Name name = names.get(i);
                if (name.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                    throw new InvalidRequestException(String.format("Multi-column relations can only be applied to clustering columns: %s", name));
                }
                if (seen.contains(name)) {
                    throw new InvalidRequestException(String.format("Column \"%s\" appeared twice in a relation: %s", name, relation));
                }
                seen.add(name);
                if (name.position != previousPosition + 1) {
                    if (previousPosition == -1) {
                        throw new InvalidRequestException(String.format("Clustering columns may not be skipped in multi-column relations. They should appear in the PRIMARY KEY order. Got %s", relation));
                    }
                    throw new InvalidRequestException(String.format("Clustering columns must appear in the PRIMARY KEY order in multi-column relations: %s", relation));
                }
                ++previousPosition;
                Restriction previous = existing;
                existing = this.getExistingRestriction(stmt, name);
                Relation.Type operator = relation.operator();
                if (existing != null) {
                    boolean existingRestrictionStartAfter;
                    if (operator == Relation.Type.EQ || operator == Relation.Type.IN) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by more than one relation if it is in an %s relation", new Object[]{name, relation.operator()}));
                    }
                    if (!existing.isSlice()) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by an equality relation and an inequality relation", name));
                    }
                    if (!existing.isMultiColumn()) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot have both tuple-notation inequalities and single-column inequalities: %s", name, relation));
                    }
                    boolean bl = i == 0 && name.position != 0 && stmt.columnRestrictions[name.position - 1] == existing;
                    boolean bl2 = existingRestrictionStartAfter = i != 0 && previous != existing;
                    if (bl || existingRestrictionStartAfter) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by two tuple-notation inequalities not starting with the same column: %s", name, relation));
                    }
                    RawStatement.checkBound(existing, name, operator);
                }
                restrictedColumns.add(name);
            }
            boolean onToken = false;
            switch (relation.operator()) {
                case EQ: {
                    Term t = relation.getValue().prepare(names);
                    t.collectMarkerSpecification(boundNames);
                    Restriction restriction = new MultiColumnRestriction.EQ(t, onToken);
                    for (CFDefinition.Name name : restrictedColumns) {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = restriction;
                    }
                    break;
                }
                case IN: {
                    SingleColumnRestriction restriction;
                    List<? extends Term.MultiColumnRaw> inValues = relation.getInValues();
                    if (inValues != null) {
                        ArrayList<Term> terms = new ArrayList<Term>(inValues.size());
                        for (Term.MultiColumnRaw multiColumnRaw : inValues) {
                            Term t = multiColumnRaw.prepare(names);
                            t.collectMarkerSpecification(boundNames);
                            terms.add(t);
                        }
                        restriction = new MultiColumnRestriction.InWithValues(terms);
                    } else {
                        Tuples.INRaw rawMarker = relation.getInMarker();
                        AbstractMarker t = rawMarker.prepare(names);
                        t.collectMarkerSpecification(boundNames);
                        restriction = new MultiColumnRestriction.InWithMarker(t);
                    }
                    for (CFDefinition.Name name : restrictedColumns) {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = restriction;
                    }
                    break;
                }
                case LT: 
                case LTE: 
                case GT: 
                case GTE: {
                    Term t = relation.getValue().prepare(names);
                    t.collectMarkerSpecification(boundNames);
                    Restriction restriction = (Restriction.Slice)this.getExistingRestriction(stmt, names.get(0));
                    if (restriction == null) {
                        restriction = new MultiColumnRestriction.Slice(false);
                    }
                    restriction.setBound(relation.operator(), t);
                    for (CFDefinition.Name name : names) {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = restriction;
                    }
                    break;
                }
            }
        }

        private static void checkBound(Restriction existing, CFDefinition.Name name, Relation.Type relType) throws InvalidRequestException {
            Restriction.Slice existingSlice = (Restriction.Slice)existing;
            if (existingSlice.hasBound(Bound.START) && (relType == Relation.Type.GT || relType == Relation.Type.GTE)) {
                throw new InvalidRequestException(String.format("More than one restriction was found for the start bound on %s", name.name));
            }
            if (existingSlice.hasBound(Bound.END) && (relType == Relation.Type.LT || relType == Relation.Type.LTE)) {
                throw new InvalidRequestException(String.format("More than one restriction was found for the end bound on %s", name.name));
            }
        }

        private Restriction getExistingRestriction(SelectStatement stmt, CFDefinition.Name name) {
            switch (name.kind) {
                case KEY_ALIAS: {
                    return stmt.keyRestrictions[name.position];
                }
                case COLUMN_ALIAS: {
                    return stmt.columnRestrictions[name.position];
                }
                case VALUE_ALIAS: {
                    return null;
                }
            }
            return (Restriction)stmt.metadataRestrictions.get(name);
        }

        private void updateRestrictionsForRelation(SelectStatement stmt, CFDefinition.Name name, SingleColumnRelation relation, VariableSpecifications names) throws InvalidRequestException {
            switch (name.kind) {
                case KEY_ALIAS: {
                    ((SelectStatement)stmt).keyRestrictions[name.position] = this.updateSingleColumnRestriction(name, stmt.keyRestrictions[name.position], relation, names);
                    break;
                }
                case COLUMN_ALIAS: {
                    ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateSingleColumnRestriction(name, stmt.columnRestrictions[name.position], relation, names);
                    break;
                }
                case VALUE_ALIAS: {
                    throw new InvalidRequestException(String.format("Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", name.name));
                }
                case COLUMN_METADATA: 
                case STATIC: {
                    Restriction r = this.updateSingleColumnRestriction(name, (Restriction)stmt.metadataRestrictions.get(name), relation, names);
                    if (r.isIN() && !((Restriction.IN)r).canHaveOnlyOneValue()) {
                        throw new InvalidRequestException(String.format("IN predicates on non-primary-key columns (%s) is not yet supported", name));
                    }
                    stmt.metadataRestrictions.put(name, r);
                }
            }
        }

        Restriction updateSingleColumnRestriction(CFDefinition.Name name, Restriction existingRestriction, SingleColumnRelation newRel, VariableSpecifications boundNames) throws InvalidRequestException {
            ColumnSpecification receiver = name;
            if (newRel.onToken) {
                if (name.kind != CFDefinition.Name.Kind.KEY_ALIAS) {
                    throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", name));
                }
                receiver = new ColumnSpecification(name.ksName, name.cfName, new ColumnIdentifier("partition key token", true), StorageService.getPartitioner().getTokenValidator());
            }
            if (receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Collection column '%s' (%s) cannot be restricted by a '%s' relation", new Object[]{name, receiver.type.asCQL3Type(), newRel.operator()}));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (existingRestriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    existingRestriction = new SingleColumnRestriction.EQ(t, newRel.onToken);
                    break;
                }
                case IN: {
                    if (existingRestriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes a IN", name));
                    }
                    if (newRel.getInValues() == null) {
                        assert (newRel.getValue() != null);
                        Term t = newRel.getValue().prepare(receiver);
                        t.collectMarkerSpecification(boundNames);
                        existingRestriction = new SingleColumnRestriction.InWithMarker((Lists.Marker)t);
                        break;
                    }
                    ArrayList<Term> inValues = new ArrayList<Term>(newRel.getInValues().size());
                    for (Term.Raw raw : newRel.getInValues()) {
                        Term t = raw.prepare(receiver);
                        t.collectMarkerSpecification(boundNames);
                        inValues.add(t);
                    }
                    existingRestriction = new SingleColumnRestriction.InWithValues(inValues);
                    break;
                }
                case LT: 
                case LTE: 
                case GT: 
                case GTE: {
                    if (existingRestriction == null) {
                        existingRestriction = new SingleColumnRestriction.Slice(newRel.onToken);
                    } else {
                        if (!existingRestriction.isSlice()) {
                            throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by both an equality and an inequality relation", name));
                        }
                        if (existingRestriction.isOnToken() != newRel.onToken) {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                        if (existingRestriction.isMultiColumn()) {
                            throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by both a tuple notation inequality and a single column inequality (%s)", name, newRel));
                        }
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    ((SingleColumnRestriction.Slice)existingRestriction).setBound(newRel.operator(), t);
                }
            }
            return existingRestriction;
        }

        private void processPartitionKeyRestrictions(SelectStatement stmt, CFDefinition cfDef, boolean hasQueriableIndex) throws InvalidRequestException {
            boolean canRestrictFurtherComponents = true;
            CFDefinition.Name previous = null;
            stmt.keyIsInRelation = false;
            Iterator<CFDefinition.Name> iter = cfDef.partitionKeys().iterator();
            for (int i = 0; i < stmt.keyRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException("The token() function must be applied to all partition key components or none of them");
                    }
                    if (i > 0 && stmt.keyRestrictions[i - 1] != null) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            stmt.isKeyRange = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partition key part %s must be restricted since preceding part is", cname));
                    }
                    stmt.isKeyRange = true;
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partitioning column \"%s\" cannot be restricted because the preceding column (\"%s\") is either not restricted or is restricted by a non-EQ relation", cname, previous));
                    }
                    if (restriction.isOnToken()) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (!restriction.isSlice()) {
                            if (restriction.isIN()) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cname));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                }
                previous = cname;
            }
            if (stmt.onToken) {
                this.checkTokenFunctionArgumentsOrder(cfDef);
            }
        }

        private void checkTokenFunctionArgumentsOrder(CFDefinition cfDef) throws InvalidRequestException {
            Iterator iter = Iterators.cycle(cfDef.partitionKeys());
            for (Relation relation : this.whereClause) {
                if (!relation.isOnToken()) continue;
                assert (!relation.isMultiColumn()) : "Unexpectedly got multi-column token relation";
                SingleColumnRelation singleColumnRelation = (SingleColumnRelation)relation;
                if (cfDef.get(singleColumnRelation.getEntity().prepare(cfDef.cfm)).equals(iter.next())) continue;
                throw new InvalidRequestException(String.format("The token function arguments must be in the partition key order: %s", Joiner.on((char)',').join(cfDef.partitionKeys())));
            }
        }

        private void processColumnRestrictions(SelectStatement stmt, CFDefinition cfDef, boolean hasQueriableIndex) throws InvalidRequestException {
            boolean canRestrictFurtherComponents = true;
            CFDefinition.Name previous = null;
            Restriction previousRestriction = null;
            Iterator<CFDefinition.Name> iter = cfDef.clusteringColumns().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    canRestrictFurtherComponents = false;
                } else if (!canRestrictFurtherComponents) {
                    if (restriction != previousRestriction) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        if (previousRestriction == null) {
                            throw new InvalidRequestException(String.format("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is not restricted)", cname, previous));
                        }
                        if (previousRestriction.isMultiColumn() && previousRestriction.isIN()) {
                            throw new InvalidRequestException(String.format("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by an IN tuple notation)", cname, previous));
                        }
                        throw new InvalidRequestException(String.format("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", cname, previous));
                    }
                } else if (restriction.isSlice()) {
                    canRestrictFurtherComponents = false;
                    Restriction.Slice slice = (Restriction.Slice)restriction;
                    if (!(cfDef.isComposite || slice.isInclusive(Bound.START) && slice.isInclusive(Bound.END))) {
                        stmt.sliceRestriction = slice;
                    }
                } else if (restriction.isIN()) {
                    if (!restriction.isMultiColumn() && i != stmt.columnRestrictions.length - 1) {
                        throw new InvalidRequestException(String.format("Clustering column \"%s\" cannot be restricted by an IN relation", cname));
                    }
                    if (stmt.selectACollection(cfDef)) {
                        throw new InvalidRequestException(String.format("Cannot restrict column \"%s\" by IN relation as a collection is selected by the query", cname));
                    }
                    if (restriction.isMultiColumn()) {
                        canRestrictFurtherComponents = false;
                    }
                }
                previous = cname;
                previousRestriction = restriction;
            }
        }

        private void validateSecondaryIndexSelections(SelectStatement stmt) throws InvalidRequestException {
            if (stmt.keyIsInRelation) {
                throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
            }
            if (stmt.selectsOnlyStaticColumns) {
                throw new InvalidRequestException("Queries using 2ndary indexes don't support selecting only static columns");
            }
        }

        private void verifyOrderingIsAllowed(SelectStatement stmt) throws InvalidRequestException {
            if (stmt.usesSecondaryIndexing) {
                throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
            }
            if (stmt.isKeyRange) {
                throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
            }
        }

        private void handleUnrecognizedOrderingColumn(ColumnIdentifier column) throws InvalidRequestException {
            if (this.containsAlias(column)) {
                throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
            }
            throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
        }

        private void processOrderingClause(SelectStatement stmt, CFDefinition cfDef) throws InvalidRequestException {
            this.verifyOrderingIsAllowed(stmt);
            if (stmt.keyIsInRelation) {
                stmt.orderingIndexes = new HashMap();
                for (ColumnIdentifier.Raw rawColumn : stmt.parameters.orderings.keySet()) {
                    ColumnIdentifier column = rawColumn.prepare(cfDef.cfm);
                    final CFDefinition.Name name = cfDef.get(column);
                    if (name == null) {
                        this.handleUnrecognizedOrderingColumn(column);
                    }
                    if (this.selectClause.isEmpty()) {
                        stmt.orderingIndexes.put(name, Iterables.indexOf((Iterable)cfDef, (Predicate)new Predicate<CFDefinition.Name>(){

                            public boolean apply(CFDefinition.Name n) {
                                return name.equals(n);
                            }
                        }));
                        continue;
                    }
                    boolean hasColumn = false;
                    List<CFDefinition.Name> selectedColumns = stmt.selection.getColumns();
                    for (int i = 0; i < selectedColumns.size(); ++i) {
                        CFDefinition.Name selected = selectedColumns.get(i);
                        if (!name.equals(selected)) continue;
                        stmt.orderingIndexes.put(name, i);
                        hasColumn = true;
                        break;
                    }
                    if (hasColumn) continue;
                    throw new InvalidRequestException(String.format("ORDER BY can only be performed on columns in the select clause (got %s)", name.name));
                }
            }
            stmt.isReversed = this.isReversed(stmt, cfDef);
        }

        private boolean isReversed(SelectStatement stmt, CFDefinition cfDef) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[cfDef.clusteringColumnsCount()];
            int i = 0;
            for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                ColumnIdentifier column = ((ColumnIdentifier.Raw)entry.getKey()).prepare(cfDef.cfm);
                boolean reversed = (Boolean)entry.getValue();
                CFDefinition.Name name = cfDef.get(column);
                if (name == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                if (name.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                    throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                }
                if (i++ != name.position) {
                    throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                }
                reversedMap[name.position] = reversed != SelectStatement.isReversedType(name);
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                if (isReversed.equals(b)) continue;
                throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(SelectStatement stmt, CFDefinition cfDef) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (stmt.isKeyRange || stmt.usesSecondaryIndexing) && (stmt.restrictedNames.size() > 1 || stmt.restrictedNames.isEmpty() && !stmt.columnFilterIsIdentity())) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            if (stmt.sliceRestriction != null && stmt.isKeyRange && this.limit != null) {
                SingleColumnRelation rel = this.findInclusiveClusteringRelationForCompact(cfDef);
                throw new InvalidRequestException(String.format("The query requests a restriction of rows with a strict bound (%s) over a range of partitions. This is not supported by the underlying storage engine for COMPACT tables if a LIMIT is provided. Please either make the condition non strict (%s) or remove the user LIMIT", rel, rel.withNonStrictOperator()));
            }
        }

        private SingleColumnRelation findInclusiveClusteringRelationForCompact(CFDefinition cfDef) {
            for (Relation r : this.whereClause) {
                SingleColumnRelation rel = (SingleColumnRelation)r;
                if (cfDef.get((ColumnIdentifier)rel.getEntity().prepare((CFMetaData)cfDef.cfm)).kind != CFDefinition.Name.Kind.COLUMN_ALIAS || rel.operator() != Relation.Type.GT && rel.operator() != Relation.Type.LT) continue;
                return rel;
            }
            throw new AssertionError();
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).add("isCount", this.parameters.isCount).toString();
        }
    }
}

