/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnSlice {
    public static final Serializer serializer = new Serializer();
    public static final ColumnSlice ALL_COLUMNS = new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    public static final ColumnSlice[] ALL_COLUMNS_ARRAY = new ColumnSlice[]{ALL_COLUMNS};
    public final ByteBuffer start;
    public final ByteBuffer finish;

    public ColumnSlice(ByteBuffer start, ByteBuffer finish) {
        assert (start != null && finish != null);
        this.start = start;
        this.finish = finish;
    }

    public boolean isAlwaysEmpty(AbstractType<?> comparator, boolean reversed) {
        Comparator<ByteBuffer> orderedComparator = reversed ? comparator.reverseComparator : comparator;
        return this.start.remaining() > 0 && this.finish.remaining() > 0 && orderedComparator.compare(this.start, this.finish) > 0;
    }

    public boolean includes(Comparator<ByteBuffer> cmp, ByteBuffer name) {
        return cmp.compare(this.start, name) <= 0 && (this.finish.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) || cmp.compare(this.finish, name) >= 0);
    }

    public boolean isBefore(Comparator<ByteBuffer> cmp, ByteBuffer name) {
        return !this.finish.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && cmp.compare(this.finish, name) < 0;
    }

    public final int hashCode() {
        int hashCode = 31 + this.start.hashCode();
        return 31 * hashCode + this.finish.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ColumnSlice)) {
            return false;
        }
        ColumnSlice that = (ColumnSlice)o;
        return this.start.equals(that.start) && this.finish.equals(that.finish);
    }

    public String toString() {
        return "[" + ByteBufferUtil.bytesToHex(this.start) + ", " + ByteBufferUtil.bytesToHex(this.finish) + "]";
    }

    public static class NavigableMapIterator
    extends AbstractIterator<Column> {
        private final NavigableMap<ByteBuffer, Column> map;
        private final ColumnSlice[] slices;
        private int idx = 0;
        private Iterator<Column> currentSlice;

        public NavigableMapIterator(NavigableMap<ByteBuffer, Column> map, ColumnSlice[] slices) {
            this.map = map;
            this.slices = slices;
        }

        protected Column computeNext() {
            while (this.currentSlice != null || this.idx < this.slices.length) {
                if (this.currentSlice == null) {
                    ColumnSlice slice = this.slices[this.idx++];
                    this.currentSlice = slice.start.remaining() == 0 ? (slice.finish.remaining() == 0 ? this.map.values().iterator() : this.map.headMap(slice.finish, true).values().iterator()) : (slice.finish.remaining() == 0 ? this.map.tailMap(slice.start, true).values().iterator() : this.map.subMap(slice.start, true, slice.finish, true).values().iterator());
                }
                if (this.currentSlice.hasNext()) {
                    return this.currentSlice.next();
                }
                this.currentSlice = null;
            }
            return (Column)this.endOfData();
        }
    }

    public static class Serializer
    implements IVersionedSerializer<ColumnSlice> {
        @Override
        public void serialize(ColumnSlice cs, DataOutput out, int version) throws IOException {
            ByteBufferUtil.writeWithShortLength(cs.start, out);
            ByteBufferUtil.writeWithShortLength(cs.finish, out);
        }

        @Override
        public ColumnSlice deserialize(DataInput in, int version) throws IOException {
            ByteBuffer start = ByteBufferUtil.readWithShortLength(in);
            ByteBuffer finish = ByteBufferUtil.readWithShortLength(in);
            return new ColumnSlice(start, finish);
        }

        @Override
        public long serializedSize(ColumnSlice cs, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int startSize = cs.start.remaining();
            int finishSize = cs.finish.remaining();
            int size = 0;
            size += sizes.sizeof((short)startSize) + startSize;
            return size += sizes.sizeof((short)finishSize) + finishSize;
        }
    }
}

