/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSimpleUnsortedWriter
extends AbstractSSTableSimpleWriter {
    private static final Buffer SENTINEL = new Buffer();
    private Buffer buffer = new Buffer();
    private final long bufferSize;
    private long currentSize;
    private final BlockingQueue<Buffer> writeQueue = new SynchronousQueue<Buffer>();
    private final DiskWriter diskWriter = new DiskWriter();

    public SSTableSimpleUnsortedWriter(File directory, IPartitioner partitioner, String keyspace, String columnFamily, AbstractType<?> comparator, AbstractType<?> subComparator, int bufferSizeInMB, CompressionParameters compressParameters) {
        this(directory, new CFMetaData(keyspace, columnFamily, subComparator == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, comparator, subComparator).compressionParameters(compressParameters), partitioner, bufferSizeInMB);
    }

    public SSTableSimpleUnsortedWriter(File directory, IPartitioner partitioner, String keyspace, String columnFamily, AbstractType<?> comparator, AbstractType<?> subComparator, int bufferSizeInMB) {
        this(directory, partitioner, keyspace, columnFamily, comparator, subComparator, bufferSizeInMB, new CompressionParameters(null));
    }

    public SSTableSimpleUnsortedWriter(File directory, CFMetaData metadata, IPartitioner partitioner, long bufferSizeInMB) {
        super(directory, metadata, partitioner);
        this.bufferSize = bufferSizeInMB * 1024L * 1024L;
        this.diskWriter.start();
    }

    @Override
    protected void writeRow(DecoratedKey key, ColumnFamily columnFamily) throws IOException {
    }

    @Override
    protected void addColumn(Column column) throws IOException {
        super.addColumn(column);
        this.countColumn(column);
    }

    protected void countColumn(Column column) throws IOException {
        this.currentSize += (long)column.serializedSize(TypeSizes.NATIVE);
        if (this.currentSize > this.bufferSize) {
            this.sync();
        }
    }

    @Override
    protected ColumnFamily getColumnFamily() throws IOException {
        ColumnFamily previous = (ColumnFamily)this.buffer.get(this.currentKey);
        if (previous == null) {
            previous = this.createColumnFamily();
            this.buffer.put(this.currentKey, previous);
            this.currentSize += (long)(14 + this.currentKey.key.remaining());
        }
        return previous;
    }

    protected ColumnFamily createColumnFamily() throws IOException {
        return TreeMapBackedSortedColumns.factory.create(this.metadata);
    }

    @Override
    public void close() throws IOException {
        this.sync();
        try {
            this.writeQueue.put(SENTINEL);
            this.diskWriter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.checkForWriterException();
    }

    private void sync() throws IOException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.checkForWriterException();
        try {
            this.writeQueue.put(this.buffer);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.buffer = new Buffer();
        this.currentSize = 0L;
    }

    private void checkForWriterException() throws IOException {
        if (this.diskWriter.exception != null) {
            if (this.diskWriter.exception instanceof IOException) {
                throw (IOException)this.diskWriter.exception;
            }
            throw Throwables.propagate((Throwable)this.diskWriter.exception);
        }
    }

    private class DiskWriter
    extends Thread {
        volatile Throwable exception = null;

        private DiskWriter() {
        }

        @Override
        public void run() {
            SSTableWriter writer = null;
            try {
                while (true) {
                    Buffer b;
                    if ((b = (Buffer)SSTableSimpleUnsortedWriter.this.writeQueue.take()) == SENTINEL) {
                        return;
                    }
                    writer = SSTableSimpleUnsortedWriter.this.getWriter();
                    for (Map.Entry entry : b.entrySet()) {
                        writer.append((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue());
                    }
                    writer.close();
                }
            }
            catch (Throwable e) {
                if (writer != null) {
                    writer.abort();
                }
                this.exception = e;
                return;
            }
        }
    }

    private static class Buffer
    extends TreeMap<DecoratedKey, ColumnFamily> {
        private Buffer() {
        }
    }
}

