/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractSimplePerColumnSecondaryIndex
extends PerColumnSecondaryIndex {
    protected ColumnFamilyStore indexCfs;
    protected ColumnDefinition columnDef;

    @Override
    public void init() {
        assert (this.baseCfs != null && this.columnDefs != null && this.columnDefs.size() == 1);
        this.columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        AbstractType<?> indexComparator = SecondaryIndex.getIndexComparator(this.baseCfs.metadata, this.columnDef);
        CFMetaData indexedCfMetadata = CFMetaData.newIndexMetadata(this.baseCfs.metadata, this.columnDef, indexComparator);
        this.indexCfs = ColumnFamilyStore.createColumnFamilyStore(this.baseCfs.keyspace, indexedCfMetadata.cfName, new LocalPartitioner(this.columnDef.getValidator()), indexedCfMetadata);
    }

    @Override
    String indexTypeForGrouping() {
        return "_internal_";
    }

    protected abstract ByteBuffer makeIndexColumnName(ByteBuffer var1, Column var2);

    protected abstract ByteBuffer getIndexedValue(ByteBuffer var1, Column var2);

    protected abstract AbstractType getExpressionComparator();

    public String expressionString(IndexExpression expr) {
        return String.format("'%s.%s %s %s'", this.baseCfs.name, this.getExpressionComparator().getString(expr.column_name), expr.op, this.baseCfs.metadata.getColumnDefinition(expr.column_name).getValidator().getString(expr.value));
    }

    @Override
    public void delete(ByteBuffer rowKey, Column column) {
        if (column.isMarkedForDelete(System.currentTimeMillis())) {
            return;
        }
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, column));
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata);
        ByteBuffer name = this.makeIndexColumnName(rowKey, column);
        assert (name.remaining() > 0 && name.remaining() <= 65535) : name.remaining();
        cfi.addTombstone(name, localDeletionTime, column.timestamp());
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)valueKey, (Object)cfi);
        }
    }

    @Override
    public void insert(ByteBuffer rowKey, Column column) {
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, column));
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata);
        ByteBuffer name = this.makeIndexColumnName(rowKey, column);
        assert (name.remaining() > 0 && name.remaining() <= 65535) : name.remaining();
        if (column instanceof ExpiringColumn) {
            ExpiringColumn ec = (ExpiringColumn)column;
            cfi.addColumn(new ExpiringColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, ec.timestamp(), ec.getTimeToLive(), ec.getLocalDeletionTime()));
        } else {
            cfi.addColumn(new Column(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, column.timestamp()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applying index row {} in {}", (Object)this.indexCfs.metadata.getKeyValidator().getString(valueKey.key), (Object)cfi);
        }
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater);
    }

    @Override
    public void update(ByteBuffer rowKey, Column col) {
        this.insert(rowKey, col);
    }

    @Override
    public void removeIndex(ByteBuffer columnName) {
        this.indexCfs.invalidate();
    }

    @Override
    public void forceBlockingFlush() {
        this.indexCfs.forceBlockingFlush();
    }

    @Override
    public void invalidate() {
        this.indexCfs.invalidate();
    }

    @Override
    public void truncateBlocking(long truncatedAt) {
        this.indexCfs.discardSSTables(truncatedAt);
    }

    @Override
    public ColumnFamilyStore getIndexCfs() {
        return this.indexCfs;
    }

    @Override
    public String getIndexName() {
        return this.indexCfs.name;
    }

    @Override
    public long getLiveSize() {
        return this.indexCfs.getMemtableDataSize();
    }

    @Override
    public void reload() {
        this.indexCfs.metadata.reloadSecondaryIndexMetadata(this.baseCfs.metadata);
        this.indexCfs.reload();
    }
}

