/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractSSTableSimpleWriter
implements Closeable {
    protected final File directory;
    protected final CFMetaData metadata;
    protected DecoratedKey currentKey;
    protected ColumnFamily columnFamily;
    protected ByteBuffer currentSuperColumn;
    protected final CounterId counterid = CounterId.generate();

    public AbstractSSTableSimpleWriter(File directory, CFMetaData metadata, IPartitioner partitioner) {
        this.metadata = metadata;
        this.directory = directory;
        DatabaseDescriptor.setPartitioner(partitioner);
    }

    protected SSTableWriter getWriter() {
        return new SSTableWriter(AbstractSSTableSimpleWriter.makeFilename(this.directory, this.metadata.ksName, this.metadata.cfName), 0L, this.metadata, DatabaseDescriptor.getPartitioner(), SSTableMetadata.createCollector(this.metadata.comparator));
    }

    protected static String makeFilename(File directory, String keyspace, final String columnFamily) {
        final HashSet existing = new HashSet();
        directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (desc == null) {
                    return false;
                }
                if (desc.cfname.equals(columnFamily)) {
                    existing.add(desc);
                }
                return false;
            }
        });
        int maxGen = 0;
        for (Descriptor desc : existing) {
            maxGen = Math.max(maxGen, desc.generation);
        }
        return new Descriptor(directory, keyspace, columnFamily, maxGen + 1, true).filenameFor(Component.DATA);
    }

    public void newRow(ByteBuffer key) throws IOException {
        if (this.currentKey != null && !this.columnFamily.isEmpty()) {
            this.writeRow(this.currentKey, this.columnFamily);
        }
        this.currentKey = DatabaseDescriptor.getPartitioner().decorateKey(key);
        this.columnFamily = this.getColumnFamily();
    }

    public void newSuperColumn(ByteBuffer name) {
        if (!this.columnFamily.metadata().isSuper()) {
            throw new IllegalStateException("Cannot add a super column to a standard column family");
        }
        this.currentSuperColumn = name;
    }

    private void addColumn(Column column) {
        if (this.columnFamily.metadata().isSuper()) {
            if (this.currentSuperColumn == null) {
                throw new IllegalStateException("Trying to add a column to a super column family, but no super column has been started.");
            }
            column = column.withUpdatedName(CompositeType.build(this.currentSuperColumn, column.name()));
        }
        this.columnFamily.addColumn(column);
    }

    public void addColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        this.addColumn(new Column(name, value, timestamp));
    }

    public void addExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int ttl, long expirationTimestampMS) {
        this.addColumn(new ExpiringColumn(name, value, timestamp, ttl, (int)(expirationTimestampMS / 1000L)));
    }

    public void addCounterColumn(ByteBuffer name, long value) {
        this.addColumn(new CounterColumn(name, CounterContext.instance().createRemote(this.counterid, 1L, value, HeapAllocator.instance), System.currentTimeMillis()));
    }

    ColumnFamily currentColumnFamily() {
        return this.columnFamily;
    }

    DecoratedKey currentKey() {
        return this.currentKey;
    }

    protected abstract void writeRow(DecoratedKey var1, ColumnFamily var2) throws IOException;

    protected abstract ColumnFamily getColumnFamily();
}

