/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;

public abstract class AbstractThreadUnsafeSortedColumns
extends ColumnFamily {
    protected DeletionInfo deletionInfo;

    public AbstractThreadUnsafeSortedColumns(CFMetaData metadata) {
        this(metadata, DeletionInfo.live());
    }

    protected AbstractThreadUnsafeSortedColumns(CFMetaData metadata, DeletionInfo deletionInfo) {
        super(metadata);
        this.deletionInfo = deletionInfo;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.deletionInfo.add(delTime);
    }

    @Override
    public void delete(DeletionInfo newInfo) {
        this.deletionInfo.add(newInfo);
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.deletionInfo.add(tombstone, this.getComparator());
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.deletionInfo = newInfo;
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        this.deletionInfo.purge(gcBefore);
    }
}

