/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasConditions;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.UnsortedColumns;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.Pair;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModificationStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    private static final Logger logger = LoggerFactory.getLogger(ModificationStatement.class);
    private static boolean loggedCounterTTL = false;
    private static boolean loggedCounterTimestamp = false;
    public final StatementType type;
    public final CFMetaData cfm;
    public final Attributes attrs;
    private final Map<ColumnIdentifier, Restriction> processedKeys = new HashMap<ColumnIdentifier, Restriction>();
    private final List<Operation> columnOperations = new ArrayList<Operation>();
    private int boundTerms;
    private List<ColumnCondition> columnConditions;
    private List<ColumnCondition> staticConditions;
    private boolean ifNotExists;
    private boolean ifExists;
    private boolean hasNoClusteringColumns = true;
    private boolean setsStaticColumns;
    private boolean setsRegularColumns;
    private final Function<ColumnCondition, ColumnIdentifier> getColumnForCondition = new Function<ColumnCondition, ColumnIdentifier>(){

        public ColumnIdentifier apply(ColumnCondition cond) {
            return cond.column.name;
        }
    };

    public ModificationStatement(StatementType type, CFMetaData cfm, Attributes attrs) {
        this.type = type;
        this.cfm = cfm;
        this.attrs = attrs;
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.attrs) + meter.measureDeep(this.processedKeys) + meter.measureDeep(this.columnOperations) + (this.columnConditions == null ? 0L : meter.measureDeep(this.columnConditions)) + (this.staticConditions == null ? 0L : meter.measureDeep(this.staticConditions));
    }

    public abstract boolean requireFullClusteringKey();

    public abstract void addUpdateForKey(ColumnFamily var1, ByteBuffer var2, ColumnNameBuilder var3, UpdateParameters var4) throws InvalidRequestException;

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.getDefaultValidator().isCommutative();
    }

    public long getTimestamp(long now, List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, variables);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimeToLive(variables);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.hasConditions()) {
            if (this.attrs.isTimestampSet()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for conditional update");
            }
            if (this.requiresRead()) {
                throw new InvalidRequestException("Operations on lists requiring a read (setting by index and deletions by index or value) are not allowed with IF conditions");
            }
        }
        if (this.isCounter()) {
            if (this.attrs.isTimestampSet() && !loggedCounterTimestamp) {
                logger.warn("Detected use of 'USING TIMESTAMP' in a counter UPDATE. This is invalid because counters do not use timestamps, and the timestamp has been ignored. Such queries will be rejected in Cassandra 2.1+ - please fix your queries before then.");
                loggedCounterTimestamp = true;
            }
            if (this.attrs.isTimeToLiveSet() && !loggedCounterTTL) {
                logger.warn("Detected use of 'USING TTL' in a counter UPDATE. This is invalid because counter tables do not support TTL, and the TTL value has been ignored. Such queries will be rejected in Cassandra 2.1+ - please fix your queries before then.");
                loggedCounterTTL = true;
            }
        }
    }

    public void addOperation(Operation op) {
        if (op.isStatic(this.cfm)) {
            this.setsStaticColumns = true;
        } else {
            this.setsRegularColumns = true;
        }
        this.columnOperations.add(op);
    }

    public List<Operation> getOperations() {
        return this.columnOperations;
    }

    public Iterable<ColumnIdentifier> getColumnsWithConditions() {
        if (this.ifNotExists || this.ifExists) {
            return null;
        }
        return Iterables.concat(this.columnConditions == null ? Collections.emptyList() : Iterables.transform(this.columnConditions, this.getColumnForCondition), this.staticConditions == null ? Collections.emptyList() : Iterables.transform(this.staticConditions, this.getColumnForCondition));
    }

    public void addCondition(ColumnCondition cond) throws InvalidRequestException {
        List<ColumnCondition> conds = null;
        if (cond.column.kind == CFDefinition.Name.Kind.STATIC) {
            this.setsStaticColumns = true;
            if (this.staticConditions == null) {
                this.staticConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.staticConditions;
        } else {
            this.setsRegularColumns = true;
            if (this.columnConditions == null) {
                this.columnConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.columnConditions;
        }
        conds.add(cond);
    }

    public void setIfNotExistCondition() {
        this.ifNotExists = true;
    }

    public boolean hasIfNotExistCondition() {
        return this.ifNotExists;
    }

    public void setIfExistCondition() {
        this.ifExists = true;
    }

    public boolean hasIfExistCondition() {
        return this.ifExists;
    }

    private void addKeyValues(CFDefinition.Name name, Restriction values) throws InvalidRequestException {
        if (name.kind == CFDefinition.Name.Kind.COLUMN_ALIAS) {
            this.hasNoClusteringColumns = false;
        }
        if (this.processedKeys.put(name.name, values) != null) {
            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name.name));
        }
    }

    public void addKeyValue(CFDefinition.Name name, Term value) throws InvalidRequestException {
        this.addKeyValues(name, new SingleColumnRestriction.EQ(value, false));
    }

    public void processWhereClause(List<Relation> whereClause, VariableSpecifications names) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        for (Relation relation : whereClause) {
            if (!(relation instanceof SingleColumnRelation)) {
                throw new InvalidRequestException(String.format("Multi-column relations cannot be used in WHERE clauses for modification statements: %s", relation));
            }
            SingleColumnRelation rel = (SingleColumnRelation)relation;
            CFDefinition.Name name = cfDef.get(rel.getEntity());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (name.kind) {
                case KEY_ALIAS: 
                case COLUMN_ALIAS: {
                    SingleColumnRestriction restriction;
                    Term t;
                    if (rel.operator() == Relation.Type.EQ) {
                        t = rel.getValue().prepare(name);
                        t.collectMarkerSpecification(names);
                        restriction = new SingleColumnRestriction.EQ(t, false);
                    } else if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS && rel.operator() == Relation.Type.IN) {
                        if (rel.getValue() != null) {
                            t = rel.getValue().prepare(name);
                            t.collectMarkerSpecification(names);
                            restriction = new SingleColumnRestriction.InWithMarker((Lists.Marker)t);
                        } else {
                            ArrayList<Term> values = new ArrayList<Term>(rel.getInValues().size());
                            for (Term.Raw raw : rel.getInValues()) {
                                Term t2 = raw.prepare(name);
                                t2.collectMarkerSpecification(names);
                                values.add(t2);
                            }
                            restriction = new SingleColumnRestriction.InWithValues(values);
                        }
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), name}));
                    }
                    this.addKeyValues(name, restriction);
                    break;
                }
                case VALUE_ALIAS: 
                case COLUMN_METADATA: 
                case STATIC: {
                    throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", name));
                }
            }
        }
    }

    public List<ByteBuffer> buildPartitionKeyNames(List<ByteBuffer> variables) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        ColumnNameBuilder keyBuilder = cfDef.getKeyNameBuilder();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (CFDefinition.Name name : cfDef.partitionKeys()) {
            Restriction r = this.processedKeys.get(name.name);
            if (r == null) {
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            List<ByteBuffer> values = r.values(variables);
            if (keyBuilder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
                    }
                    ByteBuffer key = keyBuilder.copy().add(val).build();
                    ThriftValidation.validateKey(this.cfm, key);
                    keys.add(key);
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
            }
            keyBuilder.add(val);
        }
        return keys;
    }

    public ColumnNameBuilder createClusteringPrefixBuilder(List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.setsStaticColumns && !this.setsRegularColumns) {
            if (this.hasNoClusteringColumns) {
                return this.cfm.getStaticColumnNameBuilder();
            }
            if (this.type != StatementType.INSERT) {
                for (CFDefinition.Name name : this.cfm.getCfDef().clusteringColumns()) {
                    if (this.processedKeys.get(name.name) == null) continue;
                    throw new InvalidRequestException(String.format("Invalid restriction on clustering column %s since the %s statement modifies only static columns", new Object[]{name.name, this.type}));
                }
                throw new AssertionError();
            }
        }
        return this.createClusteringPrefixBuilderInternal(variables);
    }

    private ColumnNameBuilder updatePrefixFor(ByteBuffer name, ColumnNameBuilder prefix) {
        return this.isStatic(name) ? this.cfm.getStaticColumnNameBuilder() : prefix;
    }

    public boolean isStatic(ByteBuffer name) {
        ColumnDefinition def = this.cfm.getColumnDefinition(name);
        return def != null && def.type == ColumnDefinition.Type.STATIC;
    }

    private ColumnNameBuilder createClusteringPrefixBuilderInternal(List<ByteBuffer> variables) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        ColumnNameBuilder builder = cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmptyKey = null;
        for (CFDefinition.Name name : cfDef.clusteringColumns()) {
            Restriction r = this.processedKeys.get(name.name);
            if (r == null) {
                firstEmptyKey = name;
                if (!this.requireFullClusteringKey() || !cfDef.isComposite || cfDef.isCompact) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmptyKey != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmptyKey.name, name.name));
            }
            List<ByteBuffer> values = r.values(variables);
            assert (values.size() == 1);
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", name));
            }
            builder.add(val);
        }
        return builder;
    }

    protected CFDefinition.Name getFirstEmptyKey() {
        for (CFDefinition.Name name : this.cfm.getCfDef().clusteringColumns()) {
            if (this.processedKeys.get(name.name) != null) continue;
            return name;
        }
        return null;
    }

    public boolean requiresRead() {
        for (Operation op : this.columnOperations) {
            if (!op.requiresRead()) continue;
            return true;
        }
        return false;
    }

    protected Map<ByteBuffer, ColumnGroupMap> readRequiredRows(Collection<ByteBuffer> partitionKeys, ColumnNameBuilder clusteringPrefix, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        TreeSet<ByteBuffer> toRead = null;
        for (Operation op : this.columnOperations) {
            if (!op.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(op.columnName.key);
        }
        return toRead == null ? null : this.readRows(partitionKeys, clusteringPrefix, toRead, (CompositeType)this.cfm.comparator, local, cl);
    }

    private Map<ByteBuffer, ColumnGroupMap> readRows(Collection<ByteBuffer> partitionKeys, ColumnNameBuilder clusteringPrefix, Set<ByteBuffer> toRead, CompositeType composite, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        try {
            cl.validateForRead(this.keyspace());
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(String.format("Write operation require a read but consistency %s is not supported on reads", new Object[]{cl}));
        }
        ColumnSlice[] slices = new ColumnSlice[toRead.size()];
        int i = 0;
        for (ByteBuffer name : toRead) {
            ColumnNameBuilder prefix = this.updatePrefixFor(name, clusteringPrefix);
            ByteBuffer start = prefix.copy().add(name).build();
            ByteBuffer finish = prefix.copy().add(name).buildAsEndOfRange();
            slices[i++] = new ColumnSlice(start, finish);
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(partitionKeys.size());
        long now = System.currentTimeMillis();
        for (ByteBuffer key : partitionKeys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, this.columnFamily(), now, new SliceQueryFilter(slices, false, Integer.MAX_VALUE)));
        }
        List<Row> rows = local ? SelectStatement.readLocally(this.keyspace(), commands) : StorageProxy.read(commands, cl);
        HashMap<ByteBuffer, ColumnGroupMap> map = new HashMap<ByteBuffer, ColumnGroupMap>();
        for (Row row : rows) {
            if (row.cf == null || row.cf.getColumnCount() == 0) continue;
            ColumnGroupMap.Builder groupBuilder = new ColumnGroupMap.Builder(composite, true, now);
            for (Column column : row.cf) {
                groupBuilder.add(column);
            }
            List<ColumnGroupMap> groups = groupBuilder.groups();
            assert (groups.isEmpty() || groups.size() == 1);
            if (groups.isEmpty()) continue;
            map.put(row.key.key, groups.get(0));
        }
        return map;
    }

    public boolean hasConditions() {
        return this.ifNotExists || this.ifExists || this.columnConditions != null && !this.columnConditions.isEmpty() || this.staticConditions != null && !this.staticConditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (this.hasConditions() && options.getProtocolVersion() == 1) {
            throw new InvalidRequestException("Conditional updates are not supported by the protocol version in use. You need to upgrade to a driver using the native protocol v2.");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options.getValues(), false, cl, queryState.getTimestamp());
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        if (keys.size() > 1) {
            throw new InvalidRequestException("IN on the partition key is not supported with conditional updates");
        }
        ByteBuffer key = keys.get(0);
        CQL3CasConditions conditions = new CQL3CasConditions(this.cfm, queryState.getTimestamp());
        ColumnNameBuilder prefix = this.createClusteringPrefixBuilder(variables);
        UnsortedColumns updates = UnsortedColumns.factory.create(this.cfm);
        this.addUpdatesAndConditions(key, prefix, updates, conditions, variables, this.getTimestamp(queryState.getTimestamp(), variables));
        ColumnFamily result = StorageProxy.cas(this.keyspace(), this.columnFamily(), key, conditions, updates, options.getSerialConsistency(), options.getConsistency());
        return new ResultMessage.Rows(this.buildCasResultSet(key, result));
    }

    public void addUpdatesAndConditions(ByteBuffer key, ColumnNameBuilder clusteringPrefix, ColumnFamily updates, CQL3CasConditions conditions, List<ByteBuffer> variables, long now) throws InvalidRequestException {
        UpdateParameters updParams = new UpdateParameters(this.cfm, variables, now, this.getTimeToLive(variables), null);
        this.addUpdateForKey(updates, key, clusteringPrefix, updParams);
        if (this.ifNotExists) {
            conditions.addNotExist(clusteringPrefix);
        } else if (this.ifExists) {
            conditions.addExist(clusteringPrefix);
        } else {
            if (this.columnConditions != null) {
                conditions.addConditions(clusteringPrefix, this.columnConditions, variables);
            }
            if (this.staticConditions != null) {
                conditions.addConditions(this.cfm.getStaticColumnNameBuilder(), this.staticConditions, variables);
            }
        }
    }

    private ResultSet buildCasResultSet(ByteBuffer key, ColumnFamily cf) throws InvalidRequestException {
        return ModificationStatement.buildCasResultSet(this.keyspace(), key, this.columnFamily(), cf, this.getColumnsWithConditions(), false);
    }

    public static ResultSet buildCasResultSet(String ksName, ByteBuffer key, String cfName, ColumnFamily cf, Iterable<ColumnIdentifier> columnsWithConditions, boolean isBatch) throws InvalidRequestException {
        boolean success = cf == null;
        ColumnSpecification spec = new ColumnSpecification(ksName, cfName, CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.Metadata metadata = new ResultSet.Metadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(key, cf, columnsWithConditions, isBatch));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.Metadata(specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(ByteBuffer key, ColumnFamily cf, Iterable<ColumnIdentifier> columnsWithConditions, boolean isBatch) throws InvalidRequestException {
        Selection selection;
        CFDefinition cfDef = cf.metadata().getCfDef();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(cfDef);
        } else {
            LinkedHashSet<CFDefinition.Name> names = new LinkedHashSet<CFDefinition.Name>();
            if (isBatch) {
                names.addAll(cfDef.partitionKeys());
                names.addAll(cfDef.clusteringColumns());
            }
            for (ColumnIdentifier id : columnsWithConditions) {
                names.add(cfDef.get(id));
            }
            selection = Selection.forColumns(names);
        }
        long now = System.currentTimeMillis();
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(now);
        SelectStatement.forSelection(cfDef, selection).processColumnFamily(key, cf, Collections.emptyList(), now, builder);
        return builder.build();
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        if (this.hasConditions()) {
            throw new UnsupportedOperationException();
        }
        List<ByteBuffer> variables = options.getValues();
        for (IMutation iMutation : this.getMutations(variables, true, null, queryState.getTimestamp())) {
            iMutation.apply();
        }
        return null;
    }

    private Collection<? extends IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        ColumnNameBuilder clusteringPrefix = this.createClusteringPrefixBuilder(variables);
        UpdateParameters params = this.makeUpdateParameters(keys, clusteringPrefix, variables, local, cl, now);
        ArrayList<RowMutation> mutations = new ArrayList<RowMutation>();
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(this.cfm, key);
            UnsortedColumns cf = UnsortedColumns.factory.create(this.cfm);
            this.addUpdateForKey(cf, key, clusteringPrefix, params);
            RowMutation rm = new RowMutation(this.cfm.ksName, key, cf);
            mutations.add((RowMutation)(this.isCounter() ? new CounterMutation(rm, cl) : rm));
        }
        return mutations;
    }

    public UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, ColumnNameBuilder prefix, List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        Map<ByteBuffer, ColumnGroupMap> rows = this.readRequiredRows(keys, prefix, local, cl);
        return new UpdateParameters(this.cfm, variables, this.getTimestamp(now, variables), this.getTimeToLive(variables), rows);
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final Attributes.Raw attrs;
        protected final List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames);
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames);
        }

        public ModificationStatement prepare(VariableSpecifications boundNames) throws InvalidRequestException {
            CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            CFDefinition cfDef = metadata.getCfDef();
            int collected = boundNames.getCollectedCount();
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            ModificationStatement stmt = this.prepareInternal(cfDef, boundNames, preparedAttributes);
            if (this.ifNotExists || this.ifExists || !this.conditions.isEmpty()) {
                if (stmt.isCounter()) {
                    throw new InvalidRequestException("Conditional updates are not supported on counter tables");
                }
                if (this.ifNotExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifExists);
                    stmt.setIfNotExistCondition();
                } else if (this.ifExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifNotExists);
                    stmt.setIfExistCondition();
                } else {
                    for (Pair<ColumnIdentifier, ColumnCondition.Raw> entry : this.conditions) {
                        CFDefinition.Name name = cfDef.get((ColumnIdentifier)entry.left);
                        if (name == null) {
                            throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                        }
                        ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(name);
                        condition.collectMarkerSpecification(boundNames);
                        switch (name.kind) {
                            case KEY_ALIAS: 
                            case COLUMN_ALIAS: {
                                throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                            }
                            case VALUE_ALIAS: 
                            case COLUMN_METADATA: 
                            case STATIC: {
                                stmt.addCondition(condition);
                            }
                        }
                    }
                }
            }
            stmt.boundTerms = boundNames.getCollectedCount() - collected;
            return stmt;
        }

        protected abstract ModificationStatement prepareInternal(CFDefinition var1, VariableSpecifications var2, Attributes var3) throws InvalidRequestException;
    }

    public static enum StatementType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

