/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_KS = "system_traces";
    public static final String EVENTS_CF = "events";
    public static final String SESSIONS_CF = "sessions";
    public static final String TRACE_HEADER = "TraceSession";
    private static final int TTL = 86400;
    private static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    private final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance = new Tracing();

    public static void addColumn(ColumnFamily cf, ByteBuffer name, InetAddress address) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(address));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, int value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, long value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, String value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    private static void addColumn(ColumnFamily cf, ByteBuffer name, ByteBuffer value) {
        cf.addColumn(new ExpiringColumn(name, value, System.currentTimeMillis(), 86400));
    }

    public void addParameterColumns(ColumnFamily cf, Map<String, String> rawPayload) {
        for (Map.Entry<String, String> entry : rawPayload.entrySet()) {
            cf.addColumn(new ExpiringColumn(Tracing.buildName(cf.metadata(), ByteBufferUtil.bytes("parameters"), ByteBufferUtil.bytes(entry.getKey())), ByteBufferUtil.bytes(entry.getValue()), System.currentTimeMillis(), 86400));
        }
    }

    public static ByteBuffer buildName(CFMetaData meta, ByteBuffer ... args) {
        ColumnNameBuilder builder = meta.getCfDef().getColumnNameBuilder();
        for (ByteBuffer arg : args) {
            builder.add(arg);
        }
        return builder.build();
    }

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public static boolean isTracing() {
        return Tracing.instance.state.get() != null;
    }

    public UUID newSession() {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())));
    }

    public UUID newSession(UUID sessionId) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, sessionId);
        this.state.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void stopNonLocal(TraceState state) {
        this.sessions.remove(state.sessionId);
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            final int elapsed = state.elapsed();
            final ByteBuffer sessionIdBytes = state.sessionIdBytes;
            StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws Exception {
                    CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                    ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(cfMeta);
                    Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("duration")), elapsed);
                    RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes, cf);
                    StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
                }
            });
            this.sessions.remove(state.sessionId);
            this.state.set(null);
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public void begin(final String request, final Map<String, String> parameters) {
        assert (Tracing.isTracing());
        final long started_at = System.currentTimeMillis();
        final ByteBuffer sessionIdBytes = this.state.get().sessionIdBytes;
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                TreeMapBackedSortedColumns cf = TreeMapBackedSortedColumns.factory.create(cfMeta);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("coordinator")), FBUtilities.getBroadcastAddress());
                Tracing.this.addParameterColumns(cf, parameters);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("request")), request);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("started_at")), started_at);
                RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes, cf);
                StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
            }
        });
    }

    public TraceState initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            return null;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = (TraceState)this.sessions.get(sessionId);
        if (ts != null) {
            return ts;
        }
        if (message.verb == MessagingService.Verb.REQUEST_RESPONSE) {
            return new ExpiredTraceState(sessionId);
        }
        ts = new TraceState(message.from, sessionId);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object[] args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }
}

