/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.CompressedPoolingSegmentedFile;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private final CompressionMetadata metadata;
    private ByteBuffer compressed;
    private final Checksum checksum;
    private final ByteBuffer checksumBytes = ByteBuffer.wrap(new byte[4]);

    public static CompressedRandomAccessReader open(String path, CompressionMetadata metadata, CompressedPoolingSegmentedFile owner) {
        try {
            return new CompressedRandomAccessReader(path, metadata, (PoolingSegmentedFile)owner);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompressedRandomAccessReader open(String dataFilePath, CompressionMetadata metadata) {
        try {
            return new CompressedRandomAccessReader(dataFilePath, metadata, null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected CompressedRandomAccessReader(String dataFilePath, CompressionMetadata metadata, PoolingSegmentedFile owner) throws FileNotFoundException {
        super(new File(dataFilePath), metadata.chunkLength(), owner);
        this.metadata = metadata;
        this.checksum = metadata.hasPostCompressionAdlerChecksums ? new Adler32() : new CRC32();
        this.compressed = ByteBuffer.wrap(new byte[metadata.compressor().initialCompressedBufferLength(metadata.chunkLength())]);
    }

    @Override
    protected void reBuffer() {
        try {
            this.decompressChunk(this.metadata.chunkFor(this.current));
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    private void decompressChunk(CompressionMetadata.Chunk chunk) throws IOException {
        if (this.channel.position() != chunk.offset) {
            this.channel.position(chunk.offset);
        }
        if (this.compressed.capacity() < chunk.length) {
            this.compressed = ByteBuffer.wrap(new byte[chunk.length]);
        } else {
            this.compressed.clear();
        }
        this.compressed.limit(chunk.length);
        if (this.channel.read(this.compressed) != chunk.length) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        this.compressed.flip();
        try {
            this.validBufferBytes = this.metadata.compressor().uncompress(this.compressed.array(), 0, chunk.length, this.buffer, 0);
        }
        catch (IOException e) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        if (this.metadata.parameters.getCrcCheckChance() > FBUtilities.threadLocalRandom().nextDouble()) {
            if (this.metadata.hasPostCompressionAdlerChecksums) {
                this.checksum.update(this.compressed.array(), 0, chunk.length);
            } else {
                this.checksum.update(this.buffer, 0, this.validBufferBytes);
            }
            if (this.checksum(chunk) != (int)this.checksum.getValue()) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            this.checksum.reset();
        }
        this.bufferOffset = this.current & (long)(~(this.buffer.length - 1));
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        assert (this.channel.position() == chunk.offset + (long)chunk.length);
        this.checksumBytes.clear();
        if (this.channel.read(this.checksumBytes) != this.checksumBytes.capacity()) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        return this.checksumBytes.getInt(0);
    }

    @Override
    public long length() {
        return this.metadata.dataLength;
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }
}

