/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ReadyMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class CredentialsMessage
extends Message.Request {
    public static final Message.Codec<CredentialsMessage> codec = new Message.Codec<CredentialsMessage>(){

        @Override
        public CredentialsMessage decode(ChannelBuffer body, int version) {
            if (version > 1) {
                throw new ProtocolException("Legacy credentials authentication is not supported in protocol versions > 1. Please use SASL authentication via a SaslResponse message");
            }
            CredentialsMessage msg = new CredentialsMessage();
            int count = body.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                String key = CBUtil.readString(body);
                String value = CBUtil.readString(body);
                msg.credentials.put(key, value);
            }
            return msg;
        }

        @Override
        public ChannelBuffer encode(CredentialsMessage msg, int version) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeShort(msg.credentials.size());
            for (Map.Entry<String, String> entry : msg.credentials.entrySet()) {
                cb.writeBytes(CBUtil.stringToCB(entry.getKey()));
                cb.writeBytes(CBUtil.stringToCB(entry.getValue()));
            }
            return cb;
        }
    };
    public final Map<String, String> credentials = new HashMap<String, String>();

    public CredentialsMessage() {
        super(Message.Type.CREDENTIALS);
    }

    @Override
    public ChannelBuffer encode(int version) {
        return codec.encode(this, version);
    }

    @Override
    public Message.Response execute(QueryState state) {
        try {
            AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(this.credentials);
            state.getClientState().login(user);
            return new ReadyMessage();
        }
        catch (AuthenticationException e) {
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "CREDENTIALS " + this.credentials;
    }
}

