/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.lang.reflect.Array;
import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.Pair;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class OptionCodec<T extends Enum<T>> {
    private final Class<T> klass;
    private final T[] ids;

    public OptionCodec(Class<T> klass) {
        this.klass = klass;
        Enum[] values = (Enum[])klass.getEnumConstants();
        int maxId = -1;
        for (Enum opt : values) {
            maxId = Math.max(maxId, ((Codecable)((Object)opt)).getId());
        }
        this.ids = (Enum[])Array.newInstance(klass, maxId + 1);
        for (Enum opt : values) {
            if (this.ids[((Codecable)((Object)opt)).getId()] != null) {
                throw new IllegalStateException(String.format("Duplicate option id %d", ((Codecable)((Object)opt)).getId()));
            }
            this.ids[((Codecable)((Object)opt)).getId()] = opt;
        }
    }

    private T fromId(int id) {
        T opt = this.ids[id];
        if (opt == null) {
            throw new ProtocolException(String.format("Unknown option id %d", id));
        }
        return opt;
    }

    public Map<T, Object> decode(ChannelBuffer body) {
        EnumMap<T, Object> options = new EnumMap<T, Object>(this.klass);
        int n = body.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            T opt = this.fromId(body.readUnsignedShort());
            Object value = ((Codecable)opt).readValue(body);
            if (options.containsKey(opt)) {
                throw new ProtocolException(String.format("Duplicate option %s in message", ((Enum)opt).name()));
            }
            options.put(opt, value);
        }
        return options;
    }

    public ChannelBuffer encode(Map<T, Object> options) {
        int optLength = 2;
        for (Map.Entry<T, Object> entry : options.entrySet()) {
            optLength += 2 + ((Codecable)((Object)((Enum)entry.getKey()))).serializedValueSize(entry.getValue());
        }
        ChannelBuffer cb = ChannelBuffers.buffer((int)optLength);
        cb.writeShort(options.size());
        for (Map.Entry<T, Object> entry : options.entrySet()) {
            Enum opt = (Enum)entry.getKey();
            cb.writeShort(((Codecable)((Object)opt)).getId());
            ((Codecable)((Object)opt)).writeValue(entry.getValue(), cb);
        }
        return cb;
    }

    public Pair<T, Object> decodeOne(ChannelBuffer body) {
        T opt = this.fromId(body.readUnsignedShort());
        Object value = ((Codecable)opt).readValue(body);
        return Pair.create(opt, value);
    }

    public ChannelBuffer encodeOne(Pair<T, Object> option) {
        Enum opt = (Enum)option.left;
        Object obj = option.right;
        ChannelBuffer cb = ChannelBuffers.buffer((int)this.oneSerializedSize(option));
        cb.writeShort(((Codecable)((Object)opt)).getId());
        ((Codecable)((Object)opt)).writeValue(obj, cb);
        return cb;
    }

    public int oneSerializedSize(Pair<T, Object> option) {
        Enum opt = (Enum)option.left;
        Object obj = option.right;
        return 2 + ((Codecable)((Object)opt)).serializedValueSize(obj);
    }

    public static interface Codecable<T extends Enum<T>> {
        public int getId();

        public Object readValue(ChannelBuffer var1);

        public void writeValue(Object var1, ChannelBuffer var2);

        public int serializedValueSize(Object var1);
    }
}

