/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.paxos.AbstractPaxosCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposeCallback
extends AbstractPaxosCallback<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(ProposeCallback.class);
    private final AtomicInteger successful = new AtomicInteger(0);

    public ProposeCallback(int targets) {
        super(targets);
    }

    @Override
    public void response(MessageIn<Boolean> msg) {
        logger.debug("Propose response {} from {}", msg.payload, (Object)msg.from);
        if (((Boolean)msg.payload).booleanValue()) {
            this.successful.incrementAndGet();
        }
        this.latch.countDown();
    }

    public int getSuccessful() {
        return this.successful.get();
    }
}

