/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.concurrent.TracingAwareExecutorService;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.BatchlogManager;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterMutationVerbHandler;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefinitionsUpdateVerbHandler;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.MigrationRequestVerbHandler;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.db.SchemaCheckVerbHandler;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TruncateVerbHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.GossipShutdownVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.repair.RepairFuture;
import org.apache.cassandra.repair.RepairMessageVerbHandler;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.EchoVerbHandler;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.LoadBroadcaster;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.ScheduledRangeTransferExecutorService;
import org.apache.cassandra.service.SnapshotVerbHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.service.paxos.CommitVerbHandler;
import org.apache.cassandra.service.paxos.PrepareVerbHandler;
import org.apache.cassandra.service.paxos.ProposeVerbHandler;
import org.apache.cassandra.streaming.ReplicationFinishedVerbHandler;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.BackgroundActivityMonitor;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends NotificationBroadcasterSupport
implements IEndpointStateChangeSubscriber,
StorageServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageService.class);
    public static final int RING_DELAY = StorageService.getRingDelay();
    private final AtomicLong notificationSerialNumber = new AtomicLong();
    private final AtomicDouble severity = new AtomicDouble();
    public static final DebuggableScheduledThreadPoolExecutor scheduledTasks = new DebuggableScheduledThreadPoolExecutor("ScheduledTasks");
    public static final DebuggableScheduledThreadPoolExecutor tasks = new DebuggableScheduledThreadPoolExecutor("NonPeriodicTasks");
    public static final DebuggableScheduledThreadPoolExecutor optionalTasks = new DebuggableScheduledThreadPoolExecutor("OptionalTasks");
    private TokenMetadata tokenMetadata = new TokenMetadata();
    public VersionedValue.VersionedValueFactory valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
    public static final StorageService instance;
    private final Set<InetAddress> replicatingNodes = Collections.synchronizedSet(new HashSet());
    private CassandraDaemon daemon;
    private InetAddress removingNode;
    private boolean isBootstrapMode;
    private boolean isSurveyMode = Boolean.parseBoolean(System.getProperty("cassandra.write_survey", "false"));
    private boolean isClientMode;
    private boolean initialized;
    private volatile boolean joined = false;
    private double tracingProbability = 0.0;
    private Mode operationMode;
    private final MigrationManager migrationManager = MigrationManager.instance;
    private volatile int totalCFs;
    private volatile int remainingCFs;
    private static final AtomicInteger nextRepairCommand;
    private static ScheduledRangeTransferExecutorService rangeXferExecutor;
    private final List<IEndpointLifecycleSubscriber> lifecycleSubscribers = new CopyOnWriteArrayList<IEndpointLifecycleSubscriber>();
    private static final BackgroundActivityMonitor bgMonitor;
    private final ObjectName jmxObjectName;

    private static int getRingDelay() {
        String newdelay = System.getProperty("cassandra.ring_delay_ms");
        if (newdelay != null) {
            logger.info("Overriding RING_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    public static IPartitioner getPartitioner() {
        return DatabaseDescriptor.getPartitioner();
    }

    public Collection<Range<Token>> getLocalRanges(String keyspaceName) {
        return this.getRangesForEndpoint(keyspaceName, FBUtilities.getBroadcastAddress());
    }

    public Collection<Range<Token>> getLocalPrimaryRanges(String keyspace) {
        return this.getPrimaryRangesForEndpoint(keyspace, FBUtilities.getBroadcastAddress());
    }

    public void finishBootstrapping() {
        this.isBootstrapMode = false;
    }

    public void setTokens(Collection<Token> tokens) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting tokens to {}", tokens);
        }
        SystemKeyspace.updateTokens(tokens);
        this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(this.getLocalTokens()));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.normal(this.getLocalTokens()));
        this.setMode(Mode.NORMAL, false);
    }

    public StorageService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.jmxObjectName = new ObjectName("org.apache.cassandra.db:type=StorageService");
            mbs.registerMBean(this, this.jmxObjectName);
            mbs.registerMBean(StreamManager.instance, new ObjectName("org.apache.cassandra.net:type=StreamManager"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MUTATION, new RowMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ_REPAIR, new ReadRepairVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ, new ReadVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.RANGE_SLICE, new RangeSliceVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.COUNTER_MUTATION, new CounterMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.TRUNCATE, new TruncateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_PREPARE, new PrepareVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_PROPOSE, new ProposeVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_COMMIT, new CommitVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REPLICATION_FINISHED, new ReplicationFinishedVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REQUEST_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.INTERNAL_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REPAIR_MESSAGE, new RepairMessageVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_SHUTDOWN, new GossipShutdownVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_SYN, new GossipDigestSynVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2VerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.DEFINITIONS_UPDATE, new DefinitionsUpdateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SCHEMA_CHECK, new SchemaCheckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MIGRATION_REQUEST, new MigrationRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SNAPSHOT, new SnapshotVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.ECHO, new EchoVerbHandler());
    }

    public void registerDaemon(CassandraDaemon daemon) {
        this.daemon = daemon;
    }

    public void register(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.add(subscriber);
    }

    public void unregister(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.remove(subscriber);
    }

    @Override
    public void stopGossiping() {
        if (this.initialized) {
            logger.warn("Stopping gossip by operator request");
            Gossiper.instance.stop();
            this.initialized = false;
        }
    }

    @Override
    public void startGossiping() {
        if (!this.initialized) {
            logger.warn("Starting gossip by operator request");
            Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
            this.initialized = true;
        }
    }

    @Override
    public void startRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.thriftServer.start();
    }

    @Override
    public void stopRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.thriftServer.stop();
    }

    @Override
    public boolean isRPCServerRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.thriftServer.isRunning();
    }

    @Override
    public void startNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        try {
            this.daemon.nativeServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting native transport: " + e.getMessage());
        }
    }

    @Override
    public void stopNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.nativeServer.stop();
    }

    @Override
    public boolean isNativeTransportRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.nativeServer.isRunning();
    }

    private void shutdownClientServers() {
        this.stopRPCServer();
        this.stopNativeTransport();
    }

    public void stopClient() {
        Gossiper.instance.unregister(this.migrationManager);
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.instance().shutdown();
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        StageManager.shutdownNow();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initClient() throws ConfigurationException {
        this.initClient(0);
        block0: while (true) {
            InetAddress address;
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            Iterator<InetAddress> i$ = Gossiper.instance.getLiveMembers().iterator();
            do {
                if (!i$.hasNext()) continue block0;
            } while (Gossiper.instance.isFatClient(address = i$.next()));
            break;
        }
        while (!MigrationManager.isReadyForBootstrap()) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public synchronized void initClient(int ringDelay) throws ConfigurationException {
        if (this.initialized) {
            if (!this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = true;
        logger.info("Starting up client gossip");
        this.setMode(Mode.CLIENT, false);
        Gossiper.instance.register(this);
        Gossiper.instance.register(this.migrationManager);
        Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
        Gossiper.instance.addLocalApplicationState(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        Uninterruptibles.sleepUninterruptibly((long)ringDelay, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public synchronized void initServer() throws ConfigurationException {
        this.initServer(RING_DELAY);
    }

    public synchronized void initServer(int delay) throws ConfigurationException {
        logger.info("Cassandra version: " + FBUtilities.getReleaseVersionString());
        logger.info("Thrift API version: 19.37.0");
        logger.info("CQL supported versions: " + StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)",") + " (default: " + ClientState.DEFAULT_CQL_VERSION + ")");
        if (this.initialized) {
            if (this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = false;
        try {
            Class.forName("org.apache.cassandra.service.StorageProxy");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger.info("Loading persisted ring state");
            SetMultimap<InetAddress, Token> loadedTokens = SystemKeyspace.loadTokens();
            Map<InetAddress, UUID> loadedHostIds = SystemKeyspace.loadHostIds();
            for (InetAddress ep : loadedTokens.keySet()) {
                if (ep.equals(FBUtilities.getBroadcastAddress())) {
                    SystemKeyspace.removeEndpoint(ep);
                    continue;
                }
                this.tokenMetadata.updateNormalTokens(loadedTokens.get((Object)ep), ep);
                if (loadedHostIds.containsKey(ep)) {
                    this.tokenMetadata.updateHostId(loadedHostIds.get(ep), ep);
                }
                Gossiper.instance.addSavedEndpoint(ep);
            }
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.renew_counter_id", "false"))) {
            logger.info("Renewing local node id (as requested)");
            CounterId.renewLocalId();
        }
        Thread drainOnShutdown = new Thread((Runnable)new WrappedRunnable(){

            @Override
            public void runMayThrow() throws ExecutionException, InterruptedException, IOException {
                TracingAwareExecutorService mutationStage = StageManager.getStage(Stage.MUTATION);
                if (mutationStage.isShutdown()) {
                    return;
                }
                StorageService.this.shutdownClientServers();
                optionalTasks.shutdown();
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                mutationStage.shutdown();
                mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
                StorageProxy.instance.verifyNoHintsInProgress();
                ArrayList flushes = new ArrayList();
                for (Keyspace keyspace : Keyspace.all()) {
                    KSMetaData ksm = Schema.instance.getKSMetaData(keyspace.getName());
                    if (ksm.durableWrites) continue;
                    for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                        flushes.add(cfs.forceFlush());
                    }
                }
                FBUtilities.waitOnFutures(flushes);
                CommitLog.instance.shutdownBlocking();
                tasks.shutdown();
                if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
                }
            }
        }, "StorageServiceShutdownHook");
        Runtime.getRuntime().addShutdownHook(drainOnShutdown);
        if (Boolean.parseBoolean(System.getProperty("cassandra.join_ring", "true"))) {
            this.joinTokenRing(delay);
        } else {
            logger.info("Not joining ring as requested. Use JMX (StorageService->joinRing()) to initiate ring joining");
        }
    }

    private void joinTokenRing(int delay) throws ConfigurationException {
        Collection<Token> tokens;
        logger.info("Starting up server gossip");
        this.joined = true;
        this.getTokenMetadata().updateHostId(SystemKeyspace.getLocalHostId(), FBUtilities.getBroadcastAddress());
        HashMap<ApplicationState, VersionedValue> appStates = new HashMap<ApplicationState, VersionedValue>();
        appStates.put(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        appStates.put(ApplicationState.HOST_ID, this.valueFactory.hostId(SystemKeyspace.getLocalHostId()));
        appStates.put(ApplicationState.RPC_ADDRESS, this.valueFactory.rpcaddress(DatabaseDescriptor.getRpcAddress()));
        if (DatabaseDescriptor.isReplacing()) {
            appStates.put(ApplicationState.STATUS, this.valueFactory.hibernate(true));
        }
        appStates.put(ApplicationState.RELEASE_VERSION, this.valueFactory.releaseVersion());
        Gossiper.instance.register(this);
        Gossiper.instance.register(this.migrationManager);
        Gossiper.instance.start(SystemKeyspace.incrementAndGetGeneration(), appStates);
        this.gossipSnitchInfo();
        Schema.instance.updateVersionAndAnnounce();
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        LoadBroadcaster.instance.startBroadcasting();
        HintedHandOffManager.instance.start();
        BatchlogManager.instance.start();
        HashSet<InetAddress> current = new HashSet<InetAddress>();
        logger.debug("Bootstrap variables: {} {} {} {}", new Object[]{DatabaseDescriptor.isAutoBootstrap(), SystemKeyspace.bootstrapInProgress(), SystemKeyspace.bootstrapComplete(), DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())});
        if (DatabaseDescriptor.isAutoBootstrap() && !SystemKeyspace.bootstrapComplete() && !DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())) {
            if (SystemKeyspace.bootstrapInProgress()) {
                logger.warn("Detected previous bootstrap failure; retrying");
            } else {
                SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.IN_PROGRESS);
            }
            this.setMode(Mode.JOINING, "waiting for ring information", true);
            for (int i = 0; i < delay; i += 1000) {
                if (!Schema.instance.getVersion().equals(Schema.emptyVersion)) {
                    logger.debug("got schema: {}", (Object)Schema.instance.getVersion());
                    break;
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            while (!MigrationManager.isReadyForBootstrap()) {
                this.setMode(Mode.JOINING, "waiting for schema information to complete", true);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            this.setMode(Mode.JOINING, "schema complete, ready to bootstrap", true);
            if (logger.isDebugEnabled()) {
                logger.debug("... got ring + schema info");
            }
            if (!DatabaseDescriptor.isReplacing()) {
                if (this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
                    String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                    throw new UnsupportedOperationException(s);
                }
                this.setMode(Mode.JOINING, "getting bootstrap token", true);
                tokens = BootStrapper.getBootstrapTokens(this.tokenMetadata, LoadBroadcaster.instance.getLoadInfo());
            } else {
                Uninterruptibles.sleepUninterruptibly((long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
                if (DatabaseDescriptor.getReplaceTokens().size() != 0 && DatabaseDescriptor.getReplaceNode() != null) {
                    throw new UnsupportedOperationException("You cannot specify both replace_token and replace_node, choose one or the other");
                }
                tokens = new ArrayList<Token>();
                if (DatabaseDescriptor.getReplaceTokens().size() != 0) {
                    for (String string : DatabaseDescriptor.getReplaceTokens()) {
                        tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(string));
                    }
                } else {
                    assert (DatabaseDescriptor.getReplaceNode() != null);
                    InetAddress endpoint = this.tokenMetadata.getEndpointForHostId(DatabaseDescriptor.getReplaceNode());
                    if (endpoint == null) {
                        throw new UnsupportedOperationException("Cannot replace host id " + DatabaseDescriptor.getReplaceNode() + " because it does not exist!");
                    }
                    tokens = this.tokenMetadata.getTokens(endpoint);
                }
                for (Token token : tokens) {
                    InetAddress existing = this.tokenMetadata.getEndpoint(token);
                    if (existing != null) {
                        if ((long)delay > TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Gossiper.instance.getEndpointStateForEndpoint(existing).getUpdateTimestamp())) {
                            throw new UnsupportedOperationException("Cannnot replace a token for a Live node... ");
                        }
                        current.add(existing);
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot replace token " + token + " which does not exist!");
                }
                this.setMode(Mode.JOINING, "Replacing a node with token: " + tokens, true);
            }
            this.bootstrap(tokens);
            assert (!this.isBootstrapMode);
        } else {
            tokens = SystemKeyspace.getSavedTokens();
            if (tokens.isEmpty()) {
                Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
                if (initialTokens.size() < 1) {
                    tokens = BootStrapper.getRandomTokens(this.tokenMetadata, DatabaseDescriptor.getNumTokens());
                    if (DatabaseDescriptor.getNumTokens() == 1) {
                        logger.warn("Generated random token " + tokens + ". Random tokens will result in an unbalanced ring; see http://wiki.apache.org/cassandra/Operations");
                    } else {
                        logger.info("Generated random tokens. tokens are {}", tokens);
                    }
                } else {
                    tokens = new ArrayList<Token>(initialTokens.size());
                    for (String token : initialTokens) {
                        tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(token));
                    }
                    logger.info("Saved token not found. Using " + tokens + " from configuration");
                }
            } else if (tokens.size() == 1 && DatabaseDescriptor.getNumTokens() > 1) {
                logger.info("Sleeping for ring delay (" + delay + "ms)");
                Uninterruptibles.sleepUninterruptibly((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
                logger.info("Calculating new tokens");
                Token right = tokens.iterator().next();
                TokenMetadata tokenMetadata = this.tokenMetadata.cloneOnlyTokenMap();
                tokenMetadata.updateNormalToken(right, FBUtilities.getBroadcastAddress());
                Token left = tokenMetadata.getPredecessor(right);
                for (int tok = 1; tok < DatabaseDescriptor.getNumTokens(); ++tok) {
                    Token l = left;
                    Token r = right;
                    double frac = (double)tok / (double)DatabaseDescriptor.getNumTokens().intValue();
                    Token midpoint = StorageService.getPartitioner().midpoint(l, r);
                    for (int i = 0; i < 53 && (frac *= 2.0) != 1.0; ++i) {
                        if (frac > 1.0) {
                            l = midpoint;
                            frac -= 1.0;
                        } else {
                            r = midpoint;
                        }
                        midpoint = StorageService.getPartitioner().midpoint(l, r);
                    }
                    tokens.add(midpoint);
                }
                logger.info("Split previous range (" + left + ", " + right + "] into " + tokens);
            } else {
                logger.info("Using saved token " + tokens);
            }
        }
        if (!this.isSurveyMode) {
            SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
            this.setTokens(tokens);
            if (!current.isEmpty()) {
                for (InetAddress inetAddress : current) {
                    Gossiper.instance.replacedEndpoint(inetAddress);
                }
            }
            logger.info("Startup completed! Now serving reads.");
            assert (this.tokenMetadata.sortedTokens().size() > 0);
            Auth.setup();
        } else {
            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
        }
    }

    public void gossipSnitchInfo() {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        String dc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
        String rack = snitch.getRack(FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(dc));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(rack));
    }

    @Override
    public synchronized void joinRing() throws IOException {
        if (!this.joined) {
            logger.info("Joining ring by operator request");
            try {
                this.joinTokenRing(0);
            }
            catch (ConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        } else if (this.isSurveyMode) {
            this.setTokens(SystemKeyspace.getSavedTokens());
            SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
            this.isSurveyMode = false;
            logger.info("Leaving write survey mode and joining ring at operator request");
            assert (this.tokenMetadata.sortedTokens().size() > 0);
            Auth.setup();
        }
    }

    @Override
    public boolean isJoined() {
        return this.joined;
    }

    @Override
    public void rebuild(String sourceDc) {
        logger.info("rebuild from dc: {}", (Object)(sourceDc == null ? "(any dc)" : sourceDc));
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, FBUtilities.getBroadcastAddress(), "Rebuild");
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        if (sourceDc != null) {
            streamer.addSourceFilter(new RangeStreamer.SingleDatacenterFilter(DatabaseDescriptor.getEndpointSnitch(), sourceDc));
        }
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            streamer.addRanges(keyspaceName, this.getLocalRanges(keyspaceName));
        }
        try {
            streamer.fetchAsync().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting on rebuild streaming");
        }
        catch (ExecutionException e) {
            logger.error("Error while rebuilding node", e.getCause());
            throw new RuntimeException("Error while rebuilding node: " + e.getCause().getMessage());
        }
    }

    @Override
    public void setStreamThroughputMbPerSec(int value) {
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(value);
        logger.info("setstreamthroughput: throttle set to {}", (Object)value);
    }

    @Override
    public int getStreamThroughputMbPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.getCompactionThroughputMbPerSec();
    }

    @Override
    public void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.setCompactionThroughputMbPerSec(value);
    }

    @Override
    public boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.isIncrementalBackupsEnabled();
    }

    @Override
    public void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.setIncrementalBackupsEnabled(value);
    }

    private void setMode(Mode m, boolean log) {
        this.setMode(m, null, log);
    }

    private void setMode(Mode m, String msg, boolean log) {
        String logMsg;
        this.operationMode = m;
        String string = logMsg = msg == null ? m.toString() : String.format("%s: %s", new Object[]{m, msg});
        if (log) {
            logger.info(logMsg);
        } else {
            logger.debug(logMsg);
        }
    }

    private void bootstrap(Collection<Token> tokens) {
        this.isBootstrapMode = true;
        SystemKeyspace.updateTokens(tokens);
        if (!DatabaseDescriptor.isReplacing()) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(tokens));
            Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.bootstrapping(tokens));
            this.setMode(Mode.JOINING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
            Uninterruptibles.sleepUninterruptibly((long)RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
        }
        if (!Gossiper.instance.seenAnySeed()) {
            throw new IllegalStateException("Unable to contact any seeds!");
        }
        this.setMode(Mode.JOINING, "Starting to bootstrap...", true);
        new BootStrapper(FBUtilities.getBroadcastAddress(), tokens, this.tokenMetadata).bootstrap();
        logger.info("Bootstrap completed! for the tokens {}", tokens);
    }

    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata;
    }

    public void reportSeverity(double incr) {
        bgMonitor.incrCompactionSeverity(incr);
    }

    public double getSeverity(InetAddress endpoint) {
        return bgMonitor.getSeverity(endpoint);
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(entry.getKey().asList(), this.stringify((Iterable<InetAddress>)entry.getValue()));
        }
        return map;
    }

    public String getRpcaddress(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return DatabaseDescriptor.getRpcAddress().getHostAddress();
        }
        if (Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.RPC_ADDRESS) == null) {
            return endpoint.getHostAddress();
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.RPC_ADDRESS).value;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            ArrayList<String> rpcaddrs = new ArrayList<String>(entry.getValue().size());
            for (InetAddress endpoint : entry.getValue()) {
                rpcaddrs.add(this.getRpcaddress(endpoint));
            }
            map.put(entry.getKey().asList(), rpcaddrs);
        }
        return map;
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemKeyspaces().get(0);
        }
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, Collection<InetAddress>> entry : this.tokenMetadata.getPendingRanges(keyspace).entrySet()) {
            ArrayList<InetAddress> l = new ArrayList<InetAddress>(entry.getValue());
            map.put(entry.getKey().asList(), this.stringify(l));
        }
        return map;
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemKeyspaces().get(0);
        }
        List<Range<Token>> ranges = this.getAllRanges(this.tokenMetadata.sortedTokens());
        return this.constructRangeToEndpointMap(keyspace, ranges);
    }

    @Override
    public List<String> describeRingJMX(String keyspace) throws IOException {
        List<TokenRange> tokenRanges;
        try {
            tokenRanges = this.describeRing(keyspace);
        }
        catch (InvalidRequestException e) {
            throw new IOException(e.getMessage());
        }
        ArrayList<String> result = new ArrayList<String>(tokenRanges.size());
        for (TokenRange tokenRange : tokenRanges) {
            result.add(tokenRange.toString());
        }
        return result;
    }

    public List<TokenRange> describeRing(String keyspace) throws InvalidRequestException {
        if (keyspace == null || Keyspace.open(keyspace).getReplicationStrategy() instanceof LocalStrategy) {
            throw new InvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            Range<Token> range = entry.getKey();
            List<InetAddress> addresses = entry.getValue();
            ArrayList<String> endpoints = new ArrayList<String>(addresses.size());
            ArrayList<String> rpc_endpoints = new ArrayList<String>(addresses.size());
            ArrayList<EndpointDetails> epDetails = new ArrayList<EndpointDetails>(addresses.size());
            for (InetAddress endpoint : addresses) {
                EndpointDetails details = new EndpointDetails();
                details.host = endpoint.getHostAddress();
                details.datacenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(endpoint);
                details.rack = DatabaseDescriptor.getEndpointSnitch().getRack(endpoint);
                endpoints.add(details.host);
                rpc_endpoints.add(this.getRpcaddress(endpoint));
                epDetails.add(details);
            }
            TokenRange tr = new TokenRange(tf.toString(range.left.getToken()), tf.toString(range.right.getToken()), endpoints).setEndpoint_details(epDetails).setRpc_endpoints(rpc_endpoints);
            ranges.add(tr);
        }
        return ranges;
    }

    @Override
    public Map<String, String> getTokenToEndpointMap() {
        Map<Token, InetAddress> mapInetAddress = this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap();
        LinkedHashMap<String, String> mapString = new LinkedHashMap<String, String>(mapInetAddress.size());
        ArrayList<Token> tokens = new ArrayList<Token>(mapInetAddress.keySet());
        Collections.sort(tokens);
        for (Token token : tokens) {
            mapString.put(token.toString(), mapInetAddress.get(token).getHostAddress());
        }
        return mapString;
    }

    @Override
    public String getLocalHostId() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddress()).toString();
    }

    @Override
    public Map<String, String> getHostIdMap() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddress, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getKey().getHostAddress(), entry.getValue().toString());
        }
        return mapOut;
    }

    private Map<Range<Token>, List<InetAddress>> constructRangeToEndpointMap(String keyspace, List<Range<Token>> ranges) {
        HashMap<Range<Token>, List<InetAddress>> rangeToEndpointMap = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            rangeToEndpointMap.put(range, Keyspace.open(keyspace).getReplicationStrategy().getNaturalEndpoints(range.right));
        }
        return rangeToEndpointMap;
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        switch (state) {
            case STATUS: {
                String apStateValue = value.value;
                String[] pieces = apStateValue.split(VersionedValue.DELIMITER_STR, -1);
                assert (pieces.length > 0);
                String moveName = pieces[0];
                if (moveName.equals("BOOT")) {
                    this.handleStateBootstrap(endpoint, pieces);
                    break;
                }
                if (moveName.equals("NORMAL")) {
                    this.handleStateNormal(endpoint, pieces);
                    break;
                }
                if (moveName.equals("removing") || moveName.equals("removed")) {
                    this.handleStateRemoving(endpoint, pieces);
                    break;
                }
                if (moveName.equals("LEAVING")) {
                    this.handleStateLeaving(endpoint, pieces);
                    break;
                }
                if (moveName.equals("LEFT")) {
                    this.handleStateLeft(endpoint, pieces);
                    break;
                }
                if (moveName.equals("MOVING")) {
                    this.handleStateMoving(endpoint, pieces);
                    break;
                }
                if (!moveName.equals("RELOCATING")) break;
                this.handleStateRelocating(endpoint, pieces);
                break;
            }
            case RELEASE_VERSION: {
                SystemKeyspace.updatePeerInfo(endpoint, "release_version", this.quote(value.value));
                break;
            }
            case DC: {
                SystemKeyspace.updatePeerInfo(endpoint, "data_center", this.quote(value.value));
                break;
            }
            case RACK: {
                SystemKeyspace.updatePeerInfo(endpoint, "rack", this.quote(value.value));
                break;
            }
            case RPC_ADDRESS: {
                SystemKeyspace.updatePeerInfo(endpoint, "rpc_address", this.quote(value.value));
                break;
            }
            case SCHEMA: {
                SystemKeyspace.updatePeerInfo(endpoint, "schema_version", value.value);
                break;
            }
            case HOST_ID: {
                SystemKeyspace.updatePeerInfo(endpoint, "host_id", value.value);
            }
        }
    }

    private String quote(String value) {
        return "'" + value + "'";
    }

    private byte[] getApplicationStateValue(InetAddress endpoint, ApplicationState appstate) {
        String vvalue = Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)appstate).value;
        return vvalue.getBytes(Charsets.ISO_8859_1);
    }

    private Collection<Token> getTokensFor(InetAddress endpoint, String piece) {
        if (Gossiper.instance.usesVnodes(endpoint)) {
            try {
                return TokenSerializer.deserialize(StorageService.getPartitioner(), new DataInputStream(new ByteArrayInputStream(this.getApplicationStateValue(endpoint, ApplicationState.TOKENS))));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Arrays.asList(StorageService.getPartitioner().getTokenFactory().fromString(piece));
    }

    private void handleStateBootstrap(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state bootstrapping, token " + tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            if (!this.tokenMetadata.isLeaving(endpoint)) {
                logger.info("Node " + endpoint + " state jump to bootstrap");
            }
            this.tokenMetadata.removeEndpoint(endpoint);
        }
        this.tokenMetadata.addBootstrapTokens(tokens, endpoint);
        this.calculatePendingRanges();
        if (Gossiper.instance.usesHostId(endpoint)) {
            this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(endpoint), endpoint);
        }
    }

    private void handleStateNormal(final InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state normal, token " + tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node " + endpoint + " state jump to normal");
        }
        if (Gossiper.instance.usesHostId(endpoint)) {
            this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(endpoint), endpoint);
        }
        HashSet<Token> tokensToUpdateInMetadata = new HashSet<Token>();
        HashSet<Token> tokensToUpdateInSystemKeyspace = new HashSet<Token>();
        HashSet<Token> localTokensToRemove = new HashSet<Token>();
        HashSet<InetAddress> endpointsToRemove = new HashSet<InetAddress>();
        Multimap<InetAddress, Token> epToTokenCopy = this.getTokenMetadata().getEndpointToTokenMapForReading();
        for (final Token token : tokens) {
            InetAddress currentOwner = this.tokenMetadata.getEndpoint(token);
            if (currentOwner == null) {
                logger.debug("New node " + endpoint + " at token " + token);
                tokensToUpdateInMetadata.add(token);
                if (this.isClientMode) continue;
                tokensToUpdateInSystemKeyspace.add(token);
                continue;
            }
            if (endpoint.equals(currentOwner)) {
                tokensToUpdateInMetadata.add(token);
                continue;
            }
            if (this.tokenMetadata.isRelocating(token) && this.tokenMetadata.getRelocatingRanges().get(token).equals(endpoint)) {
                tokensToUpdateInMetadata.add(token);
                if (!this.isClientMode) {
                    tokensToUpdateInSystemKeyspace.add(token);
                }
                optionalTasks.schedule(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Removing RELOCATION state for {} {}", (Object)endpoint, (Object)token);
                        StorageService.this.getTokenMetadata().removeFromRelocating(token, endpoint);
                    }
                }, (long)RING_DELAY, TimeUnit.MILLISECONDS);
                if (currentOwner.equals(FBUtilities.getBroadcastAddress())) {
                    localTokensToRemove.add(token);
                }
                logger.info("Token {} relocated to {}", (Object)token, (Object)endpoint);
                continue;
            }
            if (this.tokenMetadata.isRelocating(token)) {
                logger.info("Token {} is relocating to {}, ignoring update from {}", new Object[]{token, this.tokenMetadata.getRelocatingRanges().get(token), endpoint});
                continue;
            }
            if (Gossiper.instance.compareEndpointStartup(endpoint, currentOwner) > 0) {
                tokensToUpdateInMetadata.add(token);
                if (!this.isClientMode) {
                    tokensToUpdateInSystemKeyspace.add(token);
                }
                epToTokenCopy.get((Object)currentOwner).remove(token);
                if (epToTokenCopy.get((Object)currentOwner).size() < 1) {
                    endpointsToRemove.add(currentOwner);
                }
                logger.info(String.format("Nodes %s and %s have the same token %s.  %s is the new owner", endpoint, currentOwner, token, endpoint));
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Relocating ranges: {}", (Object)this.tokenMetadata.printRelocatingRanges());
                continue;
            }
            logger.info(String.format("Nodes %s and %s have the same token %s.  Ignoring %s", endpoint, currentOwner, token, endpoint));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Relocating ranges: {}", (Object)this.tokenMetadata.printRelocatingRanges());
        }
        this.tokenMetadata.updateNormalTokens(tokensToUpdateInMetadata, endpoint);
        for (InetAddress ep : endpointsToRemove) {
            this.removeEndpoint(ep);
        }
        if (!tokensToUpdateInSystemKeyspace.isEmpty()) {
            SystemKeyspace.updateTokens(endpoint, tokensToUpdateInSystemKeyspace);
        }
        if (!localTokensToRemove.isEmpty()) {
            SystemKeyspace.updateLocalTokens(Collections.emptyList(), localTokensToRemove);
        }
        if (this.tokenMetadata.isMoving(endpoint)) {
            this.tokenMetadata.removeFromMoving(endpoint);
            if (!this.isClientMode) {
                for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                    subscriber.onMove(endpoint);
                }
            }
        }
        this.calculatePendingRanges();
    }

    private void handleStateLeaving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state leaving, tokens " + tokens);
        }
        if (!this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node " + endpoint + " state jump to leaving");
            this.tokenMetadata.updateNormalTokens(tokens, endpoint);
        } else if (!this.tokenMetadata.getTokens(endpoint).containsAll(tokens)) {
            logger.warn("Node " + endpoint + " 'leaving' token mismatch. Long network partition?");
            this.tokenMetadata.updateNormalTokens(tokens, endpoint);
        }
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateLeft(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state left, tokens " + tokens);
        }
        this.excise(tokens, endpoint, this.extractExpireTime(pieces));
    }

    private void handleStateMoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state moving, new token " + token);
        }
        this.tokenMetadata.addMovingEndpoint(token, endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateRelocating(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        ArrayList<Token> tokens = new ArrayList<Token>(pieces.length - 1);
        for (String tStr : Arrays.copyOfRange(pieces, 1, pieces.length)) {
            tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(tStr));
        }
        logger.debug("Tokens {} are relocating to {}", tokens, (Object)endpoint);
        this.tokenMetadata.addRelocatingTokens(tokens, endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateRemoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length > 0);
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            logger.info("Received removeToken gossip about myself. Is this node rejoining after an explicit removetoken?");
            try {
                this.drain();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            String state = pieces[0];
            Collection<Token> removeTokens = this.tokenMetadata.getTokens(endpoint);
            if ("removed".equals(state)) {
                this.excise(removeTokens, endpoint, this.extractExpireTime(pieces));
            } else if ("removing".equals(state)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Tokens " + removeTokens + " removed manually (endpoint was " + endpoint + ")");
                }
                this.tokenMetadata.addLeavingEndpoint(endpoint);
                this.calculatePendingRanges();
                String[] coordinator = Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.REMOVAL_COORDINATOR).value.split(VersionedValue.DELIMITER_STR, -1);
                UUID hostId = UUID.fromString(coordinator[1]);
                this.restoreReplicaCount(endpoint, this.tokenMetadata.getEndpointForHostId(hostId));
            }
        } else {
            this.addExpireTimeIfFound(endpoint, this.extractExpireTime(pieces));
            this.removeEndpoint(endpoint);
        }
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint) {
        logger.info("Removing tokens " + tokens + " for " + endpoint);
        HintedHandOffManager.instance.deleteHintsForEndpoint(endpoint);
        this.removeEndpoint(endpoint);
        this.tokenMetadata.removeEndpoint(endpoint);
        this.tokenMetadata.removeBootstrapTokens(tokens);
        if (!this.isClientMode) {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onLeaveCluster(endpoint);
            }
        }
        this.calculatePendingRanges();
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint, long expireTime) {
        this.addExpireTimeIfFound(endpoint, expireTime);
        this.excise(tokens, endpoint);
    }

    private void removeEndpoint(InetAddress endpoint) {
        Gossiper.instance.removeEndpoint(endpoint);
        if (!this.isClientMode) {
            SystemKeyspace.removeEndpoint(endpoint);
        }
    }

    protected void addExpireTimeIfFound(InetAddress endpoint, long expireTime) {
        if (expireTime != 0L) {
            Gossiper.instance.addExpireTimeForEndpoint(endpoint, expireTime);
        }
    }

    protected long extractExpireTime(String[] pieces) {
        return Long.parseLong(pieces[2]);
    }

    private void calculatePendingRanges() {
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            StorageService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        InetAddress endpoint;
        TokenMetadata tm = instance.getTokenMetadata();
        HashMultimap pendingRanges = HashMultimap.create();
        BiMultiValMap<Token, InetAddress> bootstrapTokens = tm.getBootstrapTokens();
        Set<InetAddress> leavingEndpoints = tm.getLeavingEndpoints();
        if (bootstrapTokens.isEmpty() && leavingEndpoints.isEmpty() && tm.getMovingEndpoints().isEmpty() && tm.getRelocatingRanges().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("No bootstrapping, leaving or moving nodes, and no relocating tokens -> empty pending ranges for {}", (Object)keyspaceName);
            }
            tm.setPendingRanges(keyspaceName, (Multimap<Range<Token>, InetAddress>)pendingRanges);
            return;
        }
        Multimap<InetAddress, Range<Token>> addressRanges = strategy.getAddressRanges();
        TokenMetadata allLeftMetadata = tm.cloneAfterAllLeft();
        HashSet affectedRanges = new HashSet();
        for (InetAddress inetAddress : leavingEndpoints) {
            affectedRanges.addAll(addressRanges.get((Object)inetAddress));
        }
        for (Range range : affectedRanges) {
            ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, tm.cloneOnlyTokenMap()));
            ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
            pendingRanges.putAll((Object)range, (Iterable)Sets.difference((Set)newEndpoints, (Set)currentEndpoints));
        }
        for (InetAddress inetAddress : bootstrapTokens.inverse().keySet()) {
            Collection tokens = bootstrapTokens.inverse().get((Object)inetAddress);
            allLeftMetadata.updateNormalTokens(tokens, inetAddress);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)inetAddress)) {
                pendingRanges.put((Object)range, (Object)inetAddress);
            }
            allLeftMetadata.removeEndpoint(inetAddress);
        }
        for (Pair pair : tm.getMovingEndpoints()) {
            endpoint = (InetAddress)pair.right;
            allLeftMetadata.updateNormalToken((Token)pair.left, endpoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                pendingRanges.put((Object)range, (Object)endpoint);
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        for (Map.Entry entry : tm.getRelocatingRanges().entrySet()) {
            endpoint = (InetAddress)entry.getValue();
            Token token = (Token)entry.getKey();
            allLeftMetadata.updateNormalToken(token, endpoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                pendingRanges.put((Object)range, (Object)endpoint);
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        tm.setPendingRanges(keyspaceName, (Multimap<Range<Token>, InetAddress>)pendingRanges);
        if (logger.isDebugEnabled()) {
            logger.debug("Pending ranges:\n" + (pendingRanges.isEmpty() ? "<empty>" : tm.printPendingRanges()));
        }
    }

    private Multimap<InetAddress, Range<Token>> getNewSourceRanges(String keyspaceName, Set<Range<Token>> ranges) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        Multimap<Range<Token>, InetAddress> rangeAddresses = Keyspace.open(keyspaceName).getReplicationStrategy().getRangeAddresses(this.tokenMetadata.cloneOnlyTokenMap());
        HashMultimap sourceRanges = HashMultimap.create();
        IFailureDetector failureDetector = FailureDetector.instance;
        block0: for (Range<Token> range : ranges) {
            Collection possibleRanges = rangeAddresses.get(range);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            List<InetAddress> sources = snitch.getSortedListByProximity(myAddress, possibleRanges);
            assert (!sources.contains(myAddress));
            for (InetAddress source : sources) {
                if (!failureDetector.isAlive(source)) continue;
                sourceRanges.put((Object)source, range);
                continue block0;
            }
        }
        return sourceRanges;
    }

    private void sendReplicationNotification(InetAddress remote) {
        MessageOut msg = new MessageOut(MessagingService.Verb.REPLICATION_FINISHED);
        IFailureDetector failureDetector = FailureDetector.instance;
        if (logger.isDebugEnabled()) {
            logger.debug("Notifying " + remote.toString() + " of replication completion\n");
        }
        while (failureDetector.isAlive(remote)) {
            AsyncOneResponse iar = MessagingService.instance().sendRR(msg, remote);
            try {
                iar.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
            }
        }
    }

    private void restoreReplicaCount(InetAddress endpoint, final InetAddress notifyEndpoint) {
        HashMultimap rangesToFetch = HashMultimap.create();
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(keyspaceName, endpoint);
            HashSet<Range<Token>> myNewRanges = new HashSet<Range<Token>>();
            for (Map.Entry entry : changedRanges.entries()) {
                if (!((InetAddress)entry.getValue()).equals(myAddress)) continue;
                myNewRanges.add((Range<Token>)entry.getKey());
            }
            Multimap<InetAddress, Range<Token>> sourceRanges = this.getNewSourceRanges(keyspaceName, myNewRanges);
            for (Map.Entry entry : sourceRanges.asMap().entrySet()) {
                rangesToFetch.put((Object)keyspaceName, entry);
            }
        }
        StreamPlan stream = new StreamPlan("Restore replica count");
        for (String keyspaceName : rangesToFetch.keySet()) {
            for (Map.Entry entry : rangesToFetch.get((Object)keyspaceName)) {
                InetAddress source = (InetAddress)entry.getKey();
                Collection ranges = (Collection)entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting from " + source + " ranges " + StringUtils.join((Collection)ranges, (String)", "));
                }
                stream.requestRanges(source, keyspaceName, ranges);
            }
        }
        StreamResultFuture future = stream.execute();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<StreamState>(){

            public void onSuccess(StreamState finalState) {
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }

            public void onFailure(Throwable t) {
                logger.warn("Streaming to restore replica count failed", t);
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }
        });
    }

    private Multimap<Range<Token>, InetAddress> getChangedRangesForLeaving(String keyspaceName, InetAddress endpoint) {
        Collection<Range<Token>> ranges = this.getRangesForEndpoint(keyspaceName, endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " ranges [" + StringUtils.join(ranges, (String)", ") + "]");
        }
        HashMap<Range<Token>, List<InetAddress>> currentReplicaEndpoints = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            currentReplicaEndpoints.put(range, Keyspace.open(keyspaceName).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, this.tokenMetadata.cloneOnlyTokenMap()));
        }
        TokenMetadata temp = this.tokenMetadata.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        HashMultimap changedRanges = HashMultimap.create();
        for (Range<Token> range : ranges) {
            List<InetAddress> newReplicaEndpoints = Keyspace.open(keyspaceName).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, temp);
            newReplicaEndpoints.removeAll((Collection)currentReplicaEndpoints.get(range));
            if (logger.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger.debug("Range " + range + " already in all replicas");
                } else {
                    logger.debug("Range " + range + " will be responsibility of " + StringUtils.join(newReplicaEndpoints, (String)", "));
                }
            }
            changedRanges.putAll(range, newReplicaEndpoints);
        }
        return changedRanges;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.getApplicationStateMap().entrySet()) {
            this.onChange(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (this.isClientMode) {
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            HintedHandOffManager.instance.scheduleHintDelivery(endpoint);
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onUp(endpoint);
            }
        } else {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onJoinCluster(endpoint);
            }
        }
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.tokenMetadata.removeEndpoint(endpoint);
        this.calculatePendingRanges();
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
        MessagingService.instance().convict(endpoint);
        if (!this.isClientMode) {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onDown(endpoint);
            }
        }
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        if (state.isAlive()) {
            this.onDead(endpoint, state);
        }
    }

    @Override
    public double getLoad() {
        double bytes = 0.0;
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            Keyspace keyspace = Keyspace.open(keyspaceName);
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                bytes += (double)cfs.getLiveDiskSpaceUsed();
            }
        }
        return bytes;
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(this.getLoad());
    }

    @Override
    public Map<String, String> getLoadMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddress, Double> entry : LoadBroadcaster.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getBroadcastAddress().getHostAddress(), this.getLoadString());
        return map;
    }

    @Override
    public final void deliverHints(String host) throws UnknownHostException {
        HintedHandOffManager.instance.scheduleHintDelivery(host);
    }

    public Collection<Token> getLocalTokens() {
        Collection<Token> tokens = SystemKeyspace.getSavedTokens();
        assert (tokens != null && !tokens.isEmpty());
        return tokens;
    }

    @Override
    public List<String> getTokens() {
        return this.getTokens(FBUtilities.getBroadcastAddress());
    }

    @Override
    public List<String> getTokens(String endpoint) throws UnknownHostException {
        return this.getTokens(InetAddress.getByName(endpoint));
    }

    private List<String> getTokens(InetAddress endpoint) {
        ArrayList<String> strTokens = new ArrayList<String>();
        for (Token tok : this.getTokenMetadata().getTokens(endpoint)) {
            strTokens.add(tok.toString());
        }
        return strTokens;
    }

    @Override
    public String getReleaseVersion() {
        return FBUtilities.getReleaseVersionString();
    }

    @Override
    public String getSchemaVersion() {
        return Schema.instance.getVersion().toString();
    }

    @Override
    public List<String> getLeavingNodes() {
        return this.stringify(this.tokenMetadata.getLeavingEndpoints());
    }

    @Override
    public List<String> getMovingNodes() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddress> node : this.tokenMetadata.getMovingEndpoints()) {
            endpoints.add(((InetAddress)node.right).getHostAddress());
        }
        return endpoints;
    }

    @Override
    public List<String> getJoiningNodes() {
        return this.stringify(this.tokenMetadata.getBootstrapTokens().values());
    }

    @Override
    public List<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers());
    }

    @Override
    public List<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers());
    }

    @Override
    public String[] getAllDataFileLocations() {
        String[] locations = DatabaseDescriptor.getAllDataFileLocations();
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = FileUtils.getCanonicalPath(locations[i]);
        }
        return locations;
    }

    @Override
    public String getCommitLogLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getCommitLogLocation());
    }

    @Override
    public String getSavedCachesLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getSavedCachesLocation());
    }

    private List<String> stringify(Iterable<InetAddress> endpoints) {
        ArrayList<String> stringEndpoints = new ArrayList<String>();
        for (InetAddress ep : endpoints) {
            stringEndpoints.add(ep.getHostAddress());
        }
        return stringEndpoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getBroadcastAddress());
    }

    @Override
    public void forceKeyspaceCleanup(String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        if (keyspaceName.equals("system")) {
            throw new RuntimeException("Cleanup of the system keyspace is neither necessary nor wise");
        }
        CounterId.OneShotRenewer counterIdRenewer = new CounterId.OneShotRenewer();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, columnFamilies)) {
            cfStore.forceCleanup(counterIdRenewer);
        }
    }

    @Override
    public void scrub(String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, columnFamilies)) {
            cfStore.scrub();
        }
    }

    @Override
    public void upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, true, keyspaceName, columnFamilies)) {
            cfStore.sstablesRewrite(excludeCurrentVersion);
        }
    }

    @Override
    public void forceKeyspaceCompaction(String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, columnFamilies)) {
            cfStore.forceMajorCompaction();
        }
    }

    @Override
    public void takeSnapshot(String tag, String ... keyspaceNames) throws IOException {
        Iterable<Keyspace> keyspaces;
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        if (keyspaceNames.length == 0) {
            keyspaces = Keyspace.all();
        } else {
            ArrayList<Keyspace> t = new ArrayList<Keyspace>(keyspaceNames.length);
            for (String keyspaceName : keyspaceNames) {
                t.add(this.getValidKeyspace(keyspaceName));
            }
            keyspaces = t;
        }
        for (Keyspace keyspace : keyspaces) {
            if (!keyspace.snapshotExists(tag)) continue;
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        for (Keyspace keyspace : keyspaces) {
            keyspace.snapshot(tag, null);
        }
    }

    @Override
    public void takeColumnFamilySnapshot(String keyspaceName, String columnFamilyName, String tag) throws IOException {
        if (keyspaceName == null) {
            throw new IOException("You must supply a keyspace name");
        }
        if (columnFamilyName == null) {
            throw new IOException("You must supply a column family name");
        }
        if (columnFamilyName.contains(".")) {
            throw new IllegalArgumentException("Cannot take a snapshot of a secondary index by itself. Run snapshot on the column family that owns the index.");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        Keyspace keyspace = this.getValidKeyspace(keyspaceName);
        if (keyspace.snapshotExists(tag)) {
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        keyspace.snapshot(tag, columnFamilyName);
    }

    private Keyspace getValidKeyspace(String keyspaceName) throws IOException {
        if (!Schema.instance.getKeyspaces().contains(keyspaceName)) {
            throw new IOException("Keyspace " + keyspaceName + " does not exist");
        }
        return Keyspace.open(keyspaceName);
    }

    @Override
    public void clearSnapshot(String tag, String ... keyspaceNames) throws IOException {
        Iterable<Keyspace> keyspaces;
        if (tag == null) {
            tag = "";
        }
        if (keyspaceNames.length == 0) {
            keyspaces = Keyspace.all();
        } else {
            ArrayList<Keyspace> tempKeyspaces = new ArrayList<Keyspace>(keyspaceNames.length);
            for (String keyspaceName : keyspaceNames) {
                tempKeyspaces.add(this.getValidKeyspace(keyspaceName));
            }
            keyspaces = tempKeyspaces;
        }
        for (Keyspace keyspace : keyspaces) {
            keyspace.clearSnapshot(tag);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared out snapshot directories");
        }
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String keyspaceName, String ... cfNames) throws IOException {
        Keyspace keyspace = this.getValidKeyspace(keyspaceName);
        if (cfNames.length == 0) {
            return keyspace.getColumnFamilyStores();
        }
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        String[] arr$ = cfNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ColumnFamilyStore cfStore;
            String cfName;
            String baseCfName = cfName = arr$[i$];
            String idxName = null;
            if (cfName.contains(".")) {
                if (!allowIndexes) {
                    logger.warn("Operation not allowed on secondary Index column family ({})", (Object)cfName);
                    continue;
                }
                String[] parts = cfName.split("\\.", 2);
                baseCfName = parts[0];
                idxName = parts[1];
            }
            if ((cfStore = keyspace.getColumnFamilyStore(baseCfName)) == null) {
                logger.warn(String.format("Invalid column family specified: %s. Proceeding with others.", baseCfName));
                continue;
            }
            if (idxName != null) {
                Collection<SecondaryIndex> indexes = cfStore.indexManager.getIndexesByNames(new HashSet<String>(Arrays.asList(cfName)));
                if (indexes.isEmpty()) {
                    logger.warn(String.format("Invalid column family index specified: %s/%s. Proceeding with others.", baseCfName, idxName));
                    continue;
                }
                valid.add(((SecondaryIndex)Iterables.get(indexes, (int)0)).getIndexCfs());
                continue;
            }
            valid.add(cfStore);
            if (!autoAddIndexes) continue;
            for (SecondaryIndex si : cfStore.indexManager.getIndexes()) {
                logger.info("adding secondary index {} to operation", (Object)si.getIndexName());
                valid.add(si.getIndexCfs());
            }
        }
        return valid;
    }

    @Override
    public void forceKeyspaceFlush(String keyspaceName, String ... columnFamilies) throws IOException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, columnFamilies)) {
            logger.debug("Forcing flush on keyspace " + keyspaceName + ", CF " + cfStore.name);
            cfStore.forceBlockingFlush();
        }
    }

    public void sendNotification(String type, String message, Object userObject) {
        Notification jmxNotification = new Notification(type, (Object)this.jmxObjectName, this.notificationSerialNumber.incrementAndGet(), message);
        jmxNotification.setUserData(userObject);
        this.sendNotification(jmxNotification);
    }

    @Override
    public int forceRepairAsync(String keyspace, boolean isSequential, boolean isLocal, boolean primaryRange, String ... columnFamilies) {
        Collection<Range<Token>> ranges = primaryRange ? this.getLocalPrimaryRanges(keyspace) : this.getLocalRanges(keyspace);
        return this.forceRepairAsync(keyspace, isSequential, isLocal, ranges, columnFamilies);
    }

    public int forceRepairAsync(String keyspace, boolean isSequential, boolean isLocal, Collection<Range<Token>> ranges, String ... columnFamilies) {
        if ("system".equals(keyspace) || "system_traces".equals(keyspace) || ranges.isEmpty()) {
            return 0;
        }
        int cmd = nextRepairCommand.incrementAndGet();
        if (ranges.size() > 0) {
            new Thread(this.createRepairTask(cmd, keyspace, ranges, isSequential, isLocal, columnFamilies)).start();
        }
        return cmd;
    }

    @Override
    public int forceRepairRangeAsync(String beginToken, String endToken, String keyspaceName, boolean isSequential, boolean isLocal, String ... columnFamilies) {
        Token parsedBeginToken = StorageService.getPartitioner().getTokenFactory().fromString(beginToken);
        Token parsedEndToken = StorageService.getPartitioner().getTokenFactory().fromString(endToken);
        logger.info("starting user-requested repair of range ({}, {}] for keyspace {} and column families {}", new Object[]{parsedBeginToken, parsedEndToken, keyspaceName, columnFamilies});
        return this.forceRepairAsync(keyspaceName, isSequential, isLocal, Collections.singleton(new Range(parsedBeginToken, parsedEndToken)), columnFamilies);
    }

    @Override
    public void forceKeyspaceRepair(String keyspaceName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        this.forceKeyspaceRepairRange(keyspaceName, this.getLocalRanges(keyspaceName), isSequential, isLocal, columnFamilies);
    }

    @Override
    public void forceKeyspaceRepairPrimaryRange(String keyspaceName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        this.forceKeyspaceRepairRange(keyspaceName, this.getLocalPrimaryRanges(keyspaceName), isSequential, isLocal, columnFamilies);
    }

    @Override
    public void forceKeyspaceRepairRange(String beginToken, String endToken, String keyspaceName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        Token parsedBeginToken = StorageService.getPartitioner().getTokenFactory().fromString(beginToken);
        Token parsedEndToken = StorageService.getPartitioner().getTokenFactory().fromString(endToken);
        logger.info("starting user-requested repair of range ({}, {}] for keyspace {} and column families {}", new Object[]{parsedBeginToken, parsedEndToken, keyspaceName, columnFamilies});
        this.forceKeyspaceRepairRange(keyspaceName, Collections.singleton(new Range(parsedBeginToken, parsedEndToken)), isSequential, isLocal, columnFamilies);
    }

    public void forceKeyspaceRepairRange(String keyspaceName, Collection<Range<Token>> ranges, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        if (Schema.systemKeyspaceNames.contains((Object)keyspaceName)) {
            return;
        }
        this.createRepairTask(nextRepairCommand.incrementAndGet(), keyspaceName, ranges, isSequential, isLocal, columnFamilies).run();
    }

    private FutureTask<Object> createRepairTask(final int cmd, final String keyspace, final Collection<Range<Token>> ranges, final boolean isSequential, final boolean isLocal, final String ... columnFamilies) {
        return new FutureTask<Object>(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                String message = String.format("Starting repair command #%d, repairing %d ranges for keyspace %s", cmd, ranges.size(), keyspace);
                logger.info(message);
                StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.STARTED.ordinal()});
                ArrayList<RepairFuture> futures = new ArrayList<RepairFuture>(ranges.size());
                for (Range range : ranges) {
                    RepairFuture future;
                    try {
                        future = StorageService.this.forceKeyspaceRepair(range, keyspace, isSequential, isLocal, columnFamilies);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Repair session failed:", (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.SESSION_FAILED.ordinal()});
                        continue;
                    }
                    if (future == null) continue;
                    futures.add(future);
                    try {
                        future.session.differencingDone.await();
                    }
                    catch (InterruptedException e) {
                        message = "Interrupted while waiting for the differencing of repair session " + future.session + " to be done. Repair may be imprecise.";
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.SESSION_FAILED.ordinal()});
                    }
                }
                for (RepairFuture future : futures) {
                    try {
                        future.get();
                        message = String.format("Repair session %s for range %s finished", future.session.getId(), future.session.getRange().toString());
                        logger.info(message);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.SESSION_SUCCESS.ordinal()});
                    }
                    catch (ExecutionException e) {
                        message = String.format("Repair session %s for range %s failed with error %s", future.session.getId(), future.session.getRange().toString(), e.getCause().getMessage());
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.SESSION_FAILED.ordinal()});
                    }
                    catch (Exception e) {
                        message = String.format("Repair session %s for range %s failed with error %s", future.session.getId(), future.session.getRange().toString(), e.getMessage());
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, ActiveRepairService.Status.SESSION_FAILED.ordinal()});
                    }
                }
                StorageService.this.sendNotification("repair", String.format("Repair command #%d finished", cmd), new int[]{cmd, ActiveRepairService.Status.FINISHED.ordinal()});
            }
        }, null);
    }

    public RepairFuture forceKeyspaceRepair(Range<Token> range, String keyspaceName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, columnFamilies)) {
            names.add(cfStore.name);
        }
        if (names.isEmpty()) {
            logger.info("No column family to repair for keyspace " + keyspaceName);
            return null;
        }
        return ActiveRepairService.instance.submitRepairSession(range, keyspaceName, isSequential, isLocal, names.toArray(new String[names.size()]));
    }

    @Override
    public void forceTerminateAllRepairSessions() {
        ActiveRepairService.instance.terminateSessions();
    }

    public Collection<Range<Token>> getPrimaryRangesForEndpoint(String keyspace, InetAddress ep) {
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> primaryRanges = new HashSet<Range<Token>>();
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        for (Token token : metadata.sortedTokens()) {
            List<InetAddress> endpoints = strategy.calculateNaturalEndpoints(token, metadata);
            if (endpoints.size() <= 0 || !endpoints.get(0).equals(ep)) continue;
            primaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
        }
        return primaryRanges;
    }

    @Deprecated
    @VisibleForTesting
    public Range<Token> getPrimaryRangeForEndpoint(InetAddress ep) {
        return this.tokenMetadata.getPrimaryRangeFor(this.tokenMetadata.getToken(ep));
    }

    Collection<Range<Token>> getRangesForEndpoint(String keyspaceName, InetAddress ep) {
        return Keyspace.open(keyspaceName).getReplicationStrategy().getAddressRanges().get((Object)ep);
    }

    public List<Range<Token>> getAllRanges(List<Token> sortedTokens) {
        if (logger.isDebugEnabled()) {
            logger.debug("computing ranges for " + StringUtils.join(sortedTokens, (String)", "));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int size = sortedTokens.size();
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(size + 1);
        for (int i = 1; i < size; ++i) {
            Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, String cf, String key) {
        CFMetaData cfMetaData = Schema.instance.getKSMetaData(keyspaceName).cfMetaData().get(cf);
        return this.getNaturalEndpoints(keyspaceName, (RingPosition)StorageService.getPartitioner().getToken(cfMetaData.getKeyValidator().fromString(key)));
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, ByteBuffer key) {
        return this.getNaturalEndpoints(keyspaceName, (RingPosition)StorageService.getPartitioner().getToken(key));
    }

    public List<InetAddress> getNaturalEndpoints(String keyspaceName, RingPosition pos) {
        return Keyspace.open(keyspaceName).getReplicationStrategy().getNaturalEndpoints(pos);
    }

    public List<InetAddress> getLiveNaturalEndpoints(Keyspace keyspace, ByteBuffer key) {
        return this.getLiveNaturalEndpoints(keyspace, StorageService.getPartitioner().decorateKey(key));
    }

    public List<InetAddress> getLiveNaturalEndpoints(Keyspace keyspace, RingPosition pos) {
        ArrayList<InetAddress> endpoints = keyspace.getReplicationStrategy().getNaturalEndpoints(pos);
        ArrayList<InetAddress> liveEps = new ArrayList<InetAddress>(endpoints.size());
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
        return liveEps;
    }

    @Override
    public void setLog4jLevel(String classQualifier, String rawLevel) {
        Level level = Level.toLevel((String)rawLevel);
        org.apache.log4j.Logger.getLogger((String)classQualifier).setLevel(level);
        logger.info("set log level to " + level + " for classes under '" + classQualifier + "' (if the level doesn't look like '" + rawLevel + "' then log4j couldn't parse '" + rawLevel + "')");
    }

    public List<Pair<Range<Token>, Long>> getSplits(String keyspaceName, String cfName, Range<Token> range, int keysPerSplit, CFMetaData metadata) {
        Keyspace t = Keyspace.open(keyspaceName);
        ColumnFamilyStore cfs = t.getColumnFamilyStore(cfName);
        List<DecoratedKey> keys = this.keySamples(Collections.singleton(cfs), range);
        long totalRowCountEstimate = (keys.size() + 1) * metadata.getIndexInterval();
        int minSamplesPerSplit = 4;
        int maxSplitCount = keys.size() / 4 + 1;
        int splitCount = Math.max(1, Math.min(maxSplitCount, (int)(totalRowCountEstimate / (long)keysPerSplit)));
        List<Token> tokens = this.keysToTokens(range, keys);
        return this.getSplits(tokens, splitCount, metadata);
    }

    private List<Pair<Range<Token>, Long>> getSplits(List<Token> tokens, int splitCount, CFMetaData metadata) {
        double step = (double)(tokens.size() - 1) / (double)splitCount;
        int prevIndex = 0;
        Token prevToken = tokens.get(0);
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)splitCount);
        for (int i = 1; i <= splitCount; ++i) {
            int index = (int)Math.round((double)i * step);
            Token token = tokens.get(index);
            long rowCountEstimate = (index - prevIndex) * metadata.getIndexInterval();
            splits.add(Pair.create(new Range<Token>(prevToken, token), rowCountEstimate));
            prevIndex = index;
            prevToken = token;
        }
        return splits;
    }

    private List<Token> keysToTokens(Range<Token> range, List<DecoratedKey> keys) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)(keys.size() + 2));
        tokens.add(range.left);
        for (DecoratedKey key : keys) {
            tokens.add(key.token);
        }
        tokens.add(range.right);
        return tokens;
    }

    private List<DecoratedKey> keySamples(Iterable<ColumnFamilyStore> cfses, Range<Token> range) {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : cfses) {
            Iterables.addAll(keys, cfs.keySamples(range));
        }
        FBUtilities.sortSampledKeys(keys, range);
        return keys;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.leaving(this.getLocalTokens()));
        this.tokenMetadata.addLeavingEndpoint(FBUtilities.getBroadcastAddress());
        this.calculatePendingRanges();
    }

    @Override
    public void decommission() throws InterruptedException {
        if (!this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
            throw new UnsupportedOperationException("local node is not a member of the token ring yet");
        }
        if (this.tokenMetadata.cloneAfterAllLeft().sortedTokens().size() < 2) {
            throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
        }
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            if (this.tokenMetadata.getPendingRanges(keyspaceName, FBUtilities.getBroadcastAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DECOMMISSIONING");
        }
        this.startLeaving();
        this.setMode(Mode.LEAVING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
        Thread.sleep(RING_DELAY);
        Runnable finishLeaving = new Runnable(){

            @Override
            public void run() {
                StorageService.this.shutdownClientServers();
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                StageManager.shutdownNow();
                StorageService.this.setMode(Mode.DECOMMISSIONED, true);
            }
        };
        this.unbootstrap(finishLeaving);
    }

    private void leaveRing() {
        SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.NEEDS_BOOTSTRAP);
        this.tokenMetadata.removeEndpoint(FBUtilities.getBroadcastAddress());
        this.calculatePendingRanges();
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.left(this.getLocalTokens(), Gossiper.computeExpireTime()));
        int delay = Math.max(RING_DELAY, 2000);
        logger.info("Announcing that I have left the ring for " + delay + "ms");
        Uninterruptibles.sleepUninterruptibly((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void unbootstrap(Runnable onFinish) {
        HashMap<String, Multimap<Range<Token>, InetAddress>> rangesToStream = new HashMap<String, Multimap<Range<Token>, InetAddress>>();
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            Multimap<Range<Token>, InetAddress> rangesMM = this.getChangedRangesForLeaving(keyspaceName, FBUtilities.getBroadcastAddress());
            if (logger.isDebugEnabled()) {
                logger.debug("Ranges needing transfer are [" + StringUtils.join((Collection)rangesMM.keySet(), (String)",") + "]");
            }
            rangesToStream.put(keyspaceName, rangesMM);
        }
        this.setMode(Mode.LEAVING, "streaming data to other nodes", true);
        Future<StreamState> streamSuccess = this.streamRanges(rangesToStream);
        Future<StreamState> hintsSuccess = this.streamHints();
        logger.debug("waiting for stream aks.");
        try {
            streamSuccess.get();
            hintsSuccess.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        logger.debug("stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    private Future<StreamState> streamHints() {
        if (HintedHandOffManager.instance.listEndpointsPendingHints().size() == 0) {
            return Futures.immediateFuture(null);
        }
        ArrayList<InetAddress> candidates = new ArrayList<InetAddress>(instance.getTokenMetadata().cloneAfterAllLeft().getAllEndpoints());
        candidates.remove(FBUtilities.getBroadcastAddress());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            InetAddress address = (InetAddress)iter.next();
            if (FailureDetector.instance.isAlive(address)) continue;
            iter.remove();
        }
        if (candidates.isEmpty()) {
            logger.warn("Unable to stream hints since no live endpoints seen");
            return Futures.immediateFuture(null);
        }
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), candidates);
        InetAddress hintsDestinationHost = (InetAddress)candidates.get(0);
        Object token = StorageService.getPartitioner().getMinimumToken();
        List<Range<Token>> ranges = Collections.singletonList(new Range(token, token));
        return new StreamPlan("Hints").transferRanges(hintsDestinationHost, "system", ranges, "hints").execute();
    }

    @Override
    public void move(String newToken) throws IOException {
        try {
            StorageService.getPartitioner().getTokenFactory().validate(newToken);
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.move(StorageService.getPartitioner().getTokenFactory().fromString(newToken));
    }

    private void move(Token newToken) throws IOException {
        if (newToken == null) {
            throw new IOException("Can't move to the undefined (null) token.");
        }
        if (this.tokenMetadata.sortedTokens().contains(newToken)) {
            throw new IOException("target token " + newToken + " is already owned by another node.");
        }
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        if (this.getTokenMetadata().getTokens(localAddress).size() > 1) {
            logger.error("Invalid request to move(Token); This node has more than one token and cannot be moved thusly.");
            throw new UnsupportedOperationException("This node has more than one token and cannot be moved thusly.");
        }
        List<String> keyspacesToProcess = Schema.instance.getNonSystemKeyspaces();
        for (String keyspaceName : keyspacesToProcess) {
            if (this.tokenMetadata.getPendingRanges(keyspaceName, localAddress).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.moving(newToken));
        this.setMode(Mode.MOVING, String.format("Moving %s from %s to %s.", localAddress, this.getLocalTokens().iterator().next(), newToken), true);
        this.setMode(Mode.MOVING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY), true);
        Uninterruptibles.sleepUninterruptibly((long)RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        RangeRelocator relocator = new RangeRelocator(Collections.singleton(newToken), keyspacesToProcess);
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.MOVING, "fetching new ranges and streaming old ranges", true);
            try {
                relocator.stream().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Interrupted while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.MOVING, "No ranges to fetch/stream", true);
        }
        this.setTokens(Collections.singleton(newToken));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully moved to new token {}", (Object)this.getLocalTokens().iterator().next());
        }
    }

    @Override
    public void relocate(Collection<String> srcTokens) throws IOException {
        ArrayList<Token> tokens = new ArrayList<Token>(srcTokens.size());
        try {
            for (String srcT : srcTokens) {
                StorageService.getPartitioner().getTokenFactory().validate(srcT);
                tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(srcT));
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.relocateTokens(tokens);
    }

    void relocateTokens(Collection<Token> srcTokens) {
        assert (srcTokens != null);
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        Collection<Token> localTokens = this.getTokenMetadata().getTokens(localAddress);
        HashSet<Token> tokens = new HashSet<Token>(srcTokens);
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            Token srcT = (Token)it.next();
            if (!localTokens.contains(srcT)) continue;
            it.remove();
            logger.warn("cannot move {}; source and destination match", (Object)srcT);
        }
        if (tokens.size() < 1) {
            logger.warn("no valid token arguments specified; nothing to relocate");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.relocating(tokens));
        this.setMode(Mode.RELOCATING, String.format("relocating %s to %s", tokens, localAddress.getHostAddress()), true);
        List<String> keyspaceNames = Schema.instance.getNonSystemKeyspaces();
        this.setMode(Mode.RELOCATING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY), true);
        Uninterruptibles.sleepUninterruptibly((long)RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        RangeRelocator relocator = new RangeRelocator(tokens, keyspaceNames);
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.RELOCATING, "fetching new ranges and streaming old ranges", true);
            try {
                relocator.stream().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Interrupted latch while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.RELOCATING, "no new ranges to stream/fetch", true);
        }
        Collection<Token> currentTokens = SystemKeyspace.updateLocalTokens(tokens, Collections.emptyList());
        this.tokenMetadata.updateNormalTokens(currentTokens, FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(currentTokens));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.normal(currentTokens));
        this.setMode(Mode.NORMAL, false);
    }

    @Override
    public String getRemovalStatus() {
        if (this.removingNode == null) {
            return "No token removals in process.";
        }
        return String.format("Removing token (%s). Waiting for replication confirmation from [%s].", this.tokenMetadata.getToken(this.removingNode), StringUtils.join(this.replicatingNodes, (String)","));
    }

    @Override
    public void forceRemoveCompletion() {
        if (!this.replicatingNodes.isEmpty() || !this.tokenMetadata.getLeavingEndpoints().isEmpty()) {
            logger.warn("Removal not confirmed for for " + StringUtils.join(this.replicatingNodes, (String)","));
            for (InetAddress endpoint : this.tokenMetadata.getLeavingEndpoints()) {
                UUID hostId = this.tokenMetadata.getHostId(endpoint);
                Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
                this.excise(this.tokenMetadata.getTokens(endpoint), endpoint);
            }
        } else {
            throw new UnsupportedOperationException("No tokens to force removal on, call 'removetoken' first");
        }
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    @Override
    public void removeNode(String hostIdString) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        UUID localHostId = this.tokenMetadata.getHostId(myAddress);
        UUID hostId = UUID.fromString(hostIdString);
        InetAddress endpoint = this.tokenMetadata.getEndpointForHostId(hostId);
        if (endpoint == null) {
            throw new UnsupportedOperationException("Host ID not found.");
        }
        Collection<Token> tokens = this.tokenMetadata.getTokens(endpoint);
        if (endpoint.equals(myAddress)) {
            throw new UnsupportedOperationException("Cannot remove self");
        }
        if (Gossiper.instance.getLiveMembers().contains(endpoint)) {
            throw new UnsupportedOperationException("Node " + endpoint + " is alive and owns this ID. Use decommission command to remove it from the ring");
        }
        if (this.tokenMetadata.isLeaving(endpoint)) {
            logger.warn("Node " + endpoint + " is already being removed, continuing removal anyway");
        }
        if (!this.replicatingNodes.isEmpty()) {
            throw new UnsupportedOperationException("This node is already processing a removal. Wait for it to complete, or use 'removetoken force' if this has failed.");
        }
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            if (Keyspace.open(keyspaceName).getReplicationStrategy().getReplicationFactor() == 1) continue;
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(keyspaceName, endpoint);
            IFailureDetector failureDetector = FailureDetector.instance;
            for (InetAddress ep : changedRanges.values()) {
                if (failureDetector.isAlive(ep)) {
                    this.replicatingNodes.add(ep);
                    continue;
                }
                logger.warn("Endpoint " + ep + " is down and will not receive data for re-replication of " + endpoint);
            }
        }
        this.removingNode = endpoint;
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        this.calculatePendingRanges();
        Gossiper.instance.advertiseRemoving(endpoint, hostId, localHostId);
        this.restoreReplicaCount(endpoint, myAddress);
        while (!this.replicatingNodes.isEmpty()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.excise(tokens, endpoint);
        Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    public void confirmReplication(InetAddress node) {
        if (!this.replicatingNodes.isEmpty()) {
            this.replicatingNodes.remove(node);
        } else {
            logger.info("Received unexpected REPLICATION_FINISHED message from " + node + ". Was this node recently a removal coordinator?");
        }
    }

    public boolean isClientMode() {
        return this.isClientMode;
    }

    public synchronized void requestGC() {
        if (this.hasUnreclaimedSpace()) {
            logger.info("requesting GC to free disk space");
            System.gc();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private boolean hasUnreclaimedSpace() {
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.hasUnreclaimedSpace()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperationMode() {
        return this.operationMode.toString();
    }

    @Override
    public String getDrainProgress() {
        return String.format("Drained %s/%s ColumnFamilies", this.remainingCFs, this.totalCFs);
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        TracingAwareExecutorService mutationStage = StageManager.getStage(Stage.MUTATION);
        if (mutationStage.isTerminated()) {
            logger.warn("Cannot drain node (did it already happen?)");
            return;
        }
        this.setMode(Mode.DRAINING, "starting drain process", true);
        this.shutdownClientServers();
        optionalTasks.shutdown();
        Gossiper.instance.stop();
        this.setMode(Mode.DRAINING, "shutting down MessageService", false);
        MessagingService.instance().shutdown();
        this.setMode(Mode.DRAINING, "waiting for streaming", false);
        MessagingService.instance().waitForStreaming();
        this.setMode(Mode.DRAINING, "clearing mutation stage", false);
        mutationStage.shutdown();
        mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
        StorageProxy.instance.verifyNoHintsInProgress();
        this.setMode(Mode.DRAINING, "flushing column families", false);
        this.totalCFs = 0;
        for (Keyspace keyspace : Keyspace.nonSystem()) {
            this.totalCFs += keyspace.getColumnFamilyStores().size();
        }
        this.remainingCFs = this.totalCFs;
        ArrayList flushes = new ArrayList();
        for (Keyspace keyspace : Keyspace.nonSystem()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                flushes.add(cfs.forceFlush());
            }
        }
        for (Future future : flushes) {
            FBUtilities.waitOnFuture(future);
            --this.remainingCFs;
        }
        flushes.clear();
        for (Keyspace keyspace : Keyspace.system()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                flushes.add(cfs.forceFlush());
            }
        }
        FBUtilities.waitOnFutures(flushes);
        ColumnFamilyStore.postFlushExecutor.shutdown();
        ColumnFamilyStore.postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        CommitLog.instance.shutdownBlocking();
        tasks.shutdown();
        if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
            logger.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
        }
        this.setMode(Mode.DRAINED, true);
    }

    IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner<?> oldPartitioner = DatabaseDescriptor.getPartitioner();
        DatabaseDescriptor.setPartitioner(newPartitioner);
        this.valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata;
        this.tokenMetadata = tmd;
        return old;
    }

    @Override
    public void truncate(String keyspace, String columnFamily) throws TimeoutException, IOException {
        try {
            StorageProxy.truncateBlocking(keyspace, columnFamily);
        }
        catch (UnavailableException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Map<InetAddress, Float> getOwnership() {
        ArrayList<Token> sortedTokens = this.tokenMetadata.sortedTokens();
        TreeMap<Token, Float> tokenMap = new TreeMap<Token, Float>(StorageService.getPartitioner().describeOwnership(sortedTokens));
        LinkedHashMap<InetAddress, Float> nodeMap = new LinkedHashMap<InetAddress, Float>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            InetAddress endpoint = this.tokenMetadata.getEndpoint((Token)entry.getKey());
            Float tokenOwnership = (Float)entry.getValue();
            if (nodeMap.containsKey(endpoint)) {
                nodeMap.put(endpoint, Float.valueOf(((Float)nodeMap.get(endpoint)).floatValue() + tokenOwnership.floatValue()));
                continue;
            }
            nodeMap.put(endpoint, tokenOwnership);
        }
        return nodeMap;
    }

    public LinkedHashMap<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        if (Schema.instance.getNonSystemKeyspaces().size() <= 0) {
            throw new IllegalStateException("Couldn't find any Non System Keyspaces to infer replication topology");
        }
        if (keyspace == null && !this.hasSameReplication(Schema.instance.getNonSystemKeyspaces())) {
            throw new IllegalStateException("Non System keyspaces doesnt have the same topology");
        }
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemKeyspaces().get(0);
        }
        ArrayList<Collection> endpointsGroupedByDc = new ArrayList<Collection>();
        TreeMap sortedDcsToEndpoints = new TreeMap();
        sortedDcsToEndpoints.putAll(metadata.getTopology().getDatacenterEndpoints().asMap());
        for (Collection endpoints : sortedDcsToEndpoints.values()) {
            endpointsGroupedByDc.add(endpoints);
        }
        Map<Token, Float> tokenOwnership = StorageService.getPartitioner().describeOwnership(this.tokenMetadata.sortedTokens());
        LinkedHashMap finalOwnership = Maps.newLinkedHashMap();
        for (Collection endpoints : endpointsGroupedByDc) {
            for (InetAddress endpoint : endpoints) {
                float ownership = 0.0f;
                for (Range<Token> range : this.getRangesForEndpoint(keyspace, endpoint)) {
                    if (!tokenOwnership.containsKey(range.right)) continue;
                    ownership += tokenOwnership.get(range.right).floatValue();
                }
                finalOwnership.put(endpoint, Float.valueOf(ownership));
            }
        }
        return finalOwnership;
    }

    private boolean hasSameReplication(List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            KSMetaData ksm1 = Schema.instance.getKSMetaData(list.get(i));
            KSMetaData ksm2 = Schema.instance.getKSMetaData(list.get(i + 1));
            if (ksm1.strategyClass.equals(ksm2.strategyClass) && Iterators.elementsEqual(ksm1.strategyOptions.entrySet().iterator(), ksm2.strategyOptions.entrySet().iterator())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getKeyspaces() {
        ArrayList<String> keyspaceNamesList = new ArrayList<String>(Schema.instance.getKeyspaces());
        return Collections.unmodifiableList(keyspaceNamesList);
    }

    @Override
    public void updateSnitch(String epSnitchClassName, Boolean dynamic, Integer dynamicUpdateInterval, Integer dynamicResetInterval, Double dynamicBadnessThreshold) throws ClassNotFoundException {
        IEndpointSnitch newSnitch;
        IEndpointSnitch oldSnitch = DatabaseDescriptor.getEndpointSnitch();
        try {
            newSnitch = (IEndpointSnitch)FBUtilities.construct(epSnitchClassName, "snitch");
        }
        catch (ConfigurationException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        if (dynamic.booleanValue()) {
            DatabaseDescriptor.setDynamicUpdateInterval(dynamicUpdateInterval);
            DatabaseDescriptor.setDynamicResetInterval(dynamicResetInterval);
            DatabaseDescriptor.setDynamicBadnessThreshold(dynamicBadnessThreshold);
            newSnitch = new DynamicEndpointSnitch(newSnitch);
        }
        DatabaseDescriptor.setEndpointSnitch(newSnitch);
        for (String ks : Schema.instance.getKeyspaces()) {
            Keyspace.open((String)ks).getReplicationStrategy().snitch = newSnitch;
        }
        if (oldSnitch instanceof DynamicEndpointSnitch) {
            ((DynamicEndpointSnitch)oldSnitch).unregisterMBean();
        }
    }

    private Future<StreamState> streamRanges(Map<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByKeyspace) {
        Map<InetAddress, LinkedList<Range>> rangesPerEndpoint;
        HashMap<String, Map<InetAddress, LinkedList<Range>>> sessionsToStreamByKeyspace = new HashMap<String, Map<InetAddress, LinkedList<Range>>>();
        for (Map.Entry<String, Multimap<Range<Token>, InetAddress>> entry : rangesToStreamByKeyspace.entrySet()) {
            String keyspace = entry.getKey();
            Multimap<Range<Token>, InetAddress> rangesWithEndpoints = entry.getValue();
            if (rangesWithEndpoints.isEmpty()) continue;
            rangesPerEndpoint = new HashMap();
            for (Map.Entry entry2 : rangesWithEndpoints.entries()) {
                Range range = (Range)entry2.getKey();
                InetAddress endpoint = (InetAddress)entry2.getValue();
                LinkedList<Range> curRanges = (LinkedList<Range>)rangesPerEndpoint.get(endpoint);
                if (curRanges == null) {
                    curRanges = new LinkedList<Range>();
                    rangesPerEndpoint.put(endpoint, curRanges);
                }
                curRanges.add(range);
            }
            sessionsToStreamByKeyspace.put(keyspace, rangesPerEndpoint);
        }
        StreamPlan streamPlan = new StreamPlan("Unbootstrap");
        for (Map.Entry entry : sessionsToStreamByKeyspace.entrySet()) {
            String keyspaceName = (String)entry.getKey();
            rangesPerEndpoint = (Map)entry.getValue();
            for (Map.Entry entry3 : rangesPerEndpoint.entrySet()) {
                List ranges = (List)entry3.getValue();
                InetAddress newEndpoint = (InetAddress)entry3.getKey();
                streamPlan.transferRanges(newEndpoint, keyspaceName, ranges);
            }
        }
        return streamPlan.execute();
    }

    public Pair<Set<Range<Token>>, Set<Range<Token>>> calculateStreamAndFetchRanges(Collection<Range<Token>> current, Collection<Range<Token>> updated) {
        boolean intersect;
        HashSet<Range<Token>> toStream = new HashSet<Range<Token>>();
        HashSet<Range<Token>> toFetch = new HashSet<Range<Token>>();
        for (Range<Token> r1 : current) {
            intersect = false;
            for (Range<Token> r2 : updated) {
                if (!r1.intersects(r2)) continue;
                toStream.addAll(r1.subtract(r2));
                intersect = true;
            }
            if (intersect) continue;
            toStream.add(r1);
        }
        for (Range<Token> r2 : updated) {
            intersect = false;
            for (Range<Token> r1 : current) {
                if (!r2.intersects(r1)) continue;
                toFetch.addAll(r2.subtract(r1));
                intersect = true;
            }
            if (intersect) continue;
            toFetch.add(r2);
        }
        return Pair.create(toStream, toFetch);
    }

    @Override
    public void bulkLoad(String directory) {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory " + directory);
        }
        SSTableLoader.Client client = new SSTableLoader.Client(){

            @Override
            public void init(String keyspace) {
                try {
                    this.setPartitioner(DatabaseDescriptor.getPartitioner());
                    for (Map.Entry<Range<Token>, List<InetAddress>> entry : instance.getRangeToAddressMap(keyspace).entrySet()) {
                        Range<Token> range = entry.getKey();
                        for (InetAddress endpoint : entry.getValue()) {
                            this.addRangeForEndpoint(range, endpoint);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public CFMetaData getCFMetaData(String keyspace, String cfName) {
                return Schema.instance.getCFMetaData(keyspace, cfName);
            }
        };
        SSTableLoader loader = new SSTableLoader(dir, client, new OutputHandler.LogOutput());
        try {
            loader.stream().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getExceptionCount() {
        return CassandraDaemon.exceptions.get();
    }

    @Override
    public void rescheduleFailedDeletions() {
        SSTableDeletingTask.rescheduleFailedTasks();
    }

    @Override
    public void loadNewSSTables(String ksName, String cfName) {
        ColumnFamilyStore.loadNewSSTables(ksName, cfName);
    }

    @Override
    public List<String> sampleKeyRange() {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (Keyspace keyspace : Keyspace.nonSystem()) {
            for (Range<Token> range : this.getPrimaryRangesForEndpoint(keyspace.getName(), FBUtilities.getBroadcastAddress())) {
                keys.addAll(this.keySamples(keyspace.getColumnFamilyStores(), range));
            }
        }
        ArrayList<String> sampledKeys = new ArrayList<String>(keys.size());
        for (DecoratedKey key : keys) {
            sampledKeys.add(key.getToken().toString());
        }
        return sampledKeys;
    }

    @Override
    public void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    @Override
    public void resetLocalSchema() throws IOException {
        MigrationManager.resetLocalSchema();
    }

    @Override
    public void setTraceProbability(double probability) {
        this.tracingProbability = probability;
    }

    @Override
    public double getTracingProbability() {
        return this.tracingProbability;
    }

    @Override
    public void enableScheduledRangeXfers() {
        rangeXferExecutor.setup();
    }

    @Override
    public void disableScheduledRangeXfers() {
        rangeXferExecutor.tearDown();
    }

    @Override
    public void disableAutoCompaction(String ks, String ... columnFamilies) throws IOException {
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, columnFamilies)) {
            cfs.disableAutoCompaction();
        }
    }

    @Override
    public void enableAutoCompaction(String ks, String ... columnFamilies) throws IOException {
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, columnFamilies)) {
            cfs.enableAutoCompaction();
        }
    }

    static {
        tasks.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        instance = new StorageService();
        nextRepairCommand = new AtomicInteger();
        rangeXferExecutor = new ScheduledRangeTransferExecutorService();
        bgMonitor = new BackgroundActivityMonitor();
    }

    private class RangeRelocator {
        private StreamPlan streamPlan = new StreamPlan("Bootstrap");

        private RangeRelocator(Collection<Token> tokens, List<String> keyspaceNames) {
            this.calculateToFromStreams(tokens, keyspaceNames);
        }

        private void calculateToFromStreams(Collection<Token> newTokens, List<String> keyspaceNames) {
            InetAddress localAddress = FBUtilities.getBroadcastAddress();
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            TokenMetadata tokenMetaCloneAllSettled = StorageService.this.tokenMetadata.cloneAfterAllSettled();
            TokenMetadata tokenMetaClone = StorageService.this.tokenMetadata.cloneOnlyTokenMap();
            for (String keyspace : keyspaceNames) {
                for (Token newToken : newTokens) {
                    AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
                    Collection<Range<Token>> currentRanges = StorageService.this.getRangesForEndpoint(keyspace, localAddress);
                    Collection<Range<Token>> updatedRanges = strategy.getPendingAddressRanges(StorageService.this.tokenMetadata, newToken, localAddress);
                    Multimap<Range<Token>, InetAddress> rangeAddresses = strategy.getRangeAddresses(tokenMetaClone);
                    Pair<Set<Range<Token>>, Set<Range<Token>>> rangesPerKeyspace = StorageService.this.calculateStreamAndFetchRanges(currentRanges, updatedRanges);
                    ArrayListMultimap rangesToFetchWithPreferredEndpoints = ArrayListMultimap.create();
                    for (Range toFetch : (Set)rangesPerKeyspace.right) {
                        for (Range range : rangeAddresses.keySet()) {
                            if (!range.contains(toFetch)) continue;
                            List<InetAddress> endpoints = snitch.getSortedListByProximity(localAddress, rangeAddresses.get((Object)range));
                            rangesToFetchWithPreferredEndpoints.putAll((Object)toFetch, endpoints);
                        }
                    }
                    HashMultimap endpointRanges = HashMultimap.create();
                    for (Range toStream : (Set)rangesPerKeyspace.left) {
                        ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaClone));
                        ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaCloneAllSettled));
                        logger.debug("Range:" + toStream + "Current endpoints: " + currentEndpoints + " New endpoints: " + newEndpoints);
                        for (InetAddress address : Sets.difference((Set)newEndpoints, (Set)currentEndpoints)) {
                            endpointRanges.put((Object)address, (Object)toStream);
                        }
                    }
                    for (InetAddress address : endpointRanges.keySet()) {
                        this.streamPlan.transferRanges(address, keyspace, endpointRanges.get((Object)address));
                    }
                    Multimap<InetAddress, Range<Token>> workMap = RangeStreamer.getWorkMap((Multimap<Range<Token>, InetAddress>)rangesToFetchWithPreferredEndpoints);
                    for (InetAddress address : workMap.keySet()) {
                        this.streamPlan.requestRanges(address, keyspace, workMap.get((Object)address));
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Keyspace {}: work map {}.", (Object)keyspace, workMap);
                }
            }
        }

        public Future<StreamState> stream() {
            return this.streamPlan.execute();
        }

        public boolean streamsNeeded() {
            return !this.streamPlan.isEmpty();
        }
    }

    private static enum Mode {
        NORMAL,
        CLIENT,
        JOINING,
        LEAVING,
        DECOMMISSIONED,
        MOVING,
        DRAINING,
        DRAINED,
        RELOCATING;

    }
}

