/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import org.apache.cassandra.db.commitlog.CommitLogAllocator;
import org.apache.cassandra.db.commitlog.ICommitLogExecutorService;

public class CommitLogMetrics {
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "CommitLog";
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Long> totalCommitLogSize;

    public CommitLogMetrics(final ICommitLogExecutorService executor, final CommitLogAllocator allocator) {
        this.completedTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCompletedTasks();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getPendingTasks();
            }
        });
        this.totalCommitLogSize = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "TotalCommitLogSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return allocator.bytesUsed();
            }
        });
    }
}

