/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryBuilder.class);
    private final ArrayList<Long> positions;
    private final ArrayList<byte[]> keys;
    private final int indexInterval;
    private long keysWritten = 0L;
    private long offheapSize = 0L;

    public IndexSummaryBuilder(long expectedKeys, int indexInterval) {
        this.indexInterval = indexInterval;
        long expectedEntries = expectedKeys / (long)indexInterval;
        if (expectedEntries > Integer.MAX_VALUE) {
            int effectiveInterval = (int)Math.ceil(2.147483647E9 / (double)expectedKeys);
            expectedEntries = expectedKeys / (long)effectiveInterval;
            assert (expectedEntries <= Integer.MAX_VALUE) : expectedEntries;
            logger.warn("Index interval of {} is too low for {} expected keys; using interval of {} instead", new Object[]{indexInterval, expectedKeys, effectiveInterval});
        }
        this.positions = new ArrayList((int)expectedEntries);
        this.keys = new ArrayList((int)expectedEntries);
    }

    public IndexSummaryBuilder maybeAddEntry(DecoratedKey decoratedKey, long indexPosition) {
        if (this.keysWritten % (long)this.indexInterval == 0L) {
            byte[] key = ByteBufferUtil.getArray(decoratedKey.key);
            this.keys.add(key);
            this.offheapSize += (long)key.length;
            this.positions.add(indexPosition);
            this.offheapSize += (long)TypeSizes.NATIVE.sizeof(indexPosition);
        }
        ++this.keysWritten;
        return this;
    }

    public IndexSummary build(IPartitioner partitioner) {
        assert (this.keys != null && this.keys.size() > 0);
        assert (this.keys.size() == this.positions.size());
        Memory memory = Memory.allocate(this.offheapSize + (long)(this.keys.size() * 4));
        int idxPosition = 0;
        int keyPosition = this.keys.size() * 4;
        for (int i = 0; i < this.keys.size(); ++i) {
            memory.setInt(idxPosition, keyPosition);
            idxPosition += TypeSizes.NATIVE.sizeof(keyPosition);
            byte[] temp = this.keys.get(i);
            memory.setBytes(keyPosition, temp, 0, temp.length);
            long tempPosition = this.positions.get(i);
            memory.setLong(keyPosition += temp.length, tempPosition);
            keyPosition += TypeSizes.NATIVE.sizeof(tempPosition);
        }
        return new IndexSummary(partitioner, memory, this.keys.size(), this.indexInterval);
    }
}

