/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.GossipDigest;

class GossipDigestSerializationHelper {
    GossipDigestSerializationHelper() {
    }

    static void serialize(List<GossipDigest> gDigestList, DataOutput out, int version) throws IOException {
        out.writeInt(gDigestList.size());
        for (GossipDigest gDigest : gDigestList) {
            GossipDigest.serializer.serialize(gDigest, out, version);
        }
    }

    static List<GossipDigest> deserialize(DataInput in, int version) throws IOException {
        int size = in.readInt();
        ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>(size);
        for (int i = 0; i < size; ++i) {
            gDigests.add(GossipDigest.serializer.deserialize(in, version));
        }
        return gDigests;
    }

    static int serializedSize(List<GossipDigest> digests, int version) {
        int size = TypeSizes.NATIVE.sizeof(digests.size());
        for (GossipDigest digest : digests) {
            size = (int)((long)size + GossipDigest.serializer.serializedSize(digest, version));
        }
        return size;
    }
}

