/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimestampSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampType
extends AbstractType<Date> {
    private static final Logger logger = LoggerFactory.getLogger(TimestampType.class);
    public static final TimestampType instance = new TimestampType();

    private TimestampType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return LongType.compareLongs(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return ByteBufferUtil.bytes(TimestampType.dateStringToTimestamp(source));
    }

    public static long dateStringToTimestamp(String source) throws MarshalException {
        long millis;
        if (source.toLowerCase().equals("now")) {
            millis = System.currentTimeMillis();
        } else {
            if (source.matches("^\\d+$")) {
                try {
                    millis = Long.parseLong(source);
                }
                catch (NumberFormatException e) {
                    throw new MarshalException(String.format("unable to make long (for date) from: '%s'", source), e);
                }
            }
            try {
                millis = DateUtils.parseDateStrictly((String)source, (String[])TimestampSerializer.iso8601Patterns).getTime();
            }
            catch (ParseException e1) {
                throw new MarshalException(String.format("unable to coerce '%s' to a  formatted date (long)", source), e1);
            }
        }
        return millis;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (super.isCompatibleWith(previous)) {
            return true;
        }
        if (previous instanceof DateType) {
            logger.warn("Changing from DateType to TimestampType is allowed, but be wary that they sort differently for pre-unix-epoch timestamps (negative timestamp values) and thus this change will corrupt your data if you have such negative timestamp. So unless you know that you don't have *any* pre-unix-epoch timestamp you should change back to DateType");
            return true;
        }
        return false;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMESTAMP;
    }

    @Override
    public TypeSerializer<Date> getSerializer() {
        return TimestampSerializer.instance;
    }
}

