/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadVerbHandler
implements IVerbHandler<ReadCommand> {
    private static final Logger logger = LoggerFactory.getLogger(ReadVerbHandler.class);

    @Override
    public void doVerb(MessageIn<ReadCommand> message, int id) {
        if (StorageService.instance.isBootstrapMode()) {
            throw new RuntimeException("Cannot service reads while bootstrapping!");
        }
        ReadCommand command = (ReadCommand)message.payload;
        Keyspace keyspace = Keyspace.open(command.ksName);
        Row row = command.getRow(keyspace);
        MessageOut<ReadResponse> reply = new MessageOut<ReadResponse>(MessagingService.Verb.REQUEST_RESPONSE, ReadVerbHandler.getResponse(command, row), ReadResponse.serializer);
        Tracing.trace("Enqueuing response to {}", message.from);
        MessagingService.instance().sendReply(reply, id, message.from);
    }

    public static ReadResponse getResponse(ReadCommand command, Row row) {
        if (command.isDigestQuery()) {
            return new ReadResponse(ColumnFamily.digest(row.cf));
        }
        return new ReadResponse(row);
    }
}

