/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class ReadResponseSerializer
implements IVersionedSerializer<ReadResponse> {
    ReadResponseSerializer() {
    }

    @Override
    public void serialize(ReadResponse response, DataOutput out, int version) throws IOException {
        out.writeInt(response.isDigestQuery() ? response.digest().remaining() : 0);
        ByteBuffer buffer = response.isDigestQuery() ? response.digest() : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        ByteBufferUtil.write(buffer, out);
        out.writeBoolean(response.isDigestQuery());
        if (!response.isDigestQuery()) {
            Row.serializer.serialize(response.row(), out, version);
        }
    }

    @Override
    public ReadResponse deserialize(DataInput in, int version) throws IOException {
        byte[] digest = null;
        int digestSize = in.readInt();
        if (digestSize > 0) {
            digest = new byte[digestSize];
            in.readFully(digest, 0, digestSize);
        }
        boolean isDigest = in.readBoolean();
        assert (isDigest == digestSize > 0);
        Row row = null;
        if (!isDigest) {
            row = Row.serializer.deserialize(in, version, ColumnSerializer.Flag.FROM_REMOTE);
        }
        return isDigest ? new ReadResponse(ByteBuffer.wrap(digest)) : new ReadResponse(row);
    }

    @Override
    public long serializedSize(ReadResponse response, int version) {
        TypeSizes typeSizes = TypeSizes.NATIVE;
        ByteBuffer buffer = response.isDigestQuery() ? response.digest() : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        int size = typeSizes.sizeof(buffer.remaining());
        size += buffer.remaining();
        size += typeSizes.sizeof(response.isDigestQuery());
        if (!response.isDigestQuery()) {
            size = (int)((long)size + Row.serializer.serializedSize(response.row(), version));
        }
        return size;
    }
}

