/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.TruncateException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;

public class TruncateStatement
extends CFStatement
implements CQLStatement {
    public TruncateStatement(CFName name) {
        super(name);
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws InvalidRequestException, TruncateException {
        try {
            StorageProxy.truncateBlocking(this.keyspace(), this.columnFamily());
        }
        catch (UnavailableException e) {
            throw new TruncateException(e);
        }
        catch (TimeoutException e) {
            throw new TruncateException(e);
        }
        catch (IOException e) {
            throw new TruncateException(e);
        }
        return null;
    }

    @Override
    public ResultMessage executeInternal(QueryState state) {
        throw new UnsupportedOperationException();
    }
}

