/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface Term {
    public void collectMarkerSpecification(ColumnSpecification[] var1);

    public Terminal bind(List<ByteBuffer> var1) throws InvalidRequestException;

    public ByteBuffer bindAndGet(List<ByteBuffer> var1) throws InvalidRequestException;

    public boolean containsBindMarker();

    public static abstract class NonTerminal
    implements Term {
        @Override
        public ByteBuffer bindAndGet(List<ByteBuffer> values) throws InvalidRequestException {
            Terminal t = this.bind(values);
            return t == null ? null : t.get();
        }
    }

    public static abstract class Terminal
    implements Term {
        @Override
        public void collectMarkerSpecification(ColumnSpecification[] boundNames) {
        }

        @Override
        public Terminal bind(List<ByteBuffer> values) {
            return this;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        public abstract ByteBuffer get();

        @Override
        public ByteBuffer bindAndGet(List<ByteBuffer> values) throws InvalidRequestException {
            return this.get();
        }
    }

    public static interface Raw
    extends AssignementTestable {
        public Term prepare(ColumnSpecification var1) throws InvalidRequestException;
    }
}

