/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.LengthAvailableInputStream;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSavingCache<K extends CacheKey, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final Set<CacheService.CacheType> flushInProgress = new NonBlockingHashSet();
    protected volatile ScheduledFuture<?> saveTask;
    protected final CacheService.CacheType cacheType;
    private CacheSerializer<K, V> cacheLoader;
    private static final String CURRENT_VERSION = "b";

    public AutoSavingCache(ICache<K, V> cache, CacheService.CacheType cacheType, CacheSerializer<K, V> cacheloader) {
        super(cacheType.toString(), cache);
        this.cacheType = cacheType;
        this.cacheLoader = cacheloader;
    }

    public File getCachePath(String ksName, String cfName, String version) {
        return DatabaseDescriptor.getSerializedCachePath(ksName, cfName, this.cacheType, version);
    }

    public Writer getWriter(int keysToSave) {
        return new Writer(keysToSave);
    }

    public void scheduleSaving(int savePeriodInSeconds, final int keysToSave) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutoSavingCache.this.submitWrite(keysToSave);
                }
            };
            this.saveTask = StorageService.optionalTasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadSaved(ColumnFamilyStore cfs) {
        DataInputStream in;
        int count = 0;
        long start = System.nanoTime();
        File path = this.getCachePath(cfs.keyspace.getName(), cfs.name, null);
        if (path.exists()) {
            in = null;
            try {
                logger.info(String.format("reading saved cache %s", path));
                in = new DataInputStream(new LengthAvailableInputStream(new BufferedInputStream(new FileInputStream(path)), path.length()));
                HashSet<ByteBuffer> keys = new HashSet<ByteBuffer>();
                while (in.available() > 0) {
                    keys.add(ByteBufferUtil.readWithLength(in));
                    ++count;
                }
                this.cacheLoader.load(keys, cfs);
                FileUtils.closeQuietly(in);
            }
            catch (Exception e) {
                logger.debug(String.format("harmless error reading saved cache %s fully, keys loaded so far: %d", path.getAbsolutePath(), count), (Throwable)e);
                int n = count;
                return n;
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        if ((path = this.getCachePath(cfs.keyspace.getName(), cfs.name, CURRENT_VERSION)).exists()) {
            in = null;
            try {
                logger.info(String.format("reading saved cache %s", path));
                in = new DataInputStream(new LengthAvailableInputStream(new BufferedInputStream(new FileInputStream(path)), path.length()));
                ArrayList<Future<Pair<K, V>>> futures = new ArrayList<Future<Pair<K, V>>>();
                while (in.available() > 0) {
                    Future<Pair<K, V>> entry = this.cacheLoader.deserialize(in, cfs);
                    if (entry == null) continue;
                    futures.add(entry);
                    ++count;
                }
                for (Future future : futures) {
                    Pair entry = (Pair)future.get();
                    this.put(entry.left, entry.right);
                }
            }
            catch (Exception e) {
                try {
                    logger.debug(String.format("harmless error reading saved cache %s", path.getAbsolutePath()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    throw throwable;
                }
                FileUtils.closeQuietly(in);
            }
            FileUtils.closeQuietly(in);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("completed reading ({} ms; {} keys) saved cache {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), count, path});
        }
        return count;
    }

    public Future<?> submitWrite(int keysToSave) {
        return CompactionManager.instance.submitCacheWrite(this.getWriter(keysToSave));
    }

    public static interface CacheSerializer<K extends CacheKey, V> {
        public void serialize(K var1, DataOutput var2) throws IOException;

        public Future<Pair<K, V>> deserialize(DataInputStream var1, ColumnFamilyStore var2) throws IOException;

        @Deprecated
        public void load(Set<ByteBuffer> var1, ColumnFamilyStore var2);
    }

    public class Writer
    extends CompactionInfo.Holder {
        private final Set<K> keys;
        private final CompactionInfo info;
        private long keysWritten;

        protected Writer(int keysToSave) {
            this.keys = keysToSave >= AutoSavingCache.this.getKeySet().size() ? AutoSavingCache.this.getKeySet() : AutoSavingCache.this.hotKeySet(keysToSave);
            OperationType type = AutoSavingCache.this.cacheType == CacheService.CacheType.KEY_CACHE ? OperationType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.ROW_CACHE ? OperationType.ROW_CACHE_SAVE : OperationType.UNKNOWN);
            this.info = new CompactionInfo(new CFMetaData("system", AutoSavingCache.this.cacheType.toString(), ColumnFamilyType.Standard, (AbstractType<?>)BytesType.instance, null), type, 0L, this.keys.size(), "keys");
        }

        public CacheService.CacheType cacheType() {
            return AutoSavingCache.this.cacheType;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            return this.info.forProgress(this.keysWritten, Math.max(this.keysWritten, (long)this.keys.size()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCache() {
            SequentialWriter writer;
            Pair path;
            logger.debug("Deleting old {} files.", (Object)AutoSavingCache.this.cacheType);
            this.deleteOldCacheFiles();
            if (this.keys.isEmpty()) {
                logger.debug("Skipping {} save, cache is empty.", (Object)AutoSavingCache.this.cacheType);
                return;
            }
            long start = System.nanoTime();
            HashMap<Pair, SequentialWriter> writers = new HashMap<Pair, SequentialWriter>();
            try {
                for (CacheKey cacheKey : this.keys) {
                    path = cacheKey.getPathInfo();
                    writer = (SequentialWriter)writers.get(path);
                    if (writer == null) {
                        writer = this.tempCacheFile(path);
                        writers.put(path, writer);
                    }
                    try {
                        AutoSavingCache.this.cacheLoader.serialize(cacheKey, writer.stream);
                    }
                    catch (IOException e) {
                        throw new FSWriteError((Throwable)e, writer.getPath());
                    }
                    ++this.keysWritten;
                }
            }
            finally {
                for (SequentialWriter sequentialWriter : writers.values()) {
                    FileUtils.closeQuietly(sequentialWriter);
                }
            }
            for (Map.Entry entry : writers.entrySet()) {
                path = (Pair)entry.getKey();
                writer = (SequentialWriter)entry.getValue();
                File tmpFile = new File(writer.getPath());
                File cacheFile = AutoSavingCache.this.getCachePath((String)path.left, (String)path.right, AutoSavingCache.CURRENT_VERSION);
                cacheFile.delete();
                if (tmpFile.renameTo(cacheFile)) continue;
                logger.error("Unable to rename {} to {}", (Object)tmpFile, (Object)cacheFile);
            }
            logger.info("Saved {} ({} items) in {} ms", new Object[]{AutoSavingCache.this.cacheType, this.keys.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        }

        private SequentialWriter tempCacheFile(Pair<String, String> pathInfo) {
            File path = AutoSavingCache.this.getCachePath((String)pathInfo.left, (String)pathInfo.right, AutoSavingCache.CURRENT_VERSION);
            File tmpFile = FileUtils.createTempFile(path.getName(), null, path.getParentFile());
            return SequentialWriter.open(tmpFile, true);
        }

        private void deleteOldCacheFiles() {
            File savedCachesDir = new File(DatabaseDescriptor.getSavedCachesLocation());
            if (savedCachesDir.exists() && savedCachesDir.isDirectory()) {
                for (File file : savedCachesDir.listFiles()) {
                    if (file.isFile() && file.getName().endsWith(AutoSavingCache.this.cacheType.toString()) && !file.delete()) {
                        logger.warn("Failed to delete {}", (Object)file.getAbsolutePath());
                    }
                    if (!file.isFile() || !file.getName().endsWith("b.db") || file.delete()) continue;
                    logger.warn("Failed to delete {}", (Object)file.getAbsolutePath());
                }
            }
        }
    }
}

