/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class BatchMessage
extends Message.Request {
    public static final Message.Codec<BatchMessage> codec = new Message.Codec<BatchMessage>(){

        @Override
        public BatchMessage decode(ChannelBuffer body, int version) {
            if (version == 1) {
                throw new ProtocolException("BATCH messages are not support in version 1 of the protocol");
            }
            byte type = body.readByte();
            int n = body.readUnsignedShort();
            ArrayList<Object> queryOrIds = new ArrayList<Object>(n);
            ArrayList<List<ByteBuffer>> variables = new ArrayList<List<ByteBuffer>>(n);
            for (int i = 0; i < n; ++i) {
                byte kind = body.readByte();
                if (kind == 0) {
                    queryOrIds.add(CBUtil.readLongString(body));
                } else if (kind == 1) {
                    queryOrIds.add(MD5Digest.wrap(CBUtil.readBytes(body)));
                } else {
                    throw new ProtocolException("Invalid query kind in BATCH messages. Must be 0 or 1 but got " + kind);
                }
                int count = body.readUnsignedShort();
                ArrayList<ByteBuffer> values = count == 0 ? Collections.emptyList() : new ArrayList<ByteBuffer>(count);
                for (int j = 0; j < count; ++j) {
                    values.add(CBUtil.readValue(body));
                }
                variables.add(values);
            }
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            return new BatchMessage(this.toType(type), queryOrIds, variables, consistency);
        }

        @Override
        public ChannelBuffer encode(BatchMessage msg, int version) {
            int queries = msg.queryOrIdList.size();
            int totalValues = this.count(msg.values);
            ChannelBuffer header = ChannelBuffers.buffer((int)3);
            header.writeByte((int)this.fromType(msg.type));
            header.writeShort(queries);
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(2 + queries * 3, 0, totalValues);
            builder.add(header);
            for (int i = 0; i < queries; ++i) {
                Object q = msg.queryOrIdList.get(i);
                builder.add(CBUtil.byteToCB((byte)(!(q instanceof String) ? 1 : 0)));
                if (q instanceof String) {
                    builder.add(CBUtil.longStringToCB((String)q));
                } else {
                    builder.add(CBUtil.bytesToCB(((MD5Digest)q).bytes));
                }
                List<ByteBuffer> queryValues = msg.values.get(i);
                builder.add(CBUtil.shortToCB(queryValues.size()));
                for (ByteBuffer value : queryValues) {
                    builder.addValue(value);
                }
            }
            builder.add(CBUtil.consistencyLevelToCB(msg.consistency));
            return builder.build();
        }

        private BatchStatement.Type toType(byte b) {
            if (b == 0) {
                return BatchStatement.Type.LOGGED;
            }
            if (b == 1) {
                return BatchStatement.Type.UNLOGGED;
            }
            if (b == 2) {
                return BatchStatement.Type.COUNTER;
            }
            throw new ProtocolException("Invalid BATCH message type " + b);
        }

        private byte fromType(BatchStatement.Type type) {
            switch (type) {
                case LOGGED: {
                    return 0;
                }
                case UNLOGGED: {
                    return 1;
                }
                case COUNTER: {
                    return 2;
                }
            }
            throw new AssertionError();
        }

        private int count(List<List<ByteBuffer>> values) {
            int count = 0;
            for (List<ByteBuffer> l : values) {
                count += l.size();
            }
            return count;
        }
    };
    public final BatchStatement.Type type;
    public final List<Object> queryOrIdList;
    public final List<List<ByteBuffer>> values;
    public final ConsistencyLevel consistency;

    public BatchMessage(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, ConsistencyLevel consistency) {
        super(Message.Type.BATCH);
        this.type = type;
        this.queryOrIdList = queryOrIdList;
        this.values = values;
        this.consistency = consistency;
    }

    @Override
    public ChannelBuffer encode(int version) {
        return codec.encode(this, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                Tracing.instance.begin("Execute batch of CQL3 queries", Collections.emptyMap());
            }
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.queryOrIdList.size());
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                CQLStatement statement;
                Object query = this.queryOrIdList.get(i);
                if (query instanceof String) {
                    statement = QueryProcessor.parseStatement((String)query, state);
                } else {
                    statement = QueryProcessor.getPrepared((MD5Digest)query);
                    if (statement == null) {
                        throw new PreparedQueryNotFoundException((MD5Digest)query);
                    }
                }
                List<ByteBuffer> queryValues = this.values.get(i);
                if (queryValues.size() != statement.getBoundsTerms()) {
                    throw new InvalidRequestException(String.format("There were %d markers(?) in CQL but %d bound variables", statement.getBoundsTerms(), queryValues.size()));
                }
                if (!(statement instanceof ModificationStatement)) {
                    throw new InvalidRequestException("Invalid statement in batch: only UPDATE, INSERT and DELETE statements are allowed.");
                }
                ModificationStatement mst = (ModificationStatement)statement;
                if (mst.isCounter()) {
                    if (this.type != BatchStatement.Type.COUNTER) {
                        throw new InvalidRequestException("Cannot include counter statement in a non-counter batch");
                    }
                } else if (this.type == BatchStatement.Type.COUNTER) {
                    throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
                }
                statements.add(mst);
            }
            BatchStatement batch = new BatchStatement(-1, this.type, statements, Attributes.none());
            ResultMessage response = QueryProcessor.processBatch(batch, this.consistency, state, this.values);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BATCH of [");
        for (int i = 0; i < this.queryOrIdList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
        }
        sb.append("] at consistency ").append((Object)this.consistency);
        return sb.toString();
    }
}

