/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamWriter;
import org.apache.cassandra.streaming.compress.CompressedStreamReader;
import org.apache.cassandra.streaming.compress.CompressedStreamWriter;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.Pair;

public class FileMessage
extends StreamMessage {
    public static StreamMessage.Serializer<FileMessage> serializer = new StreamMessage.Serializer<FileMessage>(){

        @Override
        public FileMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            FileMessageHeader header = FileMessageHeader.serializer.deserialize(input, version);
            StreamReader reader = header.compressionInfo == null ? new StreamReader(header, session) : new CompressedStreamReader(header, session);
            try {
                return new FileMessage(reader.read(in), header);
            }
            catch (Throwable e) {
                session.doRetry(header, e);
                return null;
            }
        }

        @Override
        public void serialize(FileMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
            DataOutputStream output = new DataOutputStream(Channels.newOutputStream(out));
            FileMessageHeader.serializer.serialize(message.header, output, version);
            StreamWriter writer = message.header.compressionInfo == null ? new StreamWriter(message.sstable, message.header.sections, session) : new CompressedStreamWriter(message.sstable, message.header.sections, message.header.compressionInfo, session);
            writer.write(out);
            session.fileSent(message.header);
        }
    };
    public final FileMessageHeader header;
    public final SSTableReader sstable;

    public FileMessage(SSTableReader sstable, FileMessageHeader header) {
        super(StreamMessage.Type.FILE);
        this.header = header;
        this.sstable = sstable;
    }

    public FileMessage(SSTableReader sstable, int sequenceNumber, long estimatedKeys, List<Pair<Long, Long>> sections) {
        super(StreamMessage.Type.FILE);
        this.sstable = sstable;
        CompressionInfo compressionInfo = null;
        if (sstable.compression) {
            CompressionMetadata meta = sstable.getCompressionMetadata();
            compressionInfo = new CompressionInfo(meta.getChunksForSections(sections), meta.parameters);
        }
        this.header = new FileMessageHeader(sstable.metadata.cfId, sequenceNumber, sstable.descriptor.version.toString(), estimatedKeys, sections, compressionInfo);
    }

    public String toString() {
        return "FileMessage(" + this.sstable + ")";
    }
}

