/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecimalSerializer
implements TypeSerializer<BigDecimal> {
    public static final DecimalSerializer instance = new DecimalSerializer();

    @Override
    public BigDecimal deserialize(ByteBuffer bytes) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        bytes = bytes.duplicate();
        int scale = bytes.getInt();
        byte[] bibytes = new byte[bytes.remaining()];
        bytes.get(bibytes);
        BigInteger bi = new BigInteger(bibytes);
        return new BigDecimal(bi, scale);
    }

    @Override
    public ByteBuffer serialize(BigDecimal value) {
        int i;
        if (value == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        BigInteger bi = value.unscaledValue();
        Integer scale = value.scale();
        byte[] bibytes = bi.toByteArray();
        byte[] sbytes = ByteBufferUtil.bytes(scale).array();
        byte[] bytes = new byte[bi.toByteArray().length + 4];
        for (i = 0; i < 4; ++i) {
            bytes[i] = sbytes[i];
        }
        for (i = 4; i < bibytes.length + 4; ++i) {
            bytes[i] = bibytes[i - 4];
        }
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 0 && bytes.remaining() < 4) {
            throw new MarshalException(String.format("Expected 0 or at least 4 bytes (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(BigDecimal value) {
        return value == null ? "" : value.toPlainString();
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }
}

